/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.widget;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewParent;
import com.powyin.scroll.widget.SwipeNest;
import com.powyin.scroll.widget.SwipeRefresh;
import com.powyin.scroll.widget.ViewUtils;

class LoadProgressBar
extends View {
    ValueAnimator animator;
    Paint circlePaint = new Paint();
    int canvasWei;
    int canvasHei;
    int ballCount = 8;
    float divide;

    public LoadProgressBar(Context context) {
        this(context, null);
    }

    public LoadProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LoadProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.circlePaint.setColor(-1728053248);
        this.circlePaint.setStrokeWidth(4.0f);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.getMeasuredWidth(), ViewUtils.dip2px(this.getContext(), 40.0f));
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (int i = 0; i < this.ballCount; ++i) {
            float wei = 4.0f * (1.0f * (float)i / (float)this.ballCount - 0.5f) + this.divide;
            wei = (float)(this.canvasWei / 2) + this.getSplit(wei) * (float)this.canvasWei * 0.08f;
            canvas.drawCircle(wei, (float)(this.canvasHei / 2), 8.0f, this.circlePaint);
        }
    }

    void ensureAnimation() {
        this.ensureAnimation(false);
    }

    private void ensureAnimation(boolean forceReStart) {
        if (forceReStart) {
            if (this.animator != null) {
                this.animator.cancel();
            }
        } else if (this.animator != null && this.animator.isRunning()) {
            return;
        }
        this.animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.animator.setDuration(2000L);
        this.animator.setRepeatCount(5);
        this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                LoadProgressBar.this.divide = (float)(8L * (System.currentTimeMillis() % 3000L - 1500L)) / 3000.0f;
                LoadProgressBar.this.invalidate();
            }
        });
        this.animator.addListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                ViewParent parent;
                for (parent = LoadProgressBar.this.getParent(); parent != null && !(parent instanceof SwipeRefresh) && !(parent instanceof SwipeNest); parent = parent.getParent()) {
                }
                if (parent == null) {
                    return;
                }
                View viewParent = (View)parent;
                if (viewParent.getScrollY() > 0 && animation == LoadProgressBar.this.animator) {
                    LoadProgressBar.this.ensureAnimation(true);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        this.animator.start();
    }

    private float getSplit(float value) {
        int positive = value >= 0.0f ? 1 : -1;
        if ((value = Math.abs(value)) <= 1.0f) {
            return value * (float)positive;
        }
        return (float)Math.pow(value, 2.0) * (float)positive;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.canvasWei = right - left;
        this.canvasHei = bottom - top;
        this.ensureAnimation();
    }
}

