/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.widget;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.TextView;
import com.powyin.scroll.R;
import com.powyin.scroll.widget.CircleViewBac;
import com.powyin.scroll.widget.SwipeControl;

public class DefaultSwipeControl
implements SwipeControl {
    private Context mContent;
    private View rootView;
    private CircleViewBac statusPre;
    private ImageView statusLoad;
    private ImageView statusComplete;
    private TextView textInfo;

    DefaultSwipeControl(Context context) {
        this.mContent = context;
        this.rootView = LayoutInflater.from((Context)context).inflate(R.layout.powyin_scroll_default_head_swipe, null);
        this.statusPre = (CircleViewBac)this.rootView.findViewById(R.id.swipe_image_info);
        this.statusLoad = (ImageView)this.rootView.findViewById(R.id.swipe_refresh);
        this.statusComplete = (ImageView)this.rootView.findViewById(R.id.swipe_ok);
        this.textInfo = (TextView)this.rootView.findViewById(R.id.swipe_text_info);
    }

    @Override
    public View getSwipeView() {
        return this.rootView;
    }

    @Override
    public int getOverScrollHei() {
        return 300;
    }

    @Override
    public void onSwipeStatue(SwipeControl.SwipeStatus status, int visibleHei, int wholeHei) {
        switch (status) {
            case SWIPE_OVER: {
                this.statusPre.setVisibility(0);
                this.statusPre.setProgress(1.0f);
                this.statusLoad.clearAnimation();
                this.statusLoad.setVisibility(4);
                this.statusComplete.setVisibility(4);
                this.textInfo.setText((CharSequence)"\u677e\u5f00\u5237\u65b0");
                break;
            }
            case SWIPE_TOAST: {
                this.statusPre.setVisibility(0);
                this.statusLoad.clearAnimation();
                this.statusLoad.setVisibility(4);
                this.statusComplete.setVisibility(4);
                float radio = 1.0f * (float)(visibleHei - this.textInfo.getHeight()) / (float)this.statusPre.getHeight();
                this.statusPre.setProgress(radio);
                this.textInfo.setText((CharSequence)"\u4e0a\u62c9\u5237\u65b0");
                break;
            }
            case SWIPE_LOADING: {
                this.statusPre.setVisibility(4);
                if (this.statusLoad.getVisibility() != 0) {
                    this.statusLoad.setVisibility(0);
                    this.statusLoad.setAnimation(AnimationUtils.loadAnimation((Context)this.mContent, (int)R.anim.powyin_scroll_rotale));
                }
                this.statusComplete.setVisibility(4);
                this.textInfo.setText((CharSequence)"\u6b63\u5728\u62fc\u547d\u5237\u65b0\u4e2d");
                break;
            }
            case SWIPE_COMPLETE: {
                this.statusPre.setVisibility(4);
                this.statusLoad.clearAnimation();
                this.statusLoad.setVisibility(4);
                this.statusComplete.setVisibility(0);
                this.textInfo.setText((CharSequence)"\u5237\u65b0\u6210\u529f");
            }
        }
    }
}

