/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.powyinScroll.edge;

import android.graphics.Canvas;

public abstract class EdgeController {
    protected int mOrgHei;
    protected int mShowHeight;
    protected int mExpandHeight;
    protected int mScroll = 0;

    public void setSize(int orgHei, int showHeight, int expandHeight) {
        this.mOrgHei = orgHei;
        this.mShowHeight = showHeight;
        this.mExpandHeight = expandHeight;
        this.mScroll = 0;
    }

    public abstract void onPullProgress(Canvas var1);

    public int getExpandHeight() {
        return this.mExpandHeight;
    }

    public int getShowHeight() {
        return this.mShowHeight;
    }

    public int getOrgHeight() {
        return this.mOrgHei;
    }

    public int getScroll() {
        return this.mScroll;
    }

    public void setScroll(int scroll) {
        this.mScroll = scroll;
    }

    public boolean isOverScroll() {
        if (this.checkLegalLeft(this.mScroll)) {
            return this.mScroll < this.mShowHeight;
        }
        if (this.checkLegalRight(this.mScroll)) {
            return this.mScroll > this.mShowHeight;
        }
        return false;
    }

    public boolean canScroll() {
        return this.checkLegalLeft(this.mScroll) || this.checkLegalRight(this.mScroll);
    }

    private boolean checkLegalRight(int willTo) {
        return this.mOrgHei <= willTo && willTo <= this.mExpandHeight;
    }

    private boolean checkLegalLeft(int willTo) {
        return this.mExpandHeight <= willTo && willTo <= this.mOrgHei;
    }

    public int move(int deltaY) {
        int willTo = deltaY + this.mScroll;
        int consumed = 0;
        if (this.checkLegalLeft(this.mScroll)) {
            if (willTo < this.mExpandHeight) {
                willTo = this.mExpandHeight;
            }
            if (willTo > this.mOrgHei) {
                willTo = this.mOrgHei;
            }
            consumed = willTo - this.mScroll;
            this.mScroll = willTo;
            return consumed;
        }
        if (this.checkLegalRight(this.mScroll)) {
            if (willTo > this.mExpandHeight) {
                willTo = this.mExpandHeight;
            }
            if (willTo < this.mOrgHei) {
                willTo = this.mOrgHei;
            }
            consumed = willTo - this.mScroll;
            this.mScroll = willTo;
            return consumed;
        }
        return consumed;
    }

    public boolean isOverHeight() {
        return this.mScroll < 0;
    }
}

