/*
 * Decompiled with CFR 0.152.
 */
package com.poovam.pinedittextfield;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.Editable;
import android.util.AttributeSet;
import android.view.View;
import androidx.core.content.ContextCompat;
import com.poovam.pinedittextfield.PinField;
import com.poovam.pinedittextfield.R;
import com.poovam.pinedittextfield.Util;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u0001:\u0001/B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\"\u001a\u00020\tH\u0002J\b\u0010#\u001a\u00020\fH\u0002J\b\u0010$\u001a\u00020\tH\u0002J\u0010\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020\tH\u0002J\u0018\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\tH\u0014J\u0010\u0010*\u001a\u00020+2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010,\u001a\u00020+2\b\u0010-\u001a\u0004\u0018\u00010.H\u0014R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u000fR$\u0010\u0014\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR$\u0010\u001f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0012\"\u0004\b!\u0010\u000f\u00a8\u00060"}, d2={"Lcom/poovam/pinedittextfield/CirclePinField;", "Lcom/poovam/pinedittextfield/PinField;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attr", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "value", "", "actuallyUsedFillerRadius", "setActuallyUsedFillerRadius", "(F)V", "circleRadiusDp", "getCircleRadiusDp", "()F", "setCircleRadiusDp", "fillerColor", "getFillerColor", "()I", "setFillerColor", "(I)V", "fillerPaint", "Landroid/graphics/Paint;", "getFillerPaint", "()Landroid/graphics/Paint;", "setFillerPaint", "(Landroid/graphics/Paint;)V", "fillerRadius", "getFillerRadius", "setFillerRadius", "getCircleDiameterWithPadding", "getPadding", "getThickness", "getViewHeight", "height", "getViewWidth", "desiredWidth", "widthMeasureSpec", "initParams", "", "onDraw", "canvas", "Landroid/graphics/Canvas;", "Companion", "app_release"})
public final class CirclePinField
extends PinField {
    private int fillerColor;
    private float fillerRadius;
    private float actuallyUsedFillerRadius;
    private float circleRadiusDp;
    @NotNull
    private Paint fillerPaint;
    private static final float DEFAULT_FILLER_RADIUS;
    @NotNull
    public static final Companion Companion;

    public final int getFillerColor() {
        return this.fillerColor;
    }

    public final void setFillerColor(int value) {
        this.fillerColor = value;
        this.fillerPaint.setColor(this.fillerColor);
        this.invalidate();
    }

    public final float getFillerRadius() {
        return this.fillerRadius;
    }

    public final void setFillerRadius(float value) {
        this.fillerRadius = value;
        this.setActuallyUsedFillerRadius(this.fillerRadius);
        this.invalidate();
    }

    private final void setActuallyUsedFillerRadius(float value) {
        this.actuallyUsedFillerRadius = this.fillerRadius == DEFAULT_FILLER_RADIUS ? this.circleRadiusDp - this.getHighLightThickness() : this.fillerRadius;
    }

    public final float getCircleRadiusDp() {
        return this.circleRadiusDp;
    }

    public final void setCircleRadiusDp(float value) {
        this.circleRadiusDp = value;
        this.invalidate();
    }

    @NotNull
    public final Paint getFillerPaint() {
        return this.fillerPaint;
    }

    public final void setFillerPaint(@NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)paint, (String)"<set-?>");
        this.fillerPaint = paint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initParams(AttributeSet attr) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        TypedArray a = context.getTheme().obtainStyledAttributes(attr, R.styleable.CirclePinField, 0, 0);
        try {
            this.setCircleRadiusDp(a.getDimension(R.styleable.CirclePinField_circleRadius, this.circleRadiusDp));
            this.setFillerColor(a.getColor(R.styleable.CirclePinField_fillerColor, this.fillerColor));
            this.setFillerRadius(a.getDimension(R.styleable.CirclePinField_fillerRadius, this.fillerRadius));
            if (this.getDistanceInBetween() == -1.0f) {
                this.setDistanceInBetween(Util.dpToPx(30.0f));
            }
        }
        finally {
            a.recycle();
        }
    }

    @Override
    protected int getViewWidth(int desiredWidth, int widthMeasureSpec) {
        int n;
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int viewWidth = this.getCircleDiameterWithPadding() * this.getNumberOfFields();
        switch (widthMode) {
            case 0x40000000: {
                n = widthSize;
                break;
            }
            case -2147483648: {
                n = Math.min(viewWidth, widthSize);
                break;
            }
            case 0: {
                n = viewWidth;
                break;
            }
            default: {
                n = viewWidth;
            }
        }
        return n;
    }

    private final int getCircleDiameterWithPadding() {
        float diameter = this.circleRadiusDp * (float)2;
        return Math.round(diameter + (float)this.getThickness() + this.getPadding());
    }

    private final int getThickness() {
        return Math.round(!this.highlightNoFields() ? this.getHighLightThickness() : this.getLineThickness());
    }

    private final float getPadding() {
        return this.getDistanceInBetween() != -1.0f ? this.getDistanceInBetween() : this.getDefaultDistanceInBetween() / (float)2;
    }

    /*
     * WARNING - void declaration
     */
    protected void onDraw(@Nullable Canvas canvas) {
        int n = 0;
        int n2 = this.getNumberOfFields();
        while (n < n2) {
            void i;
            int startingX = (this.getWidth() - this.getCircleDiameterWithPadding() * this.getNumberOfFields()) / 2;
            startingX = startingX > 0 ? startingX : 0;
            float x1 = (float)this.getCircleDiameterWithPadding() * (float)i + (float)(this.getCircleDiameterWithPadding() / 2) + (float)startingX;
            Editable editable = this.getText();
            Character character = editable != null ? StringsKt.getOrNull((CharSequence)((CharSequence)editable), (int)i) : null;
            float y1 = this.getViewHeight(this.getHeight());
            Canvas canvas2 = canvas;
            if (canvas2 != null) {
                canvas2.drawCircle(x1, y1, this.circleRadiusDp, this.getFieldBgPaint());
            }
            if (this.highlightAllFields() && this.hasFocus()) {
                Canvas canvas3 = canvas;
                if (canvas3 != null) {
                    canvas3.drawCircle(x1, y1, this.circleRadiusDp, this.getHighlightPaint());
                }
            } else {
                Canvas canvas4 = canvas;
                if (canvas4 != null) {
                    canvas4.drawCircle(x1, y1, this.circleRadiusDp, this.getFieldPaint());
                }
            }
            if (character != null) {
                Canvas canvas5 = canvas;
                if (canvas5 != null) {
                    canvas5.drawCircle(x1, y1, this.actuallyUsedFillerRadius, this.fillerPaint);
                }
            }
            Editable editable2 = this.getText();
            this.highlightLogic((int)i, editable2 != null ? Integer.valueOf(editable2.length()) : null, (Function0<Unit>)((Function0)new Function0<Unit>(this, canvas, x1, y1){
                final /* synthetic */ CirclePinField this$0;
                final /* synthetic */ Canvas $canvas;
                final /* synthetic */ float $x1;
                final /* synthetic */ float $y1;

                public final void invoke() {
                    block0: {
                        Canvas canvas = this.$canvas;
                        if (canvas == null) break block0;
                        canvas.drawCircle(this.$x1, this.$y1, this.this$0.getCircleRadiusDp(), this.this$0.getHighlightPaint());
                    }
                }
                {
                    this.this$0 = circlePinField;
                    this.$canvas = canvas;
                    this.$x1 = f;
                    this.$y1 = f2;
                    super(0);
                }
            }));
            ++i;
        }
    }

    private final float getViewHeight(int height) {
        if (!this.isCustomBackground() && this.getLayoutParams().height == -2 && this.getPadding() < this.circleRadiusDp) {
            return (float)((double)height - (double)this.getPadding() * 1.5);
        }
        return (float)height / (float)2;
    }

    public CirclePinField(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.fillerColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.pinFieldLibraryAccent);
        this.actuallyUsedFillerRadius = this.fillerRadius = DEFAULT_FILLER_RADIUS;
        this.circleRadiusDp = Util.dpToPx(10.0f);
        this.fillerPaint = new Paint(this.getFieldPaint());
        this.fillerPaint.setStyle(Paint.Style.FILL);
    }

    public CirclePinField(@NotNull Context context, @NotNull AttributeSet attr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        super(context, attr);
        this.fillerColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.pinFieldLibraryAccent);
        this.actuallyUsedFillerRadius = this.fillerRadius = DEFAULT_FILLER_RADIUS;
        this.circleRadiusDp = Util.dpToPx(10.0f);
        this.fillerPaint = new Paint(this.getFieldPaint());
        this.fillerPaint.setStyle(Paint.Style.FILL);
        this.initParams(attr);
    }

    public CirclePinField(@NotNull Context context, @NotNull AttributeSet attr, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        super(context, attr, defStyle);
        this.fillerColor = ContextCompat.getColor((Context)this.getContext(), (int)R.color.pinFieldLibraryAccent);
        this.actuallyUsedFillerRadius = this.fillerRadius = DEFAULT_FILLER_RADIUS;
        this.circleRadiusDp = Util.dpToPx(10.0f);
        this.fillerPaint = new Paint(this.getFieldPaint());
        this.fillerPaint.setStyle(Paint.Style.FILL);
        this.initParams(attr);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_FILLER_RADIUS = -1.0f;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/poovam/pinedittextfield/CirclePinField$Companion;", "", "()V", "DEFAULT_FILLER_RADIUS", "", "app_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

