/*
 * Decompiled with CFR 0.152.
 */
package com.github.plexpt.chatgpt;

import com.alibaba.fastjson2.JSON;
import com.github.plexpt.chatgpt.Session;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import okhttp3.Response;

public class OpenAIAuth {
    private String sessionToken = null;
    private String emailAddress;
    private String password;
    private boolean useProxy;
    private String proxy;
    private Session session;
    private String accessToken;

    public OpenAIAuth(String emailAddress, String password, boolean useProxy, String proxy) {
        this.emailAddress = emailAddress;
        this.password = password;
        this.useProxy = useProxy;
        this.proxy = proxy;
        this.session = new Session();
        this.accessToken = null;
    }

    public static String urlEncode(String string) {
        return URLEncoder.encode(string);
    }

    public void begin() {
        if (this.emailAddress == null || this.password == null) {
            return;
        }
        if (this.useProxy) {
            if (this.proxy == null) {
                return;
            }
            HashMap<String, String> proxies = new HashMap<String, String>(){
                {
                    this.put("http", OpenAIAuth.this.proxy);
                    this.put("https", OpenAIAuth.this.proxy);
                }
            };
            this.session.setProxies((Map<String, String>)proxies);
        }
        String url = "https://chat.openai.com/auth/login";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Host", "ask.openai.com");
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        headers.put("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.1 Safari/605.1.15");
        headers.put("Accept-Language", "en-GB,en-US;q=0.9,en;q=0.8");
        headers.put("Accept-Encoding", "gzip, deflate, br");
        headers.put("Connection", "keep-alive");
        Response response = this.session.get(url, headers);
        if (response.code() != 200) {
            throw new RuntimeException("Error logging in");
        }
        this.partTwo();
    }

    private void partTwo() {
        String url = "https://chat.openai.com/api/auth/csrf";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Host", "ask.openai.com");
        headers.put("Accept", "*/*");
        headers.put("Connection", "keep-alive");
        headers.put("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.1 Safari/605.1.15");
        headers.put("Accept-Language", "en-GB,en-US;q=0.9,en;q=0.8");
        headers.put("Referer", "https://chat.openai.com/auth/login");
        headers.put("Accept-Encoding", "gzip, deflate, br");
        String response = this.session.getString(url, headers);
        String csrfToken = JSON.parseObject((String)response).getString("csrfToken");
        System.out.println("csrfToken: " + csrfToken);
        this.partThree(csrfToken);
    }

    public void partThree(String token) {
        String url = "https://chat.openai.com/api/auth/signin/auth0?prompt=login";
        String payload = "callbackUrl=%2F&csrfToken=" + token + "&json=true";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Host", "ask.openai.com");
        headers.put("Origin", "https://chat.openai.com");
        headers.put("Connection", "keep-alive");
        headers.put("Accept", "*/*");
        headers.put("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.1 Safari/605.1.15");
        headers.put("Referer", "https://chat.openai.com/auth/login");
        headers.put("Content-Length", "100");
        headers.put("Accept-Language", "en-GB,en-US;q=0.9,en;q=0.8");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        Response response = this.session.post(url, headers, payload);
        if (response.code() != 200 || !response.headers().names().contains("Content-Type") || !response.header("Content-Type").contains("json")) {
            if (response.code() == 400) {
                throw new RuntimeException("Invalid credentials");
            }
            throw new RuntimeException("Unknown error");
        }
        String url2 = JSON.parseObject((String)response.toString()).getString("url");
        this.partFour(url2);
    }

    public void partFour(String url) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Host", "auth0.openai.com");
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        headers.put("Connection", "keep-alive");
        headers.put("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.1 Safari/605.1.15");
        headers.put("Accept-Language", "en-US,en;q=0.9");
        headers.put("Referer", "https://chat.openai.com/");
        Response response = this.session.get(url, headers);
        if (response.code() != 302) {
            throw new RuntimeException("Unknown error");
        }
        String state = Pattern.compile("state=(.*)").matcher(response.body().toString()).group(1);
        state = state.split("\"")[0];
        this.partFive(state);
    }

    public void partFive(String state) {
        String url = String.format("https://auth0.openai.com/u/login/identifier?state=%s", state);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Host", "auth0.openai.com");
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        headers.put("Connection", "keep-alive");
        headers.put("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.1 Safari/605.1.15");
        headers.put("Accept-Language", "en-US,en;q=0.9");
        headers.put("Referer", "https://chat.openai.com/");
        Response response = this.session.get(url, headers);
        if (response.code() == 200) {
            if (Pattern.compile("<img[^>]+alt=\"captcha\"[^>]+>").matcher(response.body().toString()).find()) {
                System.out.println("Captcha detected");
                throw new RuntimeException("Captcha detected");
            }
        } else {
            throw new RuntimeException("Invalid response code");
        }
        this.partSix(state, null);
    }

    public void partSix(String state, String captcha) {
        String url = String.format("https://auth0.openai.com/u/login/identifier?state=%s", state);
        String emailUrlEncoded = OpenAIAuth.urlEncode(this.emailAddress);
        String payload = String.format("state=%s&username=%s&captcha=%s&js-available=true&webauthn-available=true&is-brave=false&webauthn-platform-available=true&action=default ", state, emailUrlEncoded, captcha);
        if (captcha == null) {
            payload = String.format("state=%s&username=%s&js-available=false&webauthn-available=true&is-brave=false&webauthn-platform-available=true&action=default ", state, emailUrlEncoded);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Host", "auth0.openai.com");
        headers.put("Origin", "https://auth0.openai.com");
        headers.put("Connection", "keep-alive");
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        headers.put("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.1 Safari/605.1.15");
        headers.put("Referer", String.format("https://auth0.openai.com/u/login/identifier?state=%s", state));
        headers.put("Accept-Language", "en-US,en;q=0.9");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        Response response = this.session.post(url, headers, payload);
        if (response.code() != 302) {
            throw new RuntimeException("Unknown error");
        }
        this.partSeven(state);
    }

    public void partSeven(String state) {
        boolean is302;
        String url = String.format("https://auth0.openai.com/u/login/password?state=%s", state);
        String emailUrlEncoded = OpenAIAuth.urlEncode(this.emailAddress);
        String passwordUrlEncoded = OpenAIAuth.urlEncode(this.password);
        String payload = String.format("state=%s&username=%s&password=%s&action=default", state, emailUrlEncoded, passwordUrlEncoded);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Host", "auth0.openai.com");
        headers.put("Origin", "https://auth0.openai.com");
        headers.put("Connection", "keep-alive");
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        headers.put("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.1 Safari/605.1.15");
        headers.put("Referer", String.format("https://auth0.openai.com/u/login/password?state=%s", state));
        headers.put("Accept-Language", "en-US,en;q=0.9");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        Response response = this.session.post(url, headers, payload);
        boolean bl = is302 = response.code() == 302;
        if (!is302) {
            throw new RuntimeException("Unknown error");
        }
        String newStateArray = response.body().toString().split("state=")[0].split("\"")[0];
        this.partEight(state, newStateArray);
    }

    private void partEight(String oldState, String newState) {
        Matcher matcher;
        boolean is200;
        String url = "https://auth0.openai.com/authorize/resume?state=" + newState;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Host", "auth0.openai.com");
        headers.put("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        headers.put("Connection", "keep-alive");
        headers.put("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.1 Safari/605.1.15");
        headers.put("Accept-Language", "en-GB,en-US;q=0.9,en;q=0.8");
        headers.put("Referer", "https://auth0.openai.com/u/login/password?state=" + oldState);
        Response response = this.session.get(url, headers, true);
        boolean bl = is200 = response.code() == 200;
        if (is200) {
            Pattern pattern = Pattern.compile("accessToken\":\"(.*)\"");
            matcher = pattern.matcher(response.body().toString());
            if (!matcher.find()) {
                System.out.println("Invalid credentials");
                throw new RuntimeException("Invalid credentials");
            }
        } else {
            System.out.println("Invalid credentials");
            throw new RuntimeException("Failed to find accessToken");
        }
        this.saveAccessToken(matcher.group());
    }

    public void saveAccessToken(String accessToken) {
        if (!this.partNine()) {
            System.out.println("Failed to login");
            throw new RuntimeException("Failed to login");
        }
        this.accessToken = accessToken;
    }

    public boolean partNine() {
        boolean is200;
        String url = "https://auth0.openai.com/user/ssodata";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Host", "auth0.openai.com");
        headers.put("Connection", "keep-alive");
        headers.put("Accept", "application/json, text/javascript, */*; q=0.01");
        headers.put("User-Agent", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.1 Safari/605.1.15");
        headers.put("Referer", "https://auth0.openai.com/authorize/resume");
        headers.put("Accept-Language", "en-GB,en-US;q=0.9,en;q=0.8");
        headers.put("Content-Type", "application/x-www-form-urlencoded");
        Response response = this.session.get(url, headers);
        boolean bl = is200 = response.code() == 200;
        return is200;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    public String getProxy() {
        return this.proxy;
    }

    public Session getSession() {
        return this.session;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenAIAuth)) {
            return false;
        }
        OpenAIAuth other = (OpenAIAuth)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUseProxy() != other.isUseProxy()) {
            return false;
        }
        String this$sessionToken = this.getSessionToken();
        String other$sessionToken = other.getSessionToken();
        if (this$sessionToken == null ? other$sessionToken != null : !this$sessionToken.equals(other$sessionToken)) {
            return false;
        }
        String this$emailAddress = this.getEmailAddress();
        String other$emailAddress = other.getEmailAddress();
        if (this$emailAddress == null ? other$emailAddress != null : !this$emailAddress.equals(other$emailAddress)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$proxy = this.getProxy();
        String other$proxy = other.getProxy();
        if (this$proxy == null ? other$proxy != null : !this$proxy.equals(other$proxy)) {
            return false;
        }
        Session this$session = this.getSession();
        Session other$session = other.getSession();
        if (this$session == null ? other$session != null : !((Object)this$session).equals(other$session)) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        return !(this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenAIAuth;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUseProxy() ? 79 : 97);
        String $sessionToken = this.getSessionToken();
        result = result * 59 + ($sessionToken == null ? 43 : $sessionToken.hashCode());
        String $emailAddress = this.getEmailAddress();
        result = result * 59 + ($emailAddress == null ? 43 : $emailAddress.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $proxy = this.getProxy();
        result = result * 59 + ($proxy == null ? 43 : $proxy.hashCode());
        Session $session = this.getSession();
        result = result * 59 + ($session == null ? 43 : ((Object)$session).hashCode());
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        return result;
    }

    public String toString() {
        return "OpenAIAuth(sessionToken=" + this.getSessionToken() + ", emailAddress=" + this.getEmailAddress() + ", password=" + this.getPassword() + ", useProxy=" + this.isUseProxy() + ", proxy=" + this.getProxy() + ", session=" + this.getSession() + ", accessToken=" + this.getAccessToken() + ")";
    }
}

