/*
 * Decompiled with CFR 0.152.
 */
package com.github.plexpt.chatgpt;

import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.github.plexpt.chatgpt.Config;
import com.github.plexpt.chatgpt.Session;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import okhttp3.Response;

public class Chatbot {
    private String conversationId = null;
    private String sessionToken;
    private String authorization = "";
    private String cfClearance;
    private String userAgent;
    private String parentId;
    private Map<String, String> headers = new HashMap<String, String>();
    private String conversationIdPrev;
    private String parentIdPrev;

    public Chatbot(Config config) {
        this(config, null);
    }

    public Chatbot(Config config, String conversationId) {
        this.sessionToken = config.getSession_token();
        this.cfClearance = config.getCfClearance();
        this.userAgent = config.getUserAgent();
        this.conversationId = conversationId;
        this.parentId = UUID.randomUUID().toString();
        if (StrUtil.isNotEmpty((CharSequence)this.sessionToken)) {
            this.refreshSession();
        }
    }

    public Chatbot(String sessionToken, String cfClearance, String userAgent) {
        this.userAgent = userAgent;
        this.cfClearance = cfClearance;
        this.sessionToken = sessionToken;
        this.parentId = UUID.randomUUID().toString();
        this.refreshSession();
    }

    public void resetChat() {
        this.conversationId = null;
        this.parentId = UUID.randomUUID().toString();
    }

    public void refreshHeaders() {
        if (StrUtil.isEmpty((CharSequence)this.authorization)) {
            this.authorization = "";
        }
        this.headers = new HashMap<String, String>(){
            {
                this.put("Host", "chat.openai.com");
                this.put("Accept", "text/event-stream");
                this.put("Authorization", "Bearer " + Chatbot.this.authorization);
                this.put("Content-Type", "application/json");
                this.put("User-Agent", Chatbot.this.userAgent);
                this.put("X-Openai-Assistant-App-Id", "");
                this.put("Connection", "close");
                this.put("Accept-Language", "en-US,en;q=0.9");
                this.put("Referer", "https://chat.openai.com/chat");
            }
        };
    }

    Map<String, Object> getChatStream(Map<String, Object> data) {
        String url = "https://chat.openai.com/backend-api/conversation";
        String body = ((HttpRequest)HttpUtil.createPost((String)url).headerMap(this.headers, true)).body(JSON.toJSONString(data), "application/json").execute().body();
        String message = "";
        HashMap<String, Object> chatData = new HashMap<String, Object>();
        for (String s : body.split("\n")) {
            if (s == null || "".equals(s) || s.contains("data: [DONE]")) continue;
            String part = s.substring(5);
            JSONObject lineData = JSON.parseObject((String)part);
            try {
                JSONArray jsonArray = lineData.getJSONObject("message").getJSONObject("content").getJSONArray("parts");
                if (jsonArray.size() == 0) continue;
                message = jsonArray.getString(0);
                this.conversationId = lineData.getString("conversation_id");
                this.parentId = lineData.getJSONObject("message").getString("id");
                chatData.put("message", message);
                chatData.put("conversation_id", this.conversationId);
                chatData.put("parent_id", this.parentId);
            }
            catch (Exception e) {
                System.out.println("getChatStream Exception: " + part);
            }
        }
        return chatData;
    }

    public Map<String, Object> getChatText(Map<String, Object> data) {
        Session session = new Session();
        session.setHeaders(this.headers);
        session.getCookies().put("__Secure-next-auth.session-token", this.sessionToken);
        session.getCookies().put("__Secure-next-auth.callback-url", "https://chat.openai.com/");
        session.getCookies().put("cf_clearance", this.cfClearance);
        this.setupProxy(session);
        HttpResponse response = session.post2("https://chat.openai.com/backend-api/conversation", data);
        String body = response.body();
        String errorDesc = "";
        String message = "";
        HashMap<String, Object> chatData = new HashMap<String, Object>();
        for (String s : body.split("\n")) {
            if (s == null || "".equals(s) || s.contains("data: [DONE]")) continue;
            String part = s.substring(5);
            try {
                JSONObject lineData = JSON.parseObject((String)part);
                JSONArray jsonArray = lineData.getJSONObject("message").getJSONObject("content").getJSONArray("parts");
                if (jsonArray.size() == 0) continue;
                message = jsonArray.getString(0);
                this.conversationId = lineData.getString("conversation_id");
                this.parentId = lineData.getJSONObject("message").getString("id");
                chatData.put("message", message);
                chatData.put("conversation_id", this.conversationId);
                chatData.put("parent_id", this.parentId);
            }
            catch (Exception e) {
                System.out.println("getChatStream Exception: " + part);
            }
        }
        return chatData;
    }

    private void setupProxy(Session session) {
    }

    public Map<String, Object> getChatResponse(String prompt, String output) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("action", "next");
        data.put("conversation_id", this.conversationId);
        data.put("parent_message_id", this.parentId);
        data.put("model", "text-davinci-002-render");
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("id", UUID.randomUUID().toString());
        message.put("role", "user");
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("content_type", "text");
        content.put("parts", Collections.singletonList(prompt));
        message.put("content", content);
        data.put("messages", Collections.singletonList(message));
        this.conversationIdPrev = this.conversationId;
        this.parentIdPrev = this.parentId;
        if (output.equals("text")) {
            return this.getChatText(data);
        }
        if (output.equals("stream")) {
            return this.getChatStream(data);
        }
        throw new RuntimeException("Output must be either 'text' or 'stream'");
    }

    public Map<String, Object> getChatResponse(String prompt) {
        return this.getChatResponse(prompt, "text");
    }

    public void refreshSession() {
        if (this.sessionToken == null || this.sessionToken.equals("")) {
            throw new RuntimeException("No tokens provided");
        }
        Session session = new Session();
        this.setupProxy(session);
        session.getCookies().put("__Secure-next-auth.session-token", this.sessionToken);
        session.getCookies().put("cf_clearance", this.cfClearance);
        String cookiesString = session.getCookiesString();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("User-Agent", this.userAgent);
        map.put("cookie", cookiesString);
        map.put("Cookie", cookiesString);
        session.setHeaders(map);
        String urlSession = "https://chat.openai.com/api/auth/session";
        HttpResponse response = session.get2(urlSession);
        if (response.getStatus() != 200) {
            System.err.println("err code: " + response.getStatus());
            System.err.println("cf_clearance: " + this.cfClearance);
            System.err.println("token: " + this.sessionToken);
            System.err.println("userAgent: " + this.userAgent);
            System.err.println("\u8bf7\u68c0\u67e5\u4ee5\u4e0a\u53c2\u6570\u662f\u5426\u6b63\u786e\uff0c\u662f\u5426\u8fc7\u671f\u3002\u5e76\u4e14\u83b7\u53d6\u4ee5\u4e0a\u53c2\u6570\u7684\u6d4f\u89c8\u5668\u8981\u548c\u672c\u7a0b\u5e8f\u5728\u540c\u4e00IP\u5730\u5740");
            System.err.println("Please check whether the above parameters are correct or expired. And the browser that obtains the above parameters must be at the same IP address as this program");
            return;
        }
        try {
            String cookieValue;
            String name = "__Secure-next-auth.session-token";
            this.sessionToken = cookieValue = response.getCookieValue(name);
            String body = response.body();
            System.out.println("session_token: " + cookieValue);
            JSONObject responseObject = JSON.parseObject((String)body);
            String accessToken = responseObject.getString("accessToken");
            System.out.println("accessToken: " + accessToken);
            this.authorization = accessToken;
            this.refreshHeaders();
        }
        catch (Exception e) {
            System.out.println("Error refreshing session");
            throw new Exception("Error refreshing session", e);
        }
    }

    public void rollbackConversation() {
        this.conversationId = this.conversationIdPrev;
        this.parentId = this.parentIdPrev;
    }

    public static JSONObject resJson(Response response) {
        JSONObject responseObject = null;
        String text = response.body().string();
        try {
            response.body().close();
            responseObject = JSON.parseObject((String)text);
        }
        catch (Exception e) {
            System.out.println("json err, body: " + text);
            throw new RuntimeException(e);
        }
        return responseObject;
    }

    public String getConversationId() {
        return this.conversationId;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public String getCfClearance() {
        return this.cfClearance;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getParentId() {
        return this.parentId;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getConversationIdPrev() {
        return this.conversationIdPrev;
    }

    public String getParentIdPrev() {
        return this.parentIdPrev;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    public void setCfClearance(String cfClearance) {
        this.cfClearance = cfClearance;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setConversationIdPrev(String conversationIdPrev) {
        this.conversationIdPrev = conversationIdPrev;
    }

    public void setParentIdPrev(String parentIdPrev) {
        this.parentIdPrev = parentIdPrev;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Chatbot)) {
            return false;
        }
        Chatbot other = (Chatbot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$conversationId = this.getConversationId();
        String other$conversationId = other.getConversationId();
        if (this$conversationId == null ? other$conversationId != null : !this$conversationId.equals(other$conversationId)) {
            return false;
        }
        String this$sessionToken = this.getSessionToken();
        String other$sessionToken = other.getSessionToken();
        if (this$sessionToken == null ? other$sessionToken != null : !this$sessionToken.equals(other$sessionToken)) {
            return false;
        }
        String this$authorization = this.getAuthorization();
        String other$authorization = other.getAuthorization();
        if (this$authorization == null ? other$authorization != null : !this$authorization.equals(other$authorization)) {
            return false;
        }
        String this$cfClearance = this.getCfClearance();
        String other$cfClearance = other.getCfClearance();
        if (this$cfClearance == null ? other$cfClearance != null : !this$cfClearance.equals(other$cfClearance)) {
            return false;
        }
        String this$userAgent = this.getUserAgent();
        String other$userAgent = other.getUserAgent();
        if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$conversationIdPrev = this.getConversationIdPrev();
        String other$conversationIdPrev = other.getConversationIdPrev();
        if (this$conversationIdPrev == null ? other$conversationIdPrev != null : !this$conversationIdPrev.equals(other$conversationIdPrev)) {
            return false;
        }
        String this$parentIdPrev = this.getParentIdPrev();
        String other$parentIdPrev = other.getParentIdPrev();
        return !(this$parentIdPrev == null ? other$parentIdPrev != null : !this$parentIdPrev.equals(other$parentIdPrev));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Chatbot;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $conversationId = this.getConversationId();
        result = result * 59 + ($conversationId == null ? 43 : $conversationId.hashCode());
        String $sessionToken = this.getSessionToken();
        result = result * 59 + ($sessionToken == null ? 43 : $sessionToken.hashCode());
        String $authorization = this.getAuthorization();
        result = result * 59 + ($authorization == null ? 43 : $authorization.hashCode());
        String $cfClearance = this.getCfClearance();
        result = result * 59 + ($cfClearance == null ? 43 : $cfClearance.hashCode());
        String $userAgent = this.getUserAgent();
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $conversationIdPrev = this.getConversationIdPrev();
        result = result * 59 + ($conversationIdPrev == null ? 43 : $conversationIdPrev.hashCode());
        String $parentIdPrev = this.getParentIdPrev();
        result = result * 59 + ($parentIdPrev == null ? 43 : $parentIdPrev.hashCode());
        return result;
    }

    public String toString() {
        return "Chatbot(conversationId=" + this.getConversationId() + ", sessionToken=" + this.getSessionToken() + ", authorization=" + this.getAuthorization() + ", cfClearance=" + this.getCfClearance() + ", userAgent=" + this.getUserAgent() + ", parentId=" + this.getParentId() + ", headers=" + this.getHeaders() + ", conversationIdPrev=" + this.getConversationIdPrev() + ", parentIdPrev=" + this.getParentIdPrev() + ")";
    }
}

