/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.poi.xssf.streaming;

import com.github.pjfanning.poi.xssf.streaming.Constants;
import com.github.pjfanning.poi.xssf.streaming.ReadOnlyXSSFComment;
import com.github.pjfanning.poi.xssf.streaming.SerializableComment;
import com.github.pjfanning.poi.xssf.streaming.TextParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.util.TempFile;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCommentList;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CommentsDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempFileCommentsTable
extends POIXMLDocumentPart
implements Comments,
AutoCloseable {
    private static Logger log = LoggerFactory.getLogger(TempFileCommentsTable.class);
    private File tempFile;
    private MVStore mvStore;
    private final boolean fullFormat;
    private final MVMap<String, SerializableComment> comments;
    private final MVMap<Integer, String> authors;
    private static final XmlOptions textSaveOptions = new XmlOptions(Constants.saveOptions);

    public TempFileCommentsTable() {
        this(false, false);
    }

    public TempFileCommentsTable(boolean encryptTempFiles) {
        this(encryptTempFiles, false);
    }

    public TempFileCommentsTable(boolean encryptTempFiles, boolean fullFormat) {
        this.fullFormat = fullFormat;
        try {
            this.tempFile = TempFile.createTempFile((String)"poi-comments", (String)".tmp");
            MVStore.Builder mvStoreBuilder = new MVStore.Builder();
            if (encryptTempFiles) {
                byte[] bytes = new byte[1024];
                Constants.RANDOM.nextBytes(bytes);
                mvStoreBuilder.encryptionKey(Base64.getEncoder().encodeToString(bytes).toCharArray());
            }
            mvStoreBuilder.fileName(this.tempFile.getAbsolutePath());
            this.mvStore = mvStoreBuilder.open();
            this.comments = this.mvStore.openMap("comments");
            this.authors = this.mvStore.openMap("authors");
        }
        catch (Error | RuntimeException e) {
            if (this.mvStore != null) {
                this.mvStore.closeImmediately();
            }
            if (this.tempFile != null && !this.tempFile.delete()) {
                log.debug("failed to delete temp file - probably already deleted");
            }
            throw e;
        }
        catch (Exception e) {
            if (this.mvStore != null) {
                this.mvStore.closeImmediately();
            }
            if (this.tempFile != null && !this.tempFile.delete()) {
                log.debug("failed to delete temp file - probably already deleted");
            }
            throw new RuntimeException(e);
        }
    }

    public TempFileCommentsTable(OPCPackage pkg, boolean encryptTempFiles) throws IOException {
        this(pkg, encryptTempFiles, false);
    }

    public TempFileCommentsTable(OPCPackage pkg, boolean encryptTempFiles, boolean fullFormat) throws IOException {
        this(encryptTempFiles, fullFormat);
        ArrayList parts = pkg.getPartsByContentType(XSSFRelation.SHEET_COMMENTS.getContentType());
        if (!parts.isEmpty()) {
            PackagePart sstPart = (PackagePart)parts.get(0);
            this.readFrom(sstPart.getInputStream());
        }
    }

    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        try (OutputStream out = part.getOutputStream();){
            this.writeTo(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFrom(InputStream is) throws IOException {
        try (XMLEventReader xmlEventReader = Constants.XML_INPUT_FACTORY.createXMLEventReader(is);){
            while (xmlEventReader.hasNext()) {
                XSSFRichTextString str;
                XMLEvent xmlEvent = xmlEventReader.nextEvent();
                if (!xmlEvent.isStartElement()) continue;
                StartElement se = xmlEvent.asStartElement();
                if (se.getName().getLocalPart().equals("author")) {
                    this.authors.put((Object)this.getNumberOfAuthors(), (Object)xmlEventReader.getElementText());
                    continue;
                }
                if (!se.getName().getLocalPart().equals("comment")) continue;
                String ref = se.getAttributeByName(new QName("ref")).getValue();
                String authorId = se.getAttributeByName(new QName("authorId")).getValue();
                if (this.fullFormat) {
                    try {
                        str = this.parseFullComment(xmlEventReader);
                    }
                    catch (XmlException e) {
                        throw new IOException("Failed to parse comment", e);
                    }
                } else {
                    str = new XSSFRichTextString(this.parseSimplifiedComment(xmlEventReader));
                }
                SerializableComment xc = new SerializableComment();
                xc.setAddress(new CellAddress(ref));
                xc.setAuthor((String)this.authors.get((Object)Integer.parseInt(authorId)));
                xc.setString((RichTextString)str);
                this.comments.put((Object)ref, (Object)xc);
            }
        }
        catch (XMLStreamException xse) {
            throw new IOException("Failed to parse comments", xse);
        }
    }

    public int getNumberOfComments() {
        return this.comments.size();
    }

    public int getNumberOfAuthors() {
        return this.authors.size();
    }

    public String getAuthor(long authorId) {
        return (String)this.authors.get((Object)((int)authorId));
    }

    public int findAuthor(String author) {
        Iterator authorIdIterator = this.authors.keyIterator(null);
        while (authorIdIterator.hasNext()) {
            String existingAuthor;
            Integer authorId = (Integer)authorIdIterator.next();
            String string = existingAuthor = authorId == null ? null : (String)this.authors.get((Object)authorId);
            if (!(existingAuthor == null ? author == null : existingAuthor.equals(author))) continue;
            return authorId;
        }
        int index = this.getNumberOfAuthors();
        this.authors.put((Object)index, (Object)author);
        return index;
    }

    public XSSFComment findCellComment(CellAddress cellAddress) {
        SerializableComment comment = (SerializableComment)this.comments.get((Object)cellAddress.formatAsString());
        return comment == null ? null : new ReadOnlyXSSFComment(comment);
    }

    public boolean removeComment(CellAddress cellRef) {
        throw new IllegalStateException("Not Implemented - this class only supports read-only view of Comments");
    }

    public Iterator<CellAddress> getCellAddresses() {
        final Iterator keyIterator = this.comments.keyIterator(null);
        return new Iterator<CellAddress>(){

            @Override
            public boolean hasNext() {
                return keyIterator.hasNext();
            }

            @Override
            public CellAddress next() {
                return new CellAddress((String)keyIterator.next());
            }
        };
    }

    @Override
    public void close() {
        if (this.mvStore != null) {
            this.mvStore.closeImmediately();
        }
        if (this.tempFile != null && !this.tempFile.delete()) {
            log.debug("failed to delete temp file - probably already deleted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        try {
            writer.write("<comments xmlns=\"");
            writer.write("http://schemas.openxmlformats.org/spreadsheetml/2006/main");
            writer.write("\"><authors>");
            Iterator authorIdIterator = this.authors.keyIterator(null);
            while (authorIdIterator.hasNext()) {
                Integer authorId = (Integer)authorIdIterator.next();
                String author = authorId == null ? null : (String)this.authors.get((Object)authorId);
                writer.write("<author>");
                writer.write(StringEscapeUtils.escapeXml11((String)author));
                writer.write("</author>");
            }
            writer.write("</authors>");
            writer.write("<commentList>");
            Iterator commentsRefIterator = this.comments.keyIterator(null);
            while (commentsRefIterator.hasNext()) {
                SerializableComment comment = (SerializableComment)this.comments.get(commentsRefIterator.next());
                if (comment == null) continue;
                writer.write("<comment ref=\"");
                writer.write(StringEscapeUtils.escapeXml11((String)comment.getAddress().formatAsString()));
                writer.write("\" authorId=\"");
                writer.write(Integer.toString(this.findAuthor(comment.getAuthor())));
                writer.write("\">");
                XSSFRichTextString rts = comment.getString();
                if (rts != null) {
                    if (rts.getCTRst() != null) {
                        writer.write(rts.getCTRst().xmlText(textSaveOptions));
                    } else {
                        writer.write("<text><t>");
                        writer.write(StringEscapeUtils.escapeXml11((String)comment.getString().getString()));
                        writer.write("</t></text>");
                    }
                }
                writer.write("</comment>");
            }
            writer.write("</commentList>");
            writer.write("</comments>");
        }
        finally {
            ((Writer)writer).flush();
        }
    }

    private XSSFRichTextString parseFullComment(XMLEventReader xmlEventReader) throws IOException, XmlException, XMLStreamException {
        XMLEvent xmlEvent;
        XSSFRichTextString richTextString = null;
        block6: while ((xmlEvent = xmlEventReader.nextTag()).isStartElement()) {
            StartElement startElement = xmlEvent.asStartElement();
            QName startTag = startElement.getName();
            switch (startTag.getLocalPart()) {
                case "text": {
                    List<String> tags = Arrays.asList("comments", "commentList", "comment", "text");
                    String text = TextParser.getXMLText(xmlEventReader, startTag, tags);
                    CTCommentList commentsList = ((CommentsDocument)CommentsDocument.Factory.parse(text)).getComments().getCommentList();
                    richTextString = new XSSFRichTextString(commentsList.getCommentArray(0).getText());
                    continue block6;
                }
            }
            log.debug("ignoring data inside element {}", (Object)startElement.getName());
        }
        return richTextString;
    }

    private String parseSimplifiedComment(XMLEventReader xmlEventReader) throws XMLStreamException {
        XMLEvent xmlEvent;
        String text = null;
        block6: while ((xmlEvent = xmlEventReader.nextTag()).isStartElement()) {
            StartElement startElement = xmlEvent.asStartElement();
            switch (startElement.getName().getLocalPart()) {
                case "text": {
                    text = TextParser.parseCT_Rst(xmlEventReader);
                    continue block6;
                }
            }
            log.debug("ignoring data inside element {}", (Object)startElement.getName());
        }
        return text;
    }

    static {
        textSaveOptions.setSaveSyntheticDocumentElement(new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", "text"));
    }
}

