/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.poi.xssf.streaming;

import com.github.pjfanning.poi.xssf.streaming.Constants;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

class TextParser {
    TextParser() {
    }

    static String parseCT_Rst(XMLEventReader xmlEventReader) throws XMLStreamException {
        XMLEvent xmlEvent;
        StringBuilder buf = new StringBuilder();
        block11: while ((xmlEvent = xmlEventReader.nextTag()).isStartElement()) {
            switch (xmlEvent.asStartElement().getName().getLocalPart()) {
                case "t": {
                    buf.append(xmlEventReader.getElementText());
                    continue block11;
                }
                case "r": {
                    TextParser.parseCT_RElt(xmlEventReader, buf);
                    continue block11;
                }
                case "rPh": 
                case "phoneticPr": {
                    TextParser.skipElement(xmlEventReader);
                    continue block11;
                }
            }
            throw new IllegalArgumentException("Unexpected start element: " + xmlEvent.asStartElement().getName().getLocalPart());
        }
        return buf.toString();
    }

    static void parseCT_RElt(XMLEventReader xmlEventReader, StringBuilder buf) throws XMLStreamException {
        XMLEvent xmlEvent;
        block8: while ((xmlEvent = xmlEventReader.nextTag()).isStartElement()) {
            switch (xmlEvent.asStartElement().getName().getLocalPart()) {
                case "t": {
                    buf.append(xmlEventReader.getElementText());
                    continue block8;
                }
                case "rPr": {
                    TextParser.skipElement(xmlEventReader);
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unexpected start element: " + xmlEvent.asStartElement().getName().getLocalPart());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getXMLText(XMLEventReader xmlEventReader, QName tag, List<String> wrappingTags) throws IOException, XMLStreamException {
        try (StringWriter sw = new StringWriter();){
            try (XMLEventWriter xew = Constants.XML_OUTPUT_FACTORY.createXMLEventWriter(sw);){
                for (String tagName : wrappingTags) {
                    xew.add(Constants.XML_EVENT_FACTORY.createStartElement(new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", tagName), Collections.emptyIterator(), Collections.emptyIterator()));
                }
                XMLEvent event = xmlEventReader.nextEvent();
                while (!(event == null || event.isEndElement() && event.asEndElement().getName().equals(tag))) {
                    xew.add(TextParser.adjustNamespaceOnEvent(event));
                    event = xmlEventReader.nextEvent();
                }
                ListIterator<String> tagIter = wrappingTags.listIterator(wrappingTags.size());
                while (tagIter.hasPrevious()) {
                    String tagName = tagIter.previous();
                    xew.add(Constants.XML_EVENT_FACTORY.createEndElement(new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", tagName), Collections.emptyIterator()));
                }
            }
            String string = sw.toString();
            return string;
        }
    }

    private static XMLEvent adjustNamespaceOnEvent(XMLEvent event) {
        EndElement ee;
        String nsUri;
        if (event.isStartElement()) {
            StartElement se = event.asStartElement();
            String nsUri2 = se.getName().getNamespaceURI();
            if (nsUri2 != null && !nsUri2.equals("http://schemas.openxmlformats.org/spreadsheetml/2006/main")) {
                return Constants.XML_EVENT_FACTORY.createStartElement(new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", se.getName().getLocalPart()), se.getAttributes(), Collections.emptyIterator());
            }
        } else if (event.isEndElement() && (nsUri = (ee = event.asEndElement()).getName().getNamespaceURI()) != null && !nsUri.equals("http://schemas.openxmlformats.org/spreadsheetml/2006/main")) {
            return Constants.XML_EVENT_FACTORY.createEndElement(new QName("http://schemas.openxmlformats.org/spreadsheetml/2006/main", ee.getName().getLocalPart()), Collections.emptyIterator());
        }
        return event;
    }

    private static void skipElement(XMLEventReader xmlEventReader) throws XMLStreamException {
        while (xmlEventReader.nextTag().isStartElement()) {
            TextParser.skipElement(xmlEventReader);
        }
    }
}

