/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.poi.xssf.streaming;

import com.github.pjfanning.poi.xssf.streaming.CommentsTableBase;
import com.github.pjfanning.poi.xssf.streaming.Constants;
import com.github.pjfanning.poi.xssf.streaming.SerializableComment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.util.TempFile;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempFileCommentsTable
extends CommentsTableBase {
    private static Logger log = LoggerFactory.getLogger(TempFileCommentsTable.class);
    private File tempFile;
    private MVStore mvStore;
    private MVMap<String, SerializableComment> mvComments;
    private MVMap<Integer, String> mvAuthors;

    public TempFileCommentsTable() throws IOException {
        this(false, false);
    }

    public TempFileCommentsTable(boolean encryptTempFiles) throws IOException {
        this(encryptTempFiles, false);
    }

    public TempFileCommentsTable(boolean encryptTempFiles, boolean fullFormat) throws IOException {
        super(fullFormat);
        try {
            this.tempFile = TempFile.createTempFile((String)"poi-comments", (String)".tmp");
            MVStore.Builder mvStoreBuilder = new MVStore.Builder();
            if (encryptTempFiles) {
                byte[] bytes = new byte[1024];
                Constants.RANDOM.nextBytes(bytes);
                mvStoreBuilder.encryptionKey(Base64.getEncoder().encodeToString(bytes).toCharArray());
            }
            mvStoreBuilder.fileName(this.tempFile.getAbsolutePath());
            this.mvStore = mvStoreBuilder.open();
            this.mvComments = this.mvStore.openMap("comments");
            this.comments = this.mvComments;
            this.mvAuthors = this.mvStore.openMap("authors");
            this.authors = this.mvAuthors;
        }
        catch (IOException | Error e) {
            if (this.mvStore != null) {
                this.mvStore.closeImmediately();
            }
            if (this.tempFile != null && !this.tempFile.delete()) {
                log.debug("failed to delete temp file - probably already deleted");
            }
            throw e;
        }
        catch (Exception e) {
            if (this.mvStore != null) {
                this.mvStore.closeImmediately();
            }
            if (this.tempFile != null && !this.tempFile.delete()) {
                log.debug("failed to delete temp file - probably already deleted");
            }
            throw new IOException(e);
        }
    }

    public TempFileCommentsTable(OPCPackage pkg, boolean encryptTempFiles) throws IOException {
        this(pkg, encryptTempFiles, false);
    }

    public TempFileCommentsTable(OPCPackage pkg, boolean encryptTempFiles, boolean fullFormat) throws IOException {
        this(encryptTempFiles, fullFormat);
        ArrayList parts = pkg.getPartsByContentType(XSSFRelation.SHEET_COMMENTS.getContentType());
        if (!parts.isEmpty()) {
            PackagePart sstPart = (PackagePart)parts.get(0);
            this.readFrom(sstPart.getInputStream());
        }
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected Iterator<Integer> authorsKeyIterator() {
        return this.mvAuthors.keyIterator(null);
    }

    @Override
    protected Iterator<String> commentsKeyIterator() {
        return this.mvComments.keyIterator(null);
    }

    @Override
    public void close() {
        if (this.mvStore != null) {
            this.mvStore.closeImmediately();
        }
        if (this.tempFile != null && !this.tempFile.delete()) {
            log.debug("failed to delete temp file - probably already deleted");
        }
    }
}

