/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.poi.xssf.streaming;

import com.github.pjfanning.poi.xssf.streaming.Constants;
import com.github.pjfanning.poi.xssf.streaming.SimpleXSSFComment;
import com.github.pjfanning.poi.xssf.streaming.TextParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.util.TempFile;
import org.apache.poi.util.XMLHelper;
import org.apache.poi.xssf.model.Comments;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;

public class TempFileCommentsTable
extends POIXMLDocumentPart
implements Comments,
AutoCloseable {
    private File tempFile;
    private MVStore mvStore;
    private final MVMap<String, XSSFComment> comments;
    private final MVMap<Integer, String> authors;

    public TempFileCommentsTable() {
        this(false);
    }

    public TempFileCommentsTable(boolean encryptTempFiles) {
        try {
            this.tempFile = TempFile.createTempFile((String)"poi-comments", (String)".tmp");
            MVStore.Builder mvStoreBuilder = new MVStore.Builder();
            if (encryptTempFiles) {
                byte[] bytes = new byte[1024];
                Constants.RANDOM.nextBytes(bytes);
                mvStoreBuilder.encryptionKey(Base64.getEncoder().encodeToString(bytes).toCharArray());
            }
            mvStoreBuilder.fileName(this.tempFile.getAbsolutePath());
            this.mvStore = mvStoreBuilder.open();
            this.comments = this.mvStore.openMap("comments");
            this.authors = this.mvStore.openMap("authors");
        }
        catch (Error | RuntimeException e) {
            if (this.mvStore != null) {
                this.mvStore.closeImmediately();
            }
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
            throw e;
        }
        catch (Exception e) {
            if (this.mvStore != null) {
                this.mvStore.closeImmediately();
            }
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
            throw new RuntimeException(e);
        }
    }

    public TempFileCommentsTable(OPCPackage pkg, boolean encryptTempFiles) throws IOException {
        this(encryptTempFiles);
        ArrayList parts = pkg.getPartsByContentType(XSSFRelation.SHEET_COMMENTS.getContentType());
        if (parts.size() > 0) {
            PackagePart sstPart = (PackagePart)parts.get(0);
            this.readFrom(sstPart.getInputStream());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFrom(InputStream is) throws IOException {
        try (XMLEventReader xmlEventReader = XMLHelper.newXMLInputFactory().createXMLEventReader(is);){
            while (xmlEventReader.hasNext()) {
                XMLEvent xmlEvent = xmlEventReader.nextEvent();
                if (!xmlEvent.isStartElement()) continue;
                StartElement se = xmlEvent.asStartElement();
                if (se.getName().getLocalPart().equals("author")) {
                    this.authors.put((Object)this.getNumberOfAuthors(), (Object)xmlEventReader.getElementText());
                    continue;
                }
                if (!se.getName().getLocalPart().equals("comment")) continue;
                String ref = se.getAttributeByName(new QName("ref")).getValue();
                String authorId = se.getAttributeByName(new QName("authorId")).getValue();
                String str = this.parseComment(xmlEventReader);
                SimpleXSSFComment xc = new SimpleXSSFComment();
                xc.setAddress(new CellAddress(ref));
                xc.setAuthor((String)this.authors.get((Object)Integer.parseInt(authorId)));
                xc.setString(str);
                this.comments.put((Object)ref, (Object)xc);
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    public int getNumberOfComments() {
        return this.comments.size();
    }

    public int getNumberOfAuthors() {
        return this.authors.size();
    }

    public String getAuthor(long authorId) {
        return (String)this.authors.get((Object)((int)authorId));
    }

    public int findAuthor(String author) {
        for (Map.Entry entry : this.authors.entrySet()) {
            if (!((String)entry.getValue()).equals(author)) continue;
            return (Integer)entry.getKey();
        }
        int index = this.getNumberOfAuthors();
        this.authors.put((Object)index, (Object)author);
        return index;
    }

    public XSSFComment findCellComment(CellAddress cellAddress) {
        return (XSSFComment)this.comments.get((Object)cellAddress.formatAsString());
    }

    public boolean removeComment(CellAddress cellRef) {
        return false;
    }

    public Iterator<CellAddress> getCellAddresses() {
        Set set = this.comments.keySet();
        return set.stream().map(s -> new CellAddress(s)).collect(Collectors.toSet()).iterator();
    }

    @Override
    public void close() {
        if (this.mvStore != null) {
            this.mvStore.closeImmediately();
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        try {
            writer.write("<comments xmlns=\"");
            writer.write("http://schemas.openxmlformats.org/spreadsheetml/2006/main");
            writer.write("\"><authors>");
            for (String author : this.authors.values()) {
                writer.write("<author>");
                writer.write(StringEscapeUtils.escapeXml11((String)author));
                writer.write("</author>");
            }
            writer.write("</authors>");
            writer.write("<commentList>");
            for (XSSFComment comment : this.comments.values()) {
                writer.write("<comment ref=\"");
                writer.write(StringEscapeUtils.escapeXml11((String)comment.getAddress().formatAsString()));
                writer.write("\" authorId=\"");
                writer.write(Integer.toString(this.findAuthor(comment.getAuthor())));
                writer.write("\">");
                XSSFRichTextString rts = comment.getString();
                if (rts != null) {
                    writer.write("<text>");
                    if (rts.getCTRst() != null) {
                        writer.write(rts.getCTRst().xmlText());
                    } else {
                        writer.write("<t>");
                        writer.write(StringEscapeUtils.escapeXml11((String)comment.getString().getString()));
                        writer.write("</t>");
                    }
                    writer.write("</text>");
                }
                writer.write("</comment>");
            }
            writer.write("</commentList>");
            writer.write("</comments>");
        }
        finally {
            ((Writer)writer).flush();
        }
    }

    private String parseComment(XMLEventReader xmlEventReader) throws XMLStreamException {
        XMLEvent xmlEvent;
        String text = null;
        block6: while ((xmlEvent = xmlEventReader.nextTag()).isStartElement()) {
            switch (xmlEvent.asStartElement().getName().getLocalPart()) {
                case "text": {
                    text = TextParser.parseCT_Rst(xmlEventReader);
                    continue block6;
                }
            }
            throw new IllegalArgumentException("Unexpected element name " + xmlEvent.asStartElement().getName().getLocalPart());
        }
        return text;
    }
}

