/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.poi.xssf.streaming;

import com.github.pjfanning.poi.xssf.streaming.Constants;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.util.StaxHelper;
import org.apache.poi.util.TempFile;
import org.apache.poi.xssf.model.SharedStringsTable;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTRst;

public class TempFileSharedStringsTable
extends SharedStringsTable {
    private File tempFile;
    private MVStore mvStore;
    private final MVMap<Integer, CTRst> strings;
    private final MVMap<String, Integer> stmap;

    public TempFileSharedStringsTable() {
        this(false);
    }

    public TempFileSharedStringsTable(boolean encryptTempFiles) {
        try {
            this.tempFile = TempFile.createTempFile((String)"poi-shared-strings", (String)".tmp");
            MVStore.Builder mvStoreBuilder = new MVStore.Builder();
            if (encryptTempFiles) {
                byte[] bytes = new byte[1024];
                Constants.RANDOM.nextBytes(bytes);
                mvStoreBuilder.encryptionKey(Base64.getEncoder().encodeToString(bytes).toCharArray());
            }
            mvStoreBuilder.fileName(this.tempFile.getAbsolutePath());
            this.mvStore = mvStoreBuilder.open();
            this.strings = this.mvStore.openMap("strings");
            this.stmap = this.mvStore.openMap("stmap");
        }
        catch (Error | RuntimeException e) {
            if (this.mvStore != null) {
                this.mvStore.closeImmediately();
            }
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
            throw e;
        }
        catch (Exception e) {
            if (this.mvStore != null) {
                this.mvStore.closeImmediately();
            }
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
            throw new RuntimeException(e);
        }
    }

    public TempFileSharedStringsTable(OPCPackage pkg, boolean encryptTempFiles) throws IOException {
        this(encryptTempFiles);
        ArrayList parts = pkg.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType());
        if (parts.size() > 0) {
            PackagePart sstPart = (PackagePart)parts.get(0);
            this.readFrom(sstPart.getInputStream());
        }
    }

    public void readFrom(InputStream is) throws IOException {
        try {
            XMLEventReader xmlEventReader = StaxHelper.newXMLInputFactory().createXMLEventReader(is);
            while (xmlEventReader.hasNext()) {
                XMLEvent xmlEvent = xmlEventReader.nextEvent();
                if (!xmlEvent.isStartElement() || !xmlEvent.asStartElement().getName().getLocalPart().equals("si")) continue;
                String str = this.parseCT_Rst(xmlEventReader);
                this.addSharedStringItem((RichTextString)new XSSFRichTextString(str));
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    public CTRst getEntryAt(int idx) {
        CTRst rst = (CTRst)this.strings.get((Object)idx);
        if (rst == null) {
            throw new NoSuchElementException();
        }
        return rst;
    }

    public RichTextString getItemAt(int idx) {
        return new XSSFRichTextString(this.getEntryAt(idx));
    }

    public int getCount() {
        return this.count;
    }

    public int getUniqueCount() {
        return this.uniqueCount;
    }

    public int addEntry(CTRst st) {
        if (st == null) {
            throw new NullPointerException("Cannot add null entry to SharedStringsTable");
        }
        String s = this.xmlText(st);
        ++this.count;
        if (this.stmap.containsKey((Object)s)) {
            return (Integer)this.stmap.get((Object)s);
        }
        int idx = this.uniqueCount++;
        this.stmap.put((Object)s, (Object)idx);
        this.strings.put((Object)idx, (Object)st);
        return idx;
    }

    public int addSharedStringItem(RichTextString string) {
        if (!(string instanceof XSSFRichTextString)) {
            throw new IllegalArgumentException("Only XSSFRichTextString argument is supported");
        }
        return this.addEntry(((XSSFRichTextString)string).getCTRst());
    }

    public List<CTRst> getItems() {
        throw new UnsupportedOperationException("TempFileSharedStringsTable only supports streaming access of shared strings");
    }

    public List<RichTextString> getSharedStringItems() {
        throw new UnsupportedOperationException("TempFileSharedStringsTable only supports streaming access of shared strings");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        try {
            writer.write("<sst count=\"");
            writer.write(Integer.toString(this.count));
            writer.write("\" uniqueCount=\"");
            writer.write(Integer.toString(this.uniqueCount));
            writer.write("\" xmlns=\"");
            writer.write("http://schemas.openxmlformats.org/spreadsheetml/2006/main");
            writer.write("\">");
            for (CTRst rst : this.strings.values()) {
                writer.write("<si>");
                writer.write(this.xmlText(rst));
                writer.write("</si>");
            }
            writer.write("</sst>");
        }
        finally {
            ((Writer)writer).flush();
        }
    }

    public void close() throws IOException {
        if (this.mvStore != null) {
            this.mvStore.closeImmediately();
        }
        if (this.tempFile != null) {
            this.tempFile.delete();
        }
    }

    private String parseCT_Rst(XMLEventReader xmlEventReader) throws XMLStreamException {
        XMLEvent xmlEvent;
        StringBuilder buf = new StringBuilder();
        block11: while ((xmlEvent = xmlEventReader.nextTag()).isStartElement()) {
            switch (xmlEvent.asStartElement().getName().getLocalPart()) {
                case "t": {
                    buf.append(xmlEventReader.getElementText());
                    continue block11;
                }
                case "r": {
                    this.parseCT_RElt(xmlEventReader, buf);
                    continue block11;
                }
                case "rPh": 
                case "phoneticPr": {
                    this.skipElement(xmlEventReader);
                    continue block11;
                }
            }
            throw new IllegalArgumentException(xmlEvent.asStartElement().getName().getLocalPart());
        }
        return buf.toString();
    }

    private void parseCT_RElt(XMLEventReader xmlEventReader, StringBuilder buf) throws XMLStreamException {
        XMLEvent xmlEvent;
        block8: while ((xmlEvent = xmlEventReader.nextTag()).isStartElement()) {
            switch (xmlEvent.asStartElement().getName().getLocalPart()) {
                case "t": {
                    buf.append(xmlEventReader.getElementText());
                    continue block8;
                }
                case "rPr": {
                    this.skipElement(xmlEventReader);
                    continue block8;
                }
            }
            throw new IllegalArgumentException(xmlEvent.asStartElement().getName().getLocalPart());
        }
    }

    private void skipElement(XMLEventReader xmlEventReader) throws XMLStreamException {
        while (xmlEventReader.nextTag().isStartElement()) {
            this.skipElement(xmlEventReader);
        }
    }
}

