/*
 * Decompiled with CFR 0.152.
 */
package com.zhouwei.mzbanner;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Handler;
import android.support.annotation.AttrRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.StyleRes;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Interpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.Scroller;
import com.zhouwei.mzbanner.CustomViewPager;
import com.zhouwei.mzbanner.R;
import com.zhouwei.mzbanner.holder.MZHolderCreator;
import com.zhouwei.mzbanner.holder.MZViewHolder;
import com.zhouwei.mzbanner.transformer.CoverModeTransformer;
import com.zhouwei.mzbanner.transformer.ScaleYTransformer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class MZBannerView<T>
extends RelativeLayout {
    private static final String TAG = "MZBannerView";
    private CustomViewPager mViewPager;
    private MZPagerAdapter mAdapter;
    private List<T> mDatas;
    private boolean mIsAutoPlay = true;
    private int mCurrentItem = 0;
    private Handler mHandler = new Handler();
    private int mDelayedTime = 3000;
    private ViewPagerScroller mViewPagerScroller;
    private boolean mIsOpenMZEffect = true;
    private boolean mIsCanLoop = true;
    private LinearLayout mIndicatorContainer;
    private ArrayList<ImageView> mIndicators = new ArrayList();
    private int[] mIndicatorRes = new int[]{R.drawable.indicator_normal, R.drawable.indicator_selected};
    private int mIndicatorPaddingLeft = 0;
    private int mIndicatorPaddingRight = 0;
    private int mMZModePadding = 0;
    private int mIndicatorAlign = 1;
    private ViewPager.OnPageChangeListener mOnPageChangeListener;
    private BannerPageClickListener mBannerPageClickListener;
    private boolean mIsMiddlePageCover = true;
    private final Runnable mLoopRunnable = new Runnable(){

        @Override
        public void run() {
            if (MZBannerView.this.mIsAutoPlay) {
                MZBannerView.this.mCurrentItem = MZBannerView.this.mViewPager.getCurrentItem();
                MZBannerView.this.mCurrentItem++;
                if (MZBannerView.this.mCurrentItem == MZBannerView.this.mAdapter.getCount() - 1) {
                    MZBannerView.this.mCurrentItem = 0;
                    MZBannerView.this.mViewPager.setCurrentItem(MZBannerView.this.mCurrentItem, false);
                    MZBannerView.this.mHandler.postDelayed((Runnable)this, (long)MZBannerView.this.mDelayedTime);
                } else {
                    MZBannerView.this.mViewPager.setCurrentItem(MZBannerView.this.mCurrentItem);
                    MZBannerView.this.mHandler.postDelayed((Runnable)this, (long)MZBannerView.this.mDelayedTime);
                }
            } else {
                MZBannerView.this.mHandler.postDelayed((Runnable)this, (long)MZBannerView.this.mDelayedTime);
            }
        }
    };

    public MZBannerView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public MZBannerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.readAttrs(context, attrs);
        this.init();
    }

    public MZBannerView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.readAttrs(context, attrs);
        this.init();
    }

    @RequiresApi(api=21)
    public MZBannerView(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.readAttrs(context, attrs);
        this.init();
    }

    private void readAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.MZBannerView);
        this.mIsOpenMZEffect = typedArray.getBoolean(R.styleable.MZBannerView_open_mz_mode, true);
        this.mIsMiddlePageCover = typedArray.getBoolean(R.styleable.MZBannerView_middle_page_cover, true);
        this.mIsCanLoop = typedArray.getBoolean(R.styleable.MZBannerView_canLoop, true);
        this.mIndicatorAlign = typedArray.getInt(R.styleable.MZBannerView_indicatorAlign, 1);
        this.mIndicatorPaddingLeft = typedArray.getDimensionPixelSize(R.styleable.MZBannerView_indicatorPaddingLeft, 0);
        this.mIndicatorPaddingRight = typedArray.getDimensionPixelSize(R.styleable.MZBannerView_indicatorPaddingRight, 0);
    }

    private void init() {
        View view = null;
        view = this.mIsOpenMZEffect ? LayoutInflater.from((Context)this.getContext()).inflate(R.layout.mz_banner_effect_layout, (ViewGroup)this, true) : LayoutInflater.from((Context)this.getContext()).inflate(R.layout.mz_banner_normal_layout, (ViewGroup)this, true);
        this.mIndicatorContainer = (LinearLayout)view.findViewById(R.id.banner_indicator_container);
        this.mViewPager = (CustomViewPager)view.findViewById(R.id.mzbanner_vp);
        this.mViewPager.setOffscreenPageLimit(4);
        this.mMZModePadding = MZBannerView.dpToPx(30);
        this.initViewPagerScroll();
        if (this.mIndicatorAlign == 0) {
            this.setIndicatorAlign(IndicatorAlign.LEFT);
        } else if (this.mIndicatorAlign == 1) {
            this.setIndicatorAlign(IndicatorAlign.CENTER);
        } else {
            this.setIndicatorAlign(IndicatorAlign.RIGHT);
        }
    }

    private void setOpenMZEffect() {
        if (this.mIsOpenMZEffect) {
            if (this.mIsMiddlePageCover) {
                this.mViewPager.setPageTransformer(true, new CoverModeTransformer(this.mViewPager));
            } else {
                this.mViewPager.setPageTransformer(false, new ScaleYTransformer());
            }
        }
    }

    private void initViewPagerScroll() {
        try {
            Field mScroller = null;
            mScroller = ViewPager.class.getDeclaredField("mScroller");
            mScroller.setAccessible(true);
            this.mViewPagerScroller = new ViewPagerScroller(this.mViewPager.getContext());
            mScroller.set((Object)this.mViewPager, (Object)this.mViewPagerScroller);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    private void initIndicator() {
        this.mIndicatorContainer.removeAllViews();
        this.mIndicators.clear();
        for (int i = 0; i < this.mDatas.size(); ++i) {
            ImageView imageView = new ImageView(this.getContext());
            if (this.mIndicatorAlign == IndicatorAlign.LEFT.ordinal()) {
                if (i == 0) {
                    int paddingLeft = this.mIsOpenMZEffect ? this.mIndicatorPaddingLeft + this.mMZModePadding : this.mIndicatorPaddingLeft;
                    imageView.setPadding(paddingLeft + 6, 0, 6, 0);
                } else {
                    imageView.setPadding(6, 0, 6, 0);
                }
            } else if (this.mIndicatorAlign == IndicatorAlign.RIGHT.ordinal()) {
                if (i == this.mDatas.size() - 1) {
                    int paddingRight = this.mIsOpenMZEffect ? this.mMZModePadding + this.mIndicatorPaddingRight : this.mIndicatorPaddingRight;
                    imageView.setPadding(6, 0, 6 + paddingRight, 0);
                } else {
                    imageView.setPadding(6, 0, 6, 0);
                }
            } else {
                imageView.setPadding(6, 0, 6, 0);
            }
            if (i == this.mCurrentItem % this.mDatas.size()) {
                imageView.setImageResource(this.mIndicatorRes[1]);
            } else {
                imageView.setImageResource(this.mIndicatorRes[0]);
            }
            this.mIndicators.add(imageView);
            this.mIndicatorContainer.addView((View)imageView);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (!this.mIsCanLoop) {
            return super.dispatchTouchEvent(ev);
        }
        switch (ev.getAction()) {
            case 0: 
            case 2: 
            case 3: 
            case 4: {
                int paddingLeft = this.mViewPager.getLeft();
                float touchX = ev.getRawX();
                if (!(touchX >= (float)paddingLeft) || !(touchX < (float)(MZBannerView.getScreenWidth(this.getContext()) - paddingLeft))) break;
                this.mIsAutoPlay = false;
                break;
            }
            case 1: {
                this.mIsAutoPlay = true;
            }
        }
        return super.dispatchTouchEvent(ev);
    }

    public static int getScreenWidth(Context context) {
        Resources resources = context.getResources();
        DisplayMetrics dm = resources.getDisplayMetrics();
        int width = dm.widthPixels;
        return width;
    }

    public void start() {
        if (this.mAdapter == null) {
            return;
        }
        if (this.mIsCanLoop) {
            this.mIsAutoPlay = true;
            this.mHandler.postDelayed(this.mLoopRunnable, (long)this.mDelayedTime);
        }
    }

    public void pause() {
        this.mIsAutoPlay = false;
        this.mHandler.removeCallbacks(this.mLoopRunnable);
    }

    public void setDelayedTime(int delayedTime) {
        this.mDelayedTime = delayedTime;
    }

    public void addPageChangeLisnter(ViewPager.OnPageChangeListener onPageChangeListener) {
        this.mOnPageChangeListener = onPageChangeListener;
    }

    public void setBannerPageClickListener(BannerPageClickListener bannerPageClickListener) {
        this.mBannerPageClickListener = bannerPageClickListener;
    }

    public void setIndicatorVisible(boolean visible) {
        if (visible) {
            this.mIndicatorContainer.setVisibility(0);
        } else {
            this.mIndicatorContainer.setVisibility(8);
        }
    }

    public ViewPager getViewPager() {
        return this.mViewPager;
    }

    public void setIndicatorRes(@DrawableRes int unSelectRes, @DrawableRes int selectRes) {
        this.mIndicatorRes[0] = unSelectRes;
        this.mIndicatorRes[1] = selectRes;
    }

    public void setPages(List<T> datas, MZHolderCreator mzHolderCreator) {
        if (datas == null || mzHolderCreator == null) {
            return;
        }
        this.mDatas = datas;
        this.pause();
        if (datas.size() < 3) {
            this.mIsOpenMZEffect = false;
            ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)this.mViewPager.getLayoutParams();
            layoutParams.setMargins(0, 0, 0, 0);
            this.mViewPager.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.setClipChildren(true);
            this.mViewPager.setClipChildren(true);
        }
        this.setOpenMZEffect();
        this.initIndicator();
        this.mAdapter = new MZPagerAdapter<T>(datas, mzHolderCreator, this.mIsCanLoop);
        this.mAdapter.setUpViewViewPager(this.mViewPager);
        this.mAdapter.setPageClickListener(this.mBannerPageClickListener);
        this.mViewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
                int realPosition = position % MZBannerView.this.mIndicators.size();
                if (MZBannerView.this.mOnPageChangeListener != null) {
                    MZBannerView.this.mOnPageChangeListener.onPageScrolled(realPosition, positionOffset, positionOffsetPixels);
                }
            }

            public void onPageSelected(int position) {
                MZBannerView.this.mCurrentItem = position;
                int realSelectPosition = MZBannerView.this.mCurrentItem % MZBannerView.this.mIndicators.size();
                for (int i = 0; i < MZBannerView.this.mDatas.size(); ++i) {
                    if (i == realSelectPosition) {
                        ((ImageView)MZBannerView.this.mIndicators.get(i)).setImageResource(MZBannerView.this.mIndicatorRes[1]);
                        continue;
                    }
                    ((ImageView)MZBannerView.this.mIndicators.get(i)).setImageResource(MZBannerView.this.mIndicatorRes[0]);
                }
                if (MZBannerView.this.mOnPageChangeListener != null) {
                    MZBannerView.this.mOnPageChangeListener.onPageSelected(realSelectPosition);
                }
            }

            public void onPageScrollStateChanged(int state) {
                switch (state) {
                    case 1: {
                        MZBannerView.this.mIsAutoPlay = false;
                        break;
                    }
                    case 2: {
                        MZBannerView.this.mIsAutoPlay = true;
                    }
                }
                if (MZBannerView.this.mOnPageChangeListener != null) {
                    MZBannerView.this.mOnPageChangeListener.onPageScrollStateChanged(state);
                }
            }
        });
    }

    public void setIndicatorAlign(IndicatorAlign indicatorAlign) {
        this.mIndicatorAlign = indicatorAlign.ordinal();
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)this.mIndicatorContainer.getLayoutParams();
        if (indicatorAlign == IndicatorAlign.LEFT) {
            layoutParams.addRule(9);
        } else if (indicatorAlign == IndicatorAlign.RIGHT) {
            layoutParams.addRule(11);
        } else {
            layoutParams.addRule(14);
        }
        this.mIndicatorContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setDuration(int duration) {
        this.mViewPagerScroller.setDuration(duration);
    }

    public void setUseDefaultDuration(boolean useDefaultDuration) {
        this.mViewPagerScroller.setUseDefaultDuration(useDefaultDuration);
    }

    public int getDuration() {
        return this.mViewPagerScroller.getScrollDuration();
    }

    public static int dpToPx(int dp) {
        return (int)TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public static interface BannerPageClickListener {
        public void onPageClick(View var1, int var2);
    }

    public static class ViewPagerScroller
    extends Scroller {
        private int mDuration = 800;
        private boolean mIsUseDefaultDuration = false;

        public ViewPagerScroller(Context context) {
            super(context);
        }

        public ViewPagerScroller(Context context, Interpolator interpolator) {
            super(context, interpolator);
        }

        public ViewPagerScroller(Context context, Interpolator interpolator, boolean flywheel) {
            super(context, interpolator, flywheel);
        }

        public void startScroll(int startX, int startY, int dx, int dy) {
            super.startScroll(startX, startY, dx, dy, this.mDuration);
        }

        public void startScroll(int startX, int startY, int dx, int dy, int duration) {
            super.startScroll(startX, startY, dx, dy, this.mIsUseDefaultDuration ? duration : this.mDuration);
        }

        public void setUseDefaultDuration(boolean useDefaultDuration) {
            this.mIsUseDefaultDuration = useDefaultDuration;
        }

        public boolean isUseDefaultDuration() {
            return this.mIsUseDefaultDuration;
        }

        public void setDuration(int duration) {
            this.mDuration = duration;
        }

        public int getScrollDuration() {
            return this.mDuration;
        }
    }

    public static class MZPagerAdapter<T>
    extends PagerAdapter {
        private List<T> mDatas;
        private MZHolderCreator mMZHolderCreator;
        private ViewPager mViewPager;
        private boolean canLoop;
        private BannerPageClickListener mPageClickListener;
        private final int mLooperCountFactor = 500;

        public MZPagerAdapter(List<T> datas, MZHolderCreator MZHolderCreator2, boolean canLoop) {
            if (this.mDatas == null) {
                this.mDatas = new ArrayList<T>();
            }
            for (T t : datas) {
                this.mDatas.add(t);
            }
            this.mMZHolderCreator = MZHolderCreator2;
            this.canLoop = canLoop;
        }

        public void setPageClickListener(BannerPageClickListener pageClickListener) {
            this.mPageClickListener = pageClickListener;
        }

        public void setUpViewViewPager(ViewPager viewPager) {
            this.mViewPager = viewPager;
            this.mViewPager.setAdapter((PagerAdapter)this);
            this.mViewPager.getAdapter().notifyDataSetChanged();
            int currentItem = this.canLoop ? this.getStartSelectItem() : 0;
            this.mViewPager.setCurrentItem(currentItem);
        }

        private int getStartSelectItem() {
            int currentItem = this.getRealCount() * 500 / 2;
            if (currentItem % this.getRealCount() == 0) {
                return currentItem;
            }
            while (currentItem % this.getRealCount() != 0) {
                ++currentItem;
            }
            return currentItem;
        }

        public void setDatas(List<T> datas) {
            this.mDatas = datas;
        }

        public int getCount() {
            return this.canLoop ? this.getRealCount() * 500 : this.getRealCount();
        }

        public boolean isViewFromObject(View view, Object object) {
            return view == object;
        }

        public Object instantiateItem(ViewGroup container, int position) {
            View view = this.getView(position, container);
            container.addView(view);
            return view;
        }

        public void destroyItem(ViewGroup container, int position, Object object) {
            container.removeView((View)object);
        }

        public void finishUpdate(ViewGroup container) {
            int position;
            if (this.canLoop && (position = this.mViewPager.getCurrentItem()) == this.getCount() - 1) {
                position = 0;
                this.setCurrentItem(position);
            }
        }

        private void setCurrentItem(int position) {
            try {
                this.mViewPager.setCurrentItem(position, false);
            }
            catch (IllegalStateException e) {
                e.printStackTrace();
            }
        }

        private int getRealCount() {
            return this.mDatas == null ? 0 : this.mDatas.size();
        }

        private View getView(int position, ViewGroup container) {
            final int realPosition = position % this.getRealCount();
            MZViewHolder holder = null;
            holder = (MZViewHolder)this.mMZHolderCreator.createViewHolder();
            if (holder == null) {
                throw new RuntimeException("can not return a null holder");
            }
            View view = holder.createView(container.getContext());
            if (this.mDatas != null && this.mDatas.size() > 0) {
                holder.onBind(container.getContext(), realPosition, this.mDatas.get(realPosition));
            }
            view.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (MZPagerAdapter.this.mPageClickListener != null) {
                        MZPagerAdapter.this.mPageClickListener.onPageClick(v, realPosition);
                    }
                }
            });
            return view;
        }
    }

    public static enum IndicatorAlign {
        LEFT,
        CENTER,
        RIGHT;

    }
}

