/*
 * Decompiled with CFR 0.152.
 */
package com.zhouwei.blurlibrary;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Build;
import android.support.v8.renderscript.Allocation;
import android.support.v8.renderscript.Element;
import android.support.v8.renderscript.RenderScript;
import android.support.v8.renderscript.ScriptIntrinsicBlur;
import android.support.v8.renderscript.Type;
import android.util.Log;

public class EasyBlur {
    private static final String TAG = "EasyBlur";
    private static final float SCALE = 0.125f;
    private static volatile EasyBlur singleton = null;
    private Bitmap mBitmap;
    private int mRadius = 0;
    private float mScale = 0.125f;
    private Context mContext;
    private BlurPolicy mPolicy = BlurPolicy.RS_BLUR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EasyBlur with(Context context) {
        if (singleton != null) return singleton;
        Class<EasyBlur> clazz = EasyBlur.class;
        synchronized (EasyBlur.class) {
            if (singleton != null) return singleton;
            singleton = new EasyBlur(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return singleton;
        }
    }

    private EasyBlur(Context context) {
        this.mContext = context.getApplicationContext();
    }

    public Bitmap blur() {
        if (this.mBitmap == null) {
            throw new RuntimeException("Bitmap can not be null");
        }
        if (this.mRadius == 0) {
            throw new RuntimeException("radius must > 0");
        }
        if (Build.VERSION.SDK_INT > 8) {
            if (this.mPolicy == BlurPolicy.FAST_BLUR) {
                Log.d((String)TAG, (String)"blur fast algorithm");
                return EasyBlur.fastBlur(this.mBitmap, this.mScale, this.mRadius);
            }
            Log.d((String)TAG, (String)"blur render script  algorithm");
            return EasyBlur.rsBlur(this.mContext, this.mBitmap, this.mRadius, this.mScale);
        }
        Log.d((String)TAG, (String)"blur fast algorithm");
        return EasyBlur.fastBlur(this.mBitmap, this.mScale, this.mRadius);
    }

    public EasyBlur policy(BlurPolicy policy) {
        this.mPolicy = policy;
        return this;
    }

    public EasyBlur bitmap(Bitmap bitmap) {
        this.mBitmap = bitmap;
        return this;
    }

    public EasyBlur scale(int scale) {
        this.mScale = 1.0f / (float)scale;
        return this;
    }

    public EasyBlur radius(int radius) {
        this.mRadius = radius;
        return this;
    }

    private static Bitmap rsBlur(Context context, Bitmap source, int radius, float scale) {
        Log.i((String)TAG, (String)("origin size:" + source.getWidth() + "*" + source.getHeight()));
        int width = Math.round((float)source.getWidth() * scale);
        int height = Math.round((float)source.getHeight() * scale);
        Bitmap inputBmp = Bitmap.createScaledBitmap((Bitmap)source, (int)width, (int)height, (boolean)false);
        RenderScript renderScript = RenderScript.create((Context)context);
        Log.i((String)TAG, (String)("scale size:" + inputBmp.getWidth() + "*" + inputBmp.getHeight()));
        Allocation input = Allocation.createFromBitmap((RenderScript)renderScript, (Bitmap)inputBmp);
        Allocation output = Allocation.createTyped((RenderScript)renderScript, (Type)input.getType());
        ScriptIntrinsicBlur scriptIntrinsicBlur = ScriptIntrinsicBlur.create((RenderScript)renderScript, (Element)Element.U8_4((RenderScript)renderScript));
        scriptIntrinsicBlur.setInput(input);
        scriptIntrinsicBlur.setRadius((float)radius);
        scriptIntrinsicBlur.forEach(output);
        output.copyTo(inputBmp);
        renderScript.destroy();
        return inputBmp;
    }

    private static Bitmap fastBlur(Bitmap sentBitmap, float scale, int radius) {
        int stackstart;
        int x;
        int stackpointer;
        int rbs;
        int[] sir;
        int p;
        int rinsum;
        int ginsum;
        int binsum;
        int routsum;
        int goutsum;
        int boutsum;
        int rsum;
        int gsum;
        int bsum;
        int y;
        int i;
        int width = Math.round((float)sentBitmap.getWidth() * scale);
        int height = Math.round((float)sentBitmap.getHeight() * scale);
        sentBitmap = Bitmap.createScaledBitmap((Bitmap)sentBitmap, (int)width, (int)height, (boolean)false);
        Bitmap bitmap = sentBitmap.copy(sentBitmap.getConfig(), true);
        if (radius < 1) {
            return null;
        }
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        int[] pix = new int[w * h];
        Log.e((String)"pix", (String)(w + " " + h + " " + pix.length));
        bitmap.getPixels(pix, 0, w, 0, 0, w, h);
        int wm = w - 1;
        int hm = h - 1;
        int wh = w * h;
        int div = radius + radius + 1;
        int[] r = new int[wh];
        int[] g = new int[wh];
        int[] b = new int[wh];
        int[] vmin = new int[Math.max(w, h)];
        int divsum = div + 1 >> 1;
        divsum *= divsum;
        int[] dv = new int[256 * divsum];
        for (i = 0; i < 256 * divsum; ++i) {
            dv[i] = i / divsum;
        }
        int yi = 0;
        int yw = 0;
        int[][] stack = new int[div][3];
        int r1 = radius + 1;
        for (y = 0; y < h; ++y) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            boutsum = 0;
            goutsum = 0;
            routsum = 0;
            binsum = 0;
            ginsum = 0;
            rinsum = 0;
            for (i = -radius; i <= radius; ++i) {
                p = pix[yi + Math.min(wm, Math.max(i, 0))];
                sir = stack[i + radius];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rbs = r1 - Math.abs(i);
                rsum += sir[0] * rbs;
                gsum += sir[1] * rbs;
                bsum += sir[2] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                    continue;
                }
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
            }
            stackpointer = radius;
            for (x = 0; x < w; ++x) {
                r[yi] = dv[rsum];
                g[yi] = dv[gsum];
                b[yi] = dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (y == 0) {
                    vmin[x] = Math.min(x + radius + 1, wm);
                }
                p = pix[yw + vmin[x]];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer % div];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                ++yi;
            }
            yw += w;
        }
        for (x = 0; x < w; ++x) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            boutsum = 0;
            goutsum = 0;
            routsum = 0;
            binsum = 0;
            ginsum = 0;
            rinsum = 0;
            int yp = -radius * w;
            for (i = -radius; i <= radius; ++i) {
                yi = Math.max(0, yp) + x;
                sir = stack[i + radius];
                sir[0] = r[yi];
                sir[1] = g[yi];
                sir[2] = b[yi];
                rbs = r1 - Math.abs(i);
                rsum += r[yi] * rbs;
                gsum += g[yi] * rbs;
                bsum += b[yi] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                } else {
                    routsum += sir[0];
                    goutsum += sir[1];
                    boutsum += sir[2];
                }
                if (i >= hm) continue;
                yp += w;
            }
            yi = x;
            stackpointer = radius;
            for (y = 0; y < h; ++y) {
                pix[yi] = 0xFF000000 & pix[yi] | dv[rsum] << 16 | dv[gsum] << 8 | dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (x == 0) {
                    vmin[y] = Math.min(y + r1, hm) * w;
                }
                p = x + vmin[y];
                sir[0] = r[p];
                sir[1] = g[p];
                sir[2] = b[p];
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                yi += w;
            }
        }
        Log.e((String)"pix", (String)(w + " " + h + " " + pix.length));
        bitmap.setPixels(pix, 0, w, 0, 0, w, h);
        return bitmap;
    }

    public static enum BlurPolicy {
        RS_BLUR,
        FAST_BLUR;

    }
}

