/*
 * Decompiled with CFR 0.152.
 */
package com.github.pimvoeten.aws.s3;

import com.github.pimvoeten.aws.core.AbstractAwsMojo;
import java.io.File;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.model.CreateBucketConfiguration;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.CreateBucketResponse;
import software.amazon.awssdk.services.s3.model.HeadBucketRequest;
import software.amazon.awssdk.services.s3.model.HeadBucketResponse;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

@Mojo(name="S3-putObject")
public class UploadMojo
extends AbstractAwsMojo<S3Client> {
    @Parameter(property="includeArtifact", defaultValue="true")
    private boolean includeArtifact;
    @Parameter(property="bucket", required=true)
    private String bucket;
    @Parameter(property="createBucket", defaultValue="false")
    private boolean createBucket;
    @Parameter(property="path")
    private String path;
    @Parameter
    private FileSet[] filesets;
    private S3Client s3Client;

    @Override
    protected void doExecute() throws MojoExecutionException {
        this.validateParams();
        boolean bucketExists = this.doesBucketExist();
        if (!bucketExists && !this.createBucket) {
            throw new MojoExecutionException("Bucket [" + this.bucket + "] does not exists. Create the bucket or configure this plugin to create the bucket.");
        }
        if (!bucketExists && this.createBucket) {
            this.createBucket();
        }
        if (this.includeArtifact) {
            this.uploadArtifact();
        }
        this.uploadFiles();
    }

    private void validateParams() throws MojoExecutionException {
        if (!(this.filesets != null && this.filesets.length != 0 || this.includeArtifact)) {
            throw new MojoExecutionException("No artifacts to upload. No filesets configured and includeArtifact is false");
        }
    }

    private boolean doesBucketExist() {
        S3Client s3 = this.getClient();
        try {
            HeadBucketResponse headBucketResponse = s3.headBucket((HeadBucketRequest)HeadBucketRequest.builder().bucket(this.bucket).build());
            return 200 == headBucketResponse.sdkHttpResponse().statusCode();
        }
        catch (NoSuchBucketException e) {
            return false;
        }
    }

    private void createBucket() {
        this.getLog().info((CharSequence)("Creating bucket [" + this.bucket + "]"));
        S3Client s3 = this.getClient();
        CreateBucketRequest createBucketRequest = (CreateBucketRequest)CreateBucketRequest.builder().bucket(this.bucket).createBucketConfiguration((CreateBucketConfiguration)CreateBucketConfiguration.builder().build()).build();
        CreateBucketResponse response = s3.createBucket(createBucketRequest);
        this.getLog().info((CharSequence)("Bucket created: " + response.toString()));
    }

    private void uploadArtifact() {
        File artifact = this.project.getArtifact().getFile();
        if (artifact != null) {
            Path file = artifact.toPath();
            this.uploadFileToBucket(file);
        }
    }

    private void uploadFiles() {
        FileSetManager fileSetManager = new FileSetManager();
        if (this.filesets != null && this.filesets.length > 0) {
            Stream.of(this.filesets).forEach(fileSet -> {
                File dir = new File(this.project.getBasedir(), fileSet.getDirectory());
                fileSet.setDirectory(dir.getAbsolutePath());
                String[] includedFiles = fileSetManager.getIncludedFiles(fileSet);
                Stream.of(includedFiles).forEach(file -> this.uploadFileToBucket(new File(fileSet.getDirectory(), (String)file).toPath()));
            });
        }
    }

    private void uploadFileToBucket(Path file) {
        S3Client s3 = this.getClient();
        String key = this.path != null ? this.path + "/" : "";
        key = key + file.getFileName().toString();
        this.getLog().info((CharSequence)("Uploading: " + file.toString()));
        PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.bucket).key(key).build();
        s3.putObject(putObjectRequest, file);
    }

    @Override
    protected S3Client getClient() {
        if (this.s3Client == null) {
            this.s3Client = (S3Client)((S3ClientBuilder)((S3ClientBuilder)S3Client.builder().credentialsProvider((AwsCredentialsProvider)this.getAwsCredentialsProviderChain())).region(this.getRegion())).build();
        }
        return this.s3Client;
    }
}

