/*
 * Decompiled with CFR 0.152.
 */
package com.github.pimvoeten.aws.core;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;

public abstract class AbstractAwsMojo<S extends SdkClient>
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="accessKey")
    protected String accessKey;
    @Parameter(property="secretKey")
    protected String secretKey;
    @Parameter(property="region")
    protected String regionName;
    @Parameter(property="profile")
    protected String profile;

    protected abstract S getClient();

    protected abstract void doExecute() throws MojoExecutionException;

    public void execute() throws MojoExecutionException {
        try {
            this.validateCredentials();
            this.doExecute();
        }
        catch (SdkServiceException e) {
            if (e.statusCode() == 403) {
                throw new MojoExecutionException("Invalid credentials");
            }
        }
        catch (SdkClientException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }

    private void validateCredentials() throws MojoExecutionException {
        boolean profileUsed;
        boolean bl = profileUsed = this.profile != null;
        if (this.profile == null && this.accessKey == null && this.secretKey == null) {
            throw new MojoExecutionException("No credentials configured");
        }
        if (profileUsed && this.accessKey != null | this.secretKey != null) {
            throw new MojoExecutionException("Set credentials or use profile, not both");
        }
        if (!profileUsed && this.accessKey == null ^ this.secretKey == null) {
            throw new MojoExecutionException("Set both accessKey and secretKey params");
        }
    }

    protected Region getRegion() {
        Region region;
        if (this.regionName == null) {
            DefaultAwsRegionProviderChain regionProviderChain = new DefaultAwsRegionProviderChain();
            region = regionProviderChain.getRegion();
        } else {
            region = Region.of((String)this.regionName);
        }
        return region;
    }

    protected AwsCredentialsProviderChain getAwsCredentialsProviderChain() {
        AwsCredentialsProviderChain.Builder credentialsProviderChainBuilder = AwsCredentialsProviderChain.builder();
        if (this.profile != null) {
            credentialsProviderChainBuilder.addCredentialsProvider((AwsCredentialsProvider)ProfileCredentialsProvider.builder().profileName(this.profile).build());
        }
        if (this.accessKey != null && this.secretKey != null) {
            AwsBasicCredentials awsCreds = AwsBasicCredentials.create((String)this.accessKey, (String)this.secretKey);
            credentialsProviderChainBuilder.addCredentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)awsCreds));
        }
        return credentialsProviderChainBuilder.build();
    }
}

