/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.rxandroidaudio;

import android.util.Log;
import androidx.annotation.NonNull;
import com.github.piasy.rxandroidaudio.AudioRecorder;
import io.reactivex.Observable;
import java.util.Random;
import java.util.concurrent.TimeUnit;

public final class RxAmplitude {
    static final String TAG = "RxAmplitude";
    static final int AMPLITUDE_MAX_VALUE = 16385;
    static final int AMPLITUDE_MAX_LEVEL = 8;
    private static final int DEFAULT_AMPLITUDE_INTERVAL = 200;
    final Random mRandom = new Random(System.nanoTime());

    private RxAmplitude() {
    }

    public static Observable<Integer> from(@NonNull AudioRecorder audioRecorder) {
        return RxAmplitude.from(audioRecorder, 200L);
    }

    public static Observable<Integer> from(@NonNull AudioRecorder audioRecorder, long interval) {
        return new RxAmplitude().start(audioRecorder, interval);
    }

    private Observable<Integer> start(@NonNull AudioRecorder audioRecorder, long interval) {
        return Observable.interval((long)interval, (TimeUnit)TimeUnit.MILLISECONDS).map(aLong -> {
            int amplitude;
            try {
                amplitude = audioRecorder.getMaxAmplitude();
            }
            catch (RuntimeException e) {
                Log.i((String)TAG, (String)("getMaxAmplitude fail: " + e.getMessage()));
                amplitude = this.mRandom.nextInt(16385);
            }
            return amplitude /= 2048;
        });
    }
}

