/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.rxandroidaudio;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.FloatRange;
import androidx.annotation.RawRes;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class PlayConfig {
    static final int TYPE_FILE = 1;
    static final int TYPE_RES = 2;
    static final int TYPE_URL = 3;
    static final int TYPE_URI = 4;
    final int mType;
    final Context mContext;
    @RawRes
    final int mAudioResource;
    final Uri mUri;
    final File mAudioFile;
    final String mUrl;
    final int mStreamType;
    final boolean mLooping;
    @FloatRange(from=0.0, to=1.0)
    final float mLeftVolume;
    @FloatRange(from=0.0, to=1.0)
    final float mRightVolume;

    private PlayConfig(Builder builder) {
        this.mType = builder.mType;
        this.mContext = builder.mContext;
        this.mAudioResource = builder.mAudioResource;
        this.mAudioFile = builder.mAudioFile;
        this.mStreamType = builder.mStreamType;
        this.mLooping = builder.mLooping;
        this.mLeftVolume = builder.mLeftVolume;
        this.mRightVolume = builder.mRightVolume;
        this.mUri = builder.mUri;
        this.mUrl = builder.mUrl;
    }

    public static Builder file(File file) {
        Builder builder = new Builder();
        builder.mAudioFile = file;
        builder.mType = 1;
        return builder;
    }

    public static Builder url(String url) {
        Builder builder = new Builder();
        builder.mUrl = url;
        builder.mType = 3;
        return builder;
    }

    public static Builder res(Context context, @RawRes int audioResource) {
        Builder builder = new Builder();
        builder.mContext = context;
        builder.mAudioResource = audioResource;
        builder.mType = 2;
        return builder;
    }

    public static Builder uri(Context context, Uri uri) {
        Builder builder = new Builder();
        builder.mContext = context;
        builder.mUri = uri;
        builder.mType = 4;
        return builder;
    }

    boolean isArgumentValid() {
        switch (this.mType) {
            case 1: {
                return this.mAudioFile != null && this.mAudioFile.exists();
            }
            case 2: {
                return this.mAudioResource > 0 && this.mContext != null;
            }
            case 3: {
                return !TextUtils.isEmpty((CharSequence)this.mUrl);
            }
            case 4: {
                return this.mUri != null;
            }
        }
        return false;
    }

    boolean isLocalSource() {
        switch (this.mType) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    boolean needPrepare() {
        switch (this.mType) {
            case 1: 
            case 3: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public static class Builder {
        int mType;
        Context mContext;
        @RawRes
        int mAudioResource;
        Uri mUri;
        File mAudioFile;
        String mUrl;
        int mStreamType = 3;
        boolean mLooping;
        @FloatRange(from=0.0, to=1.0)
        float mLeftVolume = 1.0f;
        @FloatRange(from=0.0, to=1.0)
        float mRightVolume = 1.0f;

        public Builder streamType(int streamType) {
            this.mStreamType = streamType;
            return this;
        }

        public Builder looping(boolean looping) {
            this.mLooping = looping;
            return this;
        }

        public Builder leftVolume(@FloatRange(from=0.0, to=1.0) float leftVolume) {
            this.mLeftVolume = leftVolume;
            return this;
        }

        public Builder rightVolume(@FloatRange(from=0.0, to=1.0) float rightVolume) {
            this.mRightVolume = rightVolume;
            return this;
        }

        public PlayConfig build() {
            return new PlayConfig(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

