/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.biv.loader.glide;

import com.bumptech.glide.Glide;
import com.bumptech.glide.integration.okhttp3.OkHttpUrlLoader;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

public class GlideProgressSupport {
    private static Interceptor createInterceptor(final ResponseProgressListener listener) {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();
                Response response = chain.proceed(request);
                return response.newBuilder().body((ResponseBody)new OkHttpProgressResponseBody(request.url(), response.body(), listener)).build();
            }
        };
    }

    public static void init(Glide glide, OkHttpClient okHttpClient) {
        OkHttpClient.Builder builder = okHttpClient != null ? okHttpClient.newBuilder() : new OkHttpClient.Builder();
        builder.addNetworkInterceptor(GlideProgressSupport.createInterceptor(new DispatchingProgressListener()));
        glide.register(GlideUrl.class, InputStream.class, (ModelLoaderFactory)new OkHttpUrlLoader.Factory((Call.Factory)builder.build()));
    }

    public static void forget(String url) {
        DispatchingProgressListener.forget(url);
    }

    public static void expect(String url, ProgressListener listener) {
        DispatchingProgressListener.expect(url, listener);
    }

    private static class OkHttpProgressResponseBody
    extends ResponseBody {
        private final HttpUrl mUrl;
        private final ResponseBody mResponseBody;
        private final ResponseProgressListener mProgressListener;
        private BufferedSource mBufferedSource;

        OkHttpProgressResponseBody(HttpUrl url, ResponseBody responseBody, ResponseProgressListener progressListener) {
            this.mUrl = url;
            this.mResponseBody = responseBody;
            this.mProgressListener = progressListener;
        }

        public MediaType contentType() {
            return this.mResponseBody.contentType();
        }

        public long contentLength() {
            return this.mResponseBody.contentLength();
        }

        public BufferedSource source() {
            if (this.mBufferedSource == null) {
                this.mBufferedSource = Okio.buffer((Source)this.source((Source)this.mResponseBody.source()));
            }
            return this.mBufferedSource;
        }

        private Source source(Source source) {
            return new ForwardingSource(source){
                private long mTotalBytesRead;
                {
                    this.mTotalBytesRead = 0L;
                }

                public long read(Buffer sink, long byteCount) throws IOException {
                    long bytesRead = super.read(sink, byteCount);
                    long fullLength = OkHttpProgressResponseBody.this.mResponseBody.contentLength();
                    this.mTotalBytesRead = bytesRead == -1L ? fullLength : (this.mTotalBytesRead += bytesRead);
                    OkHttpProgressResponseBody.this.mProgressListener.update(OkHttpProgressResponseBody.this.mUrl, this.mTotalBytesRead, fullLength);
                    return bytesRead;
                }
            };
        }
    }

    private static class DispatchingProgressListener
    implements ResponseProgressListener {
        private static final Map<String, ProgressListener> LISTENERS = new HashMap<String, ProgressListener>();
        private static final Map<String, Integer> PROGRESSES = new HashMap<String, Integer>();

        private DispatchingProgressListener() {
        }

        static void forget(String url) {
            LISTENERS.remove(url);
            PROGRESSES.remove(url);
        }

        static void expect(String url, ProgressListener listener) {
            LISTENERS.put(url, listener);
        }

        @Override
        public void update(HttpUrl url, long bytesRead, long contentLength) {
            String key = url.toString();
            ProgressListener listener = LISTENERS.get(key);
            if (listener == null) {
                return;
            }
            Integer lastProgress = PROGRESSES.get(key);
            if (lastProgress == null) {
                listener.onDownloadStart();
            }
            if (contentLength <= bytesRead) {
                listener.onDownloadFinish();
                DispatchingProgressListener.forget(key);
                return;
            }
            int progress = (int)((float)bytesRead / (float)contentLength * 100.0f);
            if (lastProgress == null || progress != lastProgress) {
                PROGRESSES.put(key, progress);
                listener.onProgress(progress);
            }
        }
    }

    private static interface ResponseProgressListener {
        public void update(HttpUrl var1, long var2, long var4);
    }

    public static interface ProgressListener {
        public void onDownloadStart();

        public void onProgress(int var1);

        public void onDownloadFinish();
    }
}

