/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.biv.loader.glide;

import android.content.Context;
import android.net.Uri;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.request.animation.GlideAnimation;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.github.piasy.biv.loader.ImageLoader;
import java.io.File;

public final class GlideImageLoader
implements ImageLoader {
    private final RequestManager mRequestManager;

    private GlideImageLoader(Context context) {
        this.mRequestManager = Glide.with((Context)context);
    }

    public static GlideImageLoader with(Context context) {
        return new GlideImageLoader(context);
    }

    public void loadImage(Uri uri, final ImageLoader.Callback callback) {
        this.mRequestManager.load(uri).downloadOnly((Target)new SimpleTarget<File>(){

            public void onResourceReady(File image, GlideAnimation<? super File> glideAnimation) {
                callback.onCacheHit(image);
            }
        });
    }

    public void prefetch(Uri uri) {
        this.mRequestManager.load(uri).downloadOnly((Target)new SimpleTarget<File>(){

            public void onResourceReady(File resource, GlideAnimation<? super File> glideAnimation) {
            }
        });
    }
}

