/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.biv.loader.glide;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import androidx.annotation.NonNull;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.github.piasy.biv.loader.ImageLoader;
import com.github.piasy.biv.loader.glide.GlideLoaderException;
import com.github.piasy.biv.loader.glide.GlideProgressSupport;
import com.github.piasy.biv.loader.glide.ImageDownloadTarget;
import com.github.piasy.biv.loader.glide.PrefetchTarget;
import com.github.piasy.biv.metadata.ImageInfoExtractor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import okhttp3.OkHttpClient;

public class GlideImageLoader
implements ImageLoader {
    protected final RequestManager mRequestManager;
    private final Map<Integer, ImageDownloadTarget> mFlyingRequestTargets = new HashMap<Integer, ImageDownloadTarget>(3);

    protected GlideImageLoader(Context context, OkHttpClient okHttpClient) {
        GlideProgressSupport.init(Glide.get((Context)context), okHttpClient);
        this.mRequestManager = Glide.with((Context)context);
    }

    public static GlideImageLoader with(Context context) {
        return GlideImageLoader.with(context, null);
    }

    public static GlideImageLoader with(Context context, OkHttpClient okHttpClient) {
        return new GlideImageLoader(context, okHttpClient);
    }

    public void loadImage(int requestId, Uri uri, final ImageLoader.Callback callback) {
        final boolean[] cacheMissed = new boolean[1];
        ImageDownloadTarget target = new ImageDownloadTarget(uri.toString()){

            @Override
            public void onResourceReady(@NonNull File resource, Transition<? super File> transition) {
                super.onResourceReady(resource, transition);
                if (cacheMissed[0]) {
                    callback.onCacheMiss(ImageInfoExtractor.getImageType((File)resource), resource);
                } else {
                    callback.onCacheHit(ImageInfoExtractor.getImageType((File)resource), resource);
                }
                callback.onSuccess(resource);
            }

            @Override
            public void onLoadFailed(Drawable errorDrawable) {
                super.onLoadFailed(errorDrawable);
                callback.onFail((Exception)new GlideLoaderException(errorDrawable));
            }

            @Override
            public void onDownloadStart() {
                cacheMissed[0] = true;
                callback.onStart();
            }

            @Override
            public void onProgress(int progress) {
                callback.onProgress(progress);
            }

            @Override
            public void onDownloadFinish() {
                callback.onFinish();
            }
        };
        this.cancel(requestId);
        this.rememberTarget(requestId, target);
        this.downloadImageInto(uri, target);
    }

    public void prefetch(Uri uri) {
        this.downloadImageInto(uri, new PrefetchTarget());
    }

    public synchronized void cancel(int requestId) {
        this.clearTarget(this.mFlyingRequestTargets.remove(requestId));
    }

    public synchronized void cancelAll() {
        ArrayList<ImageDownloadTarget> targets = new ArrayList<ImageDownloadTarget>(this.mFlyingRequestTargets.values());
        for (ImageDownloadTarget target : targets) {
            this.clearTarget(target);
        }
    }

    protected void downloadImageInto(Uri uri, Target<File> target) {
        this.mRequestManager.downloadOnly().load(uri).into(target);
    }

    private synchronized void rememberTarget(int requestId, ImageDownloadTarget target) {
        this.mFlyingRequestTargets.put(requestId, target);
    }

    private void clearTarget(ImageDownloadTarget target) {
        if (target != null) {
            this.mRequestManager.clear((Target)target);
        }
    }
}

