/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.biv.loader.fresco;

import android.content.Context;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.binaryresource.FileBinaryResource;
import com.facebook.cache.common.CacheKey;
import com.facebook.cache.disk.FileCache;
import com.facebook.datasource.DataSource;
import com.facebook.datasource.DataSubscriber;
import com.facebook.drawee.backends.pipeline.DraweeConfig;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.facebook.drawee.view.SimpleDraweeView;
import com.facebook.imagepipeline.cache.DefaultCacheKeyFactory;
import com.facebook.imagepipeline.core.DefaultExecutorSupplier;
import com.facebook.imagepipeline.core.ImagePipeline;
import com.facebook.imagepipeline.core.ImagePipelineConfig;
import com.facebook.imagepipeline.core.ImagePipelineFactory;
import com.facebook.imagepipeline.request.ImageRequest;
import com.github.piasy.biv.loader.ImageLoader;
import com.github.piasy.biv.loader.fresco.ImageDownloadSubscriber;
import com.github.piasy.biv.loader.fresco.R;
import com.github.piasy.biv.view.BigImageView;
import java.io.File;

public final class FrescoImageLoader
implements ImageLoader {
    private final Context mAppContext;
    private final DefaultExecutorSupplier mExecutorSupplier;

    private FrescoImageLoader(Context appContext) {
        this.mAppContext = appContext;
        this.mExecutorSupplier = new DefaultExecutorSupplier(Runtime.getRuntime().availableProcessors());
    }

    public static FrescoImageLoader with(Context appContext) {
        return FrescoImageLoader.with(appContext, null, null);
    }

    public static FrescoImageLoader with(Context appContext, ImagePipelineConfig imagePipelineConfig) {
        return FrescoImageLoader.with(appContext, imagePipelineConfig, null);
    }

    public static FrescoImageLoader with(Context appContext, ImagePipelineConfig imagePipelineConfig, DraweeConfig draweeConfig) {
        Fresco.initialize((Context)appContext, (ImagePipelineConfig)imagePipelineConfig, (DraweeConfig)draweeConfig);
        return new FrescoImageLoader(appContext);
    }

    public void loadImage(Uri uri, final ImageLoader.Callback callback) {
        ImageRequest request = ImageRequest.fromUri((Uri)uri);
        File localCache = this.getCacheFile(request);
        if (localCache.exists()) {
            callback.onCacheHit(localCache);
        } else {
            callback.onStart();
            callback.onProgress(0);
            ImagePipeline pipeline = Fresco.getImagePipeline();
            DataSource source = pipeline.fetchEncodedImage(request, (Object)true);
            source.subscribe((DataSubscriber)new ImageDownloadSubscriber(this.mAppContext){

                @Override
                protected void onProgress(int progress) {
                    callback.onProgress(progress);
                }

                @Override
                protected void onSuccess(File image) {
                    callback.onFinish();
                    callback.onCacheMiss(image);
                }

                @Override
                protected void onFail(Throwable t) {
                    t.printStackTrace();
                }
            }, this.mExecutorSupplier.forBackgroundTasks());
        }
    }

    public View showThumbnail(BigImageView parent, Uri thumbnail) {
        SimpleDraweeView thumbnailView = (SimpleDraweeView)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.ui_fresco_thumbnail, (ViewGroup)parent, false);
        thumbnailView.setImageURI(thumbnail);
        return thumbnailView;
    }

    public void prefetch(Uri uri) {
        ImagePipeline pipeline = Fresco.getImagePipeline();
        pipeline.prefetchToDiskCache(ImageRequest.fromUri((Uri)uri), (Object)false);
    }

    private File getCacheFile(ImageRequest request) {
        FileCache mainFileCache = ImagePipelineFactory.getInstance().getMainFileCache();
        CacheKey cacheKey = DefaultCacheKeyFactory.getInstance().getEncodedCacheKey(request, (Object)false);
        File cacheFile = request.getSourceFile();
        if (mainFileCache.hasKey(cacheKey)) {
            cacheFile = ((FileBinaryResource)mainFileCache.getResource(cacheKey)).getFile();
        }
        return cacheFile;
    }
}

