/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.biv.utils;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Keep;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

@Keep
public final class ThreadedCallbacks
implements InvocationHandler {
    private static final Object NON_SENSE = new Object();
    private static final Handler MAIN_HANDLER = new Handler(Looper.getMainLooper());
    private final Object mTarget;
    private final Handler mHandler;

    private ThreadedCallbacks(Handler handler, Object target) {
        this.mHandler = handler;
        this.mTarget = target;
    }

    public static <T> T create(Class<T> type, T target) {
        return ThreadedCallbacks.create(MAIN_HANDLER, type, target);
    }

    public static <T> T create(Handler handler, Class<T> type, T target) {
        return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)new ThreadedCallbacks(handler, target));
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        if (!method.getReturnType().equals(Void.TYPE)) {
            throw new RuntimeException("Method should return void: " + method);
        }
        if (Looper.myLooper() == this.mHandler.getLooper()) {
            method.invoke(this.mTarget, args);
        } else {
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        method.invoke(ThreadedCallbacks.this.mTarget, args);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return NON_SENSE;
    }
}

