/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.audioprocessor;

public class AudioProcessor {
    private final int mBufferSize;
    private final byte[] mOutBuffer;
    private final float[] mFloatInput;
    private final float[] mFloatOutput;

    public AudioProcessor(int bufferSize) {
        this.mBufferSize = bufferSize;
        this.mOutBuffer = new byte[this.mBufferSize];
        this.mFloatInput = new float[this.mBufferSize / 2];
        this.mFloatOutput = new float[this.mBufferSize / 2];
    }

    private static native void process(float var0, byte[] var1, byte[] var2, int var3, int var4, float[] var5, float[] var6);

    public synchronized byte[] process(float ratio, byte[] input, int sampleRate) {
        AudioProcessor.process(ratio, input, this.mOutBuffer, this.mBufferSize, sampleRate, this.mFloatInput, this.mFloatOutput);
        return this.mOutBuffer;
    }

    static {
        System.loadLibrary("audio-processor");
    }
}

