/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.petitparser.parser.Parser;
import org.petitparser.parser.combinators.DelegateParser;
import org.petitparser.parser.combinators.SettableParser;
import org.petitparser.utils.Mirror;

public class Optimizer {
    private final List<Function<Parser, Parser>> transformers = new ArrayList<Function<Parser, Parser>>();

    public Optimizer add(Function<Parser, Parser> transformer) {
        this.transformers.add(transformer);
        return this;
    }

    public Optimizer removeDelegates() {
        return this.add(parser -> {
            while (DelegateParser.class.equals(parser.getClass()) || SettableParser.class.equals(parser.getClass())) {
                parser = parser.getChildren().get(0);
            }
            return parser;
        });
    }

    public Optimizer removeDuplicates() {
        HashSet uniques = new HashSet();
        return this.add(parser -> {
            Optional<Parser> target = uniques.stream().filter(each -> parser != each && parser.isEqualTo((Parser)each)).findFirst();
            if (target.isPresent()) {
                return target.get();
            }
            uniques.add(parser);
            return parser;
        });
    }

    public Parser transform(Parser parser) {
        Function<Parser, Parser> transformer = this.transformers.stream().reduce(Function::andThen).orElse(Function.identity());
        return Mirror.of(parser).transform(transformer);
    }
}

