/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.petitparser.context.Context;
import org.petitparser.context.Result;
import org.petitparser.parser.Parser;

public class GrammarDefinition {
    private final Map<String, Parser> parsers = new HashMap<String, Parser>();

    protected final Parser ref(String name) {
        return new Reference(name);
    }

    protected final void def(String name, Parser parser) {
        if (this.parsers.containsKey(name)) {
            throw new IllegalStateException("Duplicate production: " + name);
        }
        this.parsers.put(Objects.requireNonNull(name), Objects.requireNonNull(parser));
    }

    protected final void redef(String name, Parser parser) {
        if (!this.parsers.containsKey(name)) {
            throw new IllegalStateException("Undefined production: " + name);
        }
        this.parsers.put(Objects.requireNonNull(name), Objects.requireNonNull(parser));
    }

    protected final void redef(String name, Function<Parser, Parser> function) {
        if (!this.parsers.containsKey(name)) {
            throw new IllegalStateException("Undefined production: " + name);
        }
        this.redef(name, function.apply(this.parsers.get(name)));
    }

    protected final <S, T> void action(String name, Function<S, T> function) {
        this.redef(name, (Parser parser) -> parser.map(function));
    }

    public Parser build() {
        return this.build("start");
    }

    public Parser build(String name) {
        return this.resolve(new Reference(name));
    }

    private Parser resolve(Reference reference) {
        HashMap<Reference, Parser> mapping = new HashMap<Reference, Parser>();
        ArrayList<Parser> todo = new ArrayList<Parser>();
        todo.add(this.dereference(mapping, reference));
        HashSet<Parser> seen = new HashSet<Parser>(todo);
        while (!todo.isEmpty()) {
            Parser parent = (Parser)todo.remove(todo.size() - 1);
            for (Parser child : parent.getChildren()) {
                if (child instanceof Reference) {
                    Parser referenced = this.dereference(mapping, (Reference)child);
                    parent.replace(child, referenced);
                    child = referenced;
                }
                if (seen.contains(child)) continue;
                seen.add(child);
                todo.add(child);
            }
        }
        return (Parser)mapping.get(reference);
    }

    private Parser dereference(Map<Reference, Parser> mapping, Reference reference) {
        Parser parser = mapping.get(reference);
        if (parser == null) {
            ArrayList<Reference> references = new ArrayList<Reference>();
            references.add(reference);
            parser = reference.resolve();
            while (parser instanceof Reference) {
                Reference otherReference = (Reference)parser;
                if (references.contains(otherReference)) {
                    throw new IllegalStateException("Recursive references detected: " + String.join((CharSequence)", ", references.stream().map(ref -> ((Reference)ref).name).collect(Collectors.joining(", "))));
                }
                references.add(otherReference);
                parser = otherReference.resolve();
            }
            for (Reference otherReference : references) {
                mapping.put(otherReference, parser);
            }
        }
        return parser;
    }

    private class Reference
    extends Parser {
        private final String name;

        private Reference(String name) {
            this.name = Objects.requireNonNull(name);
        }

        private Parser resolve() {
            if (!GrammarDefinition.this.parsers.containsKey(this.name)) {
                throw new IllegalStateException("Unknown parser reference: " + this.name);
            }
            return (Parser)GrammarDefinition.this.parsers.get(this.name);
        }

        @Override
        public Result parseOn(Context context) {
            throw new UnsupportedOperationException("References cannot be parsed.");
        }

        @Override
        public Parser copy() {
            throw new UnsupportedOperationException("References cannot be copied.");
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            Reference reference = (Reference)other;
            return Objects.equals(this.name, reference.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

