/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.parser.primitive;

import java.util.Objects;
import java.util.function.Predicate;
import org.petitparser.context.Context;
import org.petitparser.context.Result;
import org.petitparser.parser.Parser;

public class StringParser
extends Parser {
    private final int size;
    private final Predicate<String> predicate;
    private final String message;

    public static Parser of(String value) {
        return StringParser.of(value, value + " expected");
    }

    public static Parser of(String value, String message) {
        return new StringParser(value.length(), value::equals, message);
    }

    public static Parser ofIgnoringCase(String value) {
        return StringParser.ofIgnoringCase(value, value + " expected");
    }

    public static Parser ofIgnoringCase(String value, String message) {
        return new StringParser(value.length(), value::equalsIgnoreCase, message);
    }

    private StringParser(int size, Predicate<String> predicate, String message) {
        this.size = size;
        this.predicate = Objects.requireNonNull(predicate, "Undefined predicate");
        this.message = Objects.requireNonNull(message, "Undefined message");
    }

    @Override
    public Result parseOn(Context context) {
        String result;
        String buffer = context.getBuffer();
        int start = context.getPosition();
        int stop = start + this.size;
        if (stop <= buffer.length() && this.predicate.test(result = buffer.substring(start, stop))) {
            return context.success(result, stop);
        }
        return context.failure(this.message);
    }

    @Override
    protected boolean hasEqualProperties(Parser other) {
        return super.hasEqualProperties(other) && Objects.equals(this.size, ((StringParser)other).size) && Objects.equals(this.predicate, ((StringParser)other).predicate) && Objects.equals(this.message, ((StringParser)other).message);
    }

    @Override
    public StringParser copy() {
        return new StringParser(this.size, this.predicate, this.message);
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.message + "]";
    }
}

