/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.parser.primitive;

import java.util.Objects;
import org.petitparser.context.Context;
import org.petitparser.context.Result;
import org.petitparser.parser.Parser;
import org.petitparser.parser.primitive.CharacterPredicate;

public class CharacterParser
extends Parser {
    private final CharacterPredicate matcher;
    private final String message;

    public static CharacterParser of(CharacterPredicate predicate, String message) {
        return new CharacterParser(predicate, message);
    }

    public static CharacterParser of(char character) {
        return CharacterParser.of(character, "'" + character + "' expected");
    }

    public static CharacterParser of(char character, String message) {
        return CharacterParser.of(CharacterPredicate.of(character), message);
    }

    public static CharacterParser any() {
        return CharacterParser.any("any character expected");
    }

    public static CharacterParser any(String message) {
        return CharacterParser.of(CharacterPredicate.any(), message);
    }

    public static CharacterParser anyOf(String chars) {
        return CharacterParser.anyOf(chars, "any of '" + chars + "' expected");
    }

    public static CharacterParser anyOf(String chars, String message) {
        return CharacterParser.of(CharacterPredicate.anyOf(chars), message);
    }

    public static CharacterParser none() {
        return CharacterParser.none("no character expected");
    }

    public static CharacterParser none(String message) {
        return CharacterParser.of(CharacterPredicate.none(), message);
    }

    public static CharacterParser noneOf(String chars) {
        return CharacterParser.noneOf(chars, "none of '" + chars + "' expected");
    }

    public static CharacterParser noneOf(String chars, String message) {
        return CharacterParser.of(CharacterPredicate.noneOf(chars), message);
    }

    public static CharacterParser digit() {
        return CharacterParser.digit("digit expected");
    }

    public static CharacterParser digit(String message) {
        return new CharacterParser(Character::isDigit, message);
    }

    public static CharacterParser letter() {
        return CharacterParser.letter("letter expected");
    }

    public static CharacterParser letter(String message) {
        return CharacterParser.of(Character::isLetter, message);
    }

    public static CharacterParser lowerCase() {
        return CharacterParser.lowerCase("lowercase letter expected");
    }

    public static CharacterParser lowerCase(String message) {
        return CharacterParser.of(Character::isLowerCase, message);
    }

    public static CharacterParser pattern(String pattern) {
        return CharacterParser.pattern(pattern, "[" + pattern + "] expected");
    }

    public static CharacterParser pattern(String pattern, String message) {
        return CharacterParser.of(CharacterPredicate.pattern(pattern), message);
    }

    public static CharacterParser range(char start, char stop) {
        return CharacterParser.range(start, stop, start + ".." + stop + " expected");
    }

    public static CharacterParser range(char start, char stop, String message) {
        return CharacterParser.of(CharacterPredicate.range(start, stop), message);
    }

    public static CharacterParser upperCase() {
        return CharacterParser.upperCase("uppercase letter expected");
    }

    public static CharacterParser upperCase(String message) {
        return CharacterParser.of(Character::isUpperCase, message);
    }

    public static CharacterParser whitespace() {
        return CharacterParser.whitespace("whitespace expected");
    }

    public static CharacterParser whitespace(String message) {
        return CharacterParser.of(Character::isWhitespace, message);
    }

    public static CharacterParser word() {
        return CharacterParser.word("letter or digit expected");
    }

    public static CharacterParser word(String message) {
        return CharacterParser.of(Character::isLetterOrDigit, message);
    }

    private CharacterParser(CharacterPredicate matcher, String message) {
        this.matcher = Objects.requireNonNull(matcher, "Undefined matcher");
        this.message = Objects.requireNonNull(message, "Undefined message");
    }

    @Override
    public Result parseOn(Context context) {
        char result;
        String buffer = context.getBuffer();
        int position = context.getPosition();
        if (position < buffer.length() && this.matcher.test(result = buffer.charAt(position))) {
            return context.success(Character.valueOf(result), position + 1);
        }
        return context.failure(this.message);
    }

    @Override
    public CharacterParser neg(String message) {
        return CharacterParser.of(this.matcher.not(), message);
    }

    @Override
    protected boolean hasEqualProperties(Parser other) {
        return super.hasEqualProperties(other) && Objects.equals(this.matcher, ((CharacterParser)other).matcher) && Objects.equals(this.message, ((CharacterParser)other).message);
    }

    @Override
    public CharacterParser copy() {
        return CharacterParser.of(this.matcher, this.message);
    }

    @Override
    public String toString() {
        return super.toString() + "[" + this.message + "]";
    }
}

