/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.parser.combinators;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.petitparser.context.Context;
import org.petitparser.context.Result;
import org.petitparser.parser.Parser;

public class DelegateParser
extends Parser {
    protected Parser delegate;

    public DelegateParser(Parser delegate) {
        this.delegate = Objects.requireNonNull(delegate, "Undefined delegate parser");
    }

    @Override
    public Result parseOn(Context context) {
        return this.delegate.parseOn(context);
    }

    @Override
    public void replace(Parser source, Parser target) {
        super.replace(source, target);
        if (this.delegate == source) {
            this.delegate = target;
        }
    }

    @Override
    public List<Parser> getChildren() {
        return Collections.singletonList(this.delegate);
    }

    @Override
    public DelegateParser copy() {
        return new DelegateParser(this.delegate);
    }
}

