/*
 * Decompiled with CFR 0.152.
 */
package org.petitparser.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.petitparser.context.Context;
import org.petitparser.context.Result;
import org.petitparser.parser.actions.ActionParser;
import org.petitparser.parser.actions.ContinuationParser;
import org.petitparser.parser.actions.FlattenParser;
import org.petitparser.parser.actions.TokenParser;
import org.petitparser.parser.actions.TrimmingParser;
import org.petitparser.parser.combinators.AndParser;
import org.petitparser.parser.combinators.ChoiceParser;
import org.petitparser.parser.combinators.EndOfInputParser;
import org.petitparser.parser.combinators.NotParser;
import org.petitparser.parser.combinators.OptionalParser;
import org.petitparser.parser.combinators.SequenceParser;
import org.petitparser.parser.combinators.SettableParser;
import org.petitparser.parser.primitive.CharacterParser;
import org.petitparser.parser.repeating.GreedyRepeatingParser;
import org.petitparser.parser.repeating.LazyRepeatingParser;
import org.petitparser.parser.repeating.PossessiveRepeatingParser;
import org.petitparser.utils.Functions;

public abstract class Parser {
    public abstract Result parseOn(Context var1);

    public Result parse(String input) {
        return this.parseOn(new Context(input, 0));
    }

    public boolean accept(String input) {
        return this.parse(input).isSuccess();
    }

    public <T> List<T> matches(String input) {
        ArrayList list = new ArrayList();
        this.and().map(list::add).seq(CharacterParser.any()).or(CharacterParser.any()).star().parse(input);
        return list;
    }

    public <T> List<T> matchesSkipping(String input) {
        ArrayList list = new ArrayList();
        this.map(list::add).or(CharacterParser.any()).star().parse(input);
        return list;
    }

    public Parser optional() {
        return this.optional(null);
    }

    public Parser optional(Object otherwise) {
        return new OptionalParser(this, otherwise);
    }

    public Parser star() {
        return this.repeat(0, -1);
    }

    public Parser starGreedy(Parser limit) {
        return this.repeatGreedy(limit, 0, -1);
    }

    public Parser starLazy(Parser limit) {
        return this.repeatLazy(limit, 0, -1);
    }

    public Parser plus() {
        return this.repeat(1, -1);
    }

    public Parser plusGreedy(Parser limit) {
        return this.repeatGreedy(limit, 1, -1);
    }

    public Parser plusLazy(Parser limit) {
        return this.repeatLazy(limit, 1, -1);
    }

    public Parser repeat(int min, int max) {
        return new PossessiveRepeatingParser(this, min, max);
    }

    public Parser repeatGreedy(Parser limit, int min, int max) {
        return new GreedyRepeatingParser(this, limit, min, max);
    }

    public Parser repeatLazy(Parser limit, int min, int max) {
        return new LazyRepeatingParser(this, limit, min, max);
    }

    public Parser times(int count) {
        return this.repeat(count, count);
    }

    public SequenceParser seq(Parser ... others) {
        Parser[] parsers = new Parser[1 + others.length];
        parsers[0] = this;
        System.arraycopy(others, 0, parsers, 1, others.length);
        return new SequenceParser(parsers);
    }

    public ChoiceParser or(Parser ... others) {
        Parser[] parsers = new Parser[1 + others.length];
        parsers[0] = this;
        System.arraycopy(others, 0, parsers, 1, others.length);
        return new ChoiceParser(parsers);
    }

    public Parser and() {
        return new AndParser(this);
    }

    public Parser callCC(ContinuationParser.ContinuationHandler handler) {
        return new ContinuationParser(this, handler);
    }

    public Parser not() {
        return this.not("unexpected");
    }

    public Parser not(String message) {
        return new NotParser(this, message);
    }

    public Parser neg() {
        return this.neg(this + " not expected");
    }

    public Parser neg(String message) {
        return this.not(message).seq(CharacterParser.any()).pick(1);
    }

    public Parser flatten() {
        return new FlattenParser(this);
    }

    public Parser token() {
        return new TokenParser(this);
    }

    public Parser trim() {
        return this.trim(CharacterParser.whitespace());
    }

    public Parser trim(Parser both) {
        return this.trim(both, both);
    }

    public Parser trim(Parser before, Parser after) {
        return new TrimmingParser(this, before, after);
    }

    public Parser end() {
        return this.end("end of input expected");
    }

    public Parser end(String message) {
        return new EndOfInputParser(this, message);
    }

    public SettableParser settable() {
        return SettableParser.with(this);
    }

    public <A, B> Parser map(Function<A, B> function) {
        return new ActionParser<A, B>(this, function);
    }

    public Parser pick(int index) {
        return this.map(Functions.nthOfList(index));
    }

    public Parser permute(int ... indexes) {
        return this.map(Functions.permutationOfList(indexes));
    }

    public Parser separatedBy(Parser separator) {
        return new SequenceParser(this, new SequenceParser(separator, this).star()).map(input -> {
            ArrayList result = new ArrayList();
            result.add(input.get(0));
            ((List)input.get(1)).forEach(result::addAll);
            return result;
        });
    }

    public Parser delimitedBy(Parser separator) {
        return this.separatedBy(separator).seq(separator.optional()).map(input -> {
            ArrayList result = new ArrayList((Collection)input.get(0));
            if (input.get(1) != null) {
                result.add(input.get(1));
            }
            return result;
        });
    }

    public abstract Parser copy();

    public boolean isEqualTo(Parser other) {
        return this.isEqualTo(other, new HashSet<Parser>());
    }

    protected boolean isEqualTo(Parser other, Set<Parser> seen) {
        if (this.equals(other) || seen.contains(this)) {
            return true;
        }
        seen.add(this);
        return Objects.equals(this.getClass(), other.getClass()) && this.hasEqualProperties(other) && this.hasEqualChildren(other, seen);
    }

    protected boolean hasEqualProperties(Parser other) {
        return true;
    }

    protected boolean hasEqualChildren(Parser other, Set<Parser> seen) {
        List<Parser> thisChildren = this.getChildren();
        List<Parser> otherChildren = other.getChildren();
        if (thisChildren.size() != otherChildren.size()) {
            return false;
        }
        for (int i = 0; i < thisChildren.size(); ++i) {
            if (thisChildren.get(i).isEqualTo(otherChildren.get(i), seen)) continue;
            return false;
        }
        return true;
    }

    public List<Parser> getChildren() {
        return Collections.emptyList();
    }

    public void replace(Parser source, Parser target) {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

