/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.NumberUtility;

final class EIntegerTextString {
    private static final int ShortMask = 65535;

    private EIntegerTextString() {
    }

    public static EInteger FromRadixSubstringImpl(String cs, int radix, int index, int endIndex) {
        char c;
        if (radix < 2) {
            throw new IllegalArgumentException("radix(" + radix + ") is less than 2");
        }
        if (radix > 36) {
            throw new IllegalArgumentException("radix(" + radix + ") is more than 36");
        }
        if (index < 0) {
            throw new IllegalArgumentException("index(" + index + ") is less than 0");
        }
        if (index > cs.length()) {
            throw new IllegalArgumentException("index(" + index + ") is more than " + cs.length());
        }
        if (endIndex < 0) {
            throw new IllegalArgumentException("endIndex(" + endIndex + ") is less than 0");
        }
        if (endIndex > cs.length()) {
            throw new IllegalArgumentException("endIndex(" + endIndex + ") is more than " + cs.length());
        }
        if (endIndex < index) {
            throw new IllegalArgumentException("endIndex(" + endIndex + ") is less than " + index);
        }
        if (index == endIndex) {
            throw new NumberFormatException("No digits");
        }
        boolean negative = false;
        if (cs.charAt(index) == '-') {
            if (++index == endIndex) {
                throw new NumberFormatException("No digits");
            }
            negative = true;
        }
        while (index < endIndex && (c = cs.charAt(index)) == '0') {
            ++index;
        }
        int effectiveLength = endIndex - index;
        if (effectiveLength == 0) {
            return EInteger.FromInt32(0);
        }
        int[] c2d = EInteger.CharToDigit;
        if (radix == 16) {
            int leftover = effectiveLength & 3;
            int wordCount = effectiveLength >> 2;
            if (leftover != 0) {
                ++wordCount;
            }
            short[] bigint = new short[wordCount];
            int currentDigit = wordCount - 1;
            if (leftover != 0) {
                int extraWord = 0;
                for (int i = 0; i < leftover; ++i) {
                    int digit;
                    extraWord <<= 4;
                    char c2 = cs.charAt(index + i);
                    int n = digit = c2 >= '\u0080' ? 36 : c2d[c2];
                    if (digit >= 16) {
                        throw new NumberFormatException("Illegal character found");
                    }
                    extraWord |= digit;
                }
                bigint[currentDigit] = (short)extraWord;
                --currentDigit;
                index += leftover;
            }
            while (index < endIndex) {
                int digit;
                char c3 = cs.charAt(index + 3);
                int n = digit = c3 >= '\u0080' ? 36 : c2d[c3];
                if (digit >= 16) {
                    throw new NumberFormatException("Illegal character found");
                }
                int word = digit;
                c3 = cs.charAt(index + 2);
                int n2 = digit = c3 >= '\u0080' ? 36 : c2d[c3];
                if (digit >= 16) {
                    throw new NumberFormatException("Illegal character found");
                }
                word |= digit << 4;
                c3 = cs.charAt(index + 1);
                int n3 = digit = c3 >= '\u0080' ? 36 : c2d[c3];
                if (digit >= 16) {
                    throw new NumberFormatException("Illegal character found");
                }
                word |= digit << 8;
                c3 = cs.charAt(index);
                int n4 = digit = c3 >= '\u0080' ? 36 : c2d[c3];
                if (digit >= 16) {
                    throw new NumberFormatException("Illegal character found");
                }
                index += 4;
                bigint[currentDigit] = (short)(word |= digit << 12);
                --currentDigit;
            }
            int count = EInteger.CountWords(bigint);
            return count == 0 ? EInteger.FromInt32(0) : new EInteger(count, bigint, negative);
        }
        if (radix == 2) {
            int leftover = effectiveLength & 0xF;
            int wordCount = effectiveLength >> 4;
            if (leftover != 0) {
                ++wordCount;
            }
            short[] bigint = new short[wordCount];
            int currentDigit = wordCount - 1;
            if (leftover != 0) {
                int extraWord = 0;
                for (int i = 0; i < leftover; ++i) {
                    int digit;
                    extraWord <<= 1;
                    char c4 = cs.charAt(index + i);
                    int n = c4 == '0' ? 0 : (digit = c4 == '1' ? 1 : 2);
                    if (digit >= 2) {
                        throw new NumberFormatException("Illegal character found");
                    }
                    extraWord |= digit;
                }
                bigint[currentDigit] = (short)extraWord;
                --currentDigit;
                index += leftover;
            }
            while (index < endIndex) {
                int word = 0;
                int idx = index + 15;
                for (int i = 0; i < 16; ++i) {
                    int digit;
                    char c5 = cs.charAt(idx);
                    int n = c5 == '0' ? 0 : (digit = c5 == '1' ? 1 : 2);
                    if (digit >= 2) {
                        throw new NumberFormatException("Illegal character found");
                    }
                    --idx;
                    word |= digit << i;
                }
                index += 16;
                bigint[currentDigit] = (short)word;
                --currentDigit;
            }
            int count = EInteger.CountWords(bigint);
            return count == 0 ? EInteger.FromInt32(0) : new EInteger(count, bigint, negative);
        }
        return EIntegerTextString.FromRadixSubstringGeneral(cs, radix, index, endIndex, negative);
    }

    private static EInteger FromRadixSubstringGeneral(String cs, int radix, int index, int endIndex, boolean negative) {
        if (endIndex - index > 72) {
            int midIndex = index + (endIndex - index) / 2;
            EInteger eia = EIntegerTextString.FromRadixSubstringGeneral(cs, radix, index, midIndex, false);
            EInteger eib = EIntegerTextString.FromRadixSubstringGeneral(cs, radix, midIndex, endIndex, false);
            EInteger mult = null;
            int intpow = endIndex - midIndex;
            if (radix == 10) {
                eia = NumberUtility.MultiplyByPowerOfFive(eia, intpow).ShiftLeft(intpow);
            } else if (radix == 5) {
                eia = NumberUtility.MultiplyByPowerOfFive(eia, intpow);
            } else {
                mult = EInteger.FromInt32(radix).Pow(endIndex - midIndex);
                eia = eia.Multiply(mult);
            }
            eia = eia.Add(eib);
            if (negative) {
                eia = eia.Negate();
            }
            return eia;
        }
        return EIntegerTextString.FromRadixSubstringInner(cs, radix, index, endIndex, negative);
    }

    private static EInteger FromRadixSubstringInner(String cs, int radix, int index, int endIndex, boolean negative) {
        int count;
        if (radix <= 10) {
            int digit;
            char c;
            int i;
            long rv = 0L;
            int digitCount = 0;
            if (radix == 10) {
                for (i = index; i < endIndex; ++i) {
                    c = cs.charAt(i);
                    digit = c - 48;
                    if (digit >= radix || digit < 0) {
                        throw new NumberFormatException("Illegal character found");
                    }
                    if (digitCount < 0 || digitCount >= 18) {
                        digitCount = -1;
                        break;
                    }
                    if (digitCount > 0 || digit != 0) {
                        ++digitCount;
                    }
                    rv = rv * 10L + (long)digit;
                }
                if (digitCount >= 0) {
                    return EInteger.FromInt64(negative ? -rv : rv);
                }
            } else {
                for (i = index; i < endIndex; ++i) {
                    c = cs.charAt(i);
                    int n = digit = c >= '\u0080' ? 36 : c - 48;
                    if (digit >= radix || digit < 0) {
                        throw new NumberFormatException("Illegal character found");
                    }
                    if (digitCount < 0 || digitCount >= 18) {
                        digitCount = -1;
                        break;
                    }
                    if (digitCount > 0 || digit != 0) {
                        ++digitCount;
                    }
                    rv = rv * (long)radix + (long)digit;
                }
                if (digitCount >= 0) {
                    return EInteger.FromInt64(negative ? -rv : rv);
                }
            }
        }
        int[] c2d = EInteger.CharToDigit;
        int[] d2w = EInteger.DigitsInWord;
        long lsize = (long)(endIndex - index) * 100L / (long)d2w[radix] + 1L;
        lsize = Math.min(lsize, Integer.MAX_VALUE);
        lsize = Math.max(lsize, 5L);
        short[] bigint = new short[(int)lsize];
        if (radix == 10) {
            long rv = 0L;
            int ei = endIndex - index <= 18 ? endIndex : index + 18;
            for (int i = index; i < ei; ++i) {
                char c = cs.charAt(i);
                int digit = c - 48;
                if (digit >= radix || digit < 0) {
                    throw new NumberFormatException("Illegal character found");
                }
                rv = rv * 10L + (long)digit;
            }
            bigint[0] = (short)(rv & 0xFFFFL);
            bigint[1] = (short)(rv >> 16 & 0xFFFFL);
            bigint[2] = (short)(rv >> 32 & 0xFFFFL);
            bigint[3] = (short)(rv >> 48 & 0xFFFFL);
            int bn = Math.min(bigint.length, 5);
            for (int i = ei; i < endIndex; ++i) {
                short carry = 0;
                int digit = 0;
                int overf = 0;
                if (i < endIndex - 3) {
                    overf = 55536;
                    int d1 = cs.charAt(i) - 48;
                    int d2 = cs.charAt(i + 1) - 48;
                    int d3 = cs.charAt(i + 2) - 48;
                    int d4 = cs.charAt(i + 3) - 48;
                    i += 3;
                    if (d1 >= 10 || d1 < 0 || d2 >= 10 || d2 < 0 || d3 >= 10 || d3 < 0 || d4 >= 10 || d4 < 0) {
                        throw new NumberFormatException("Illegal character found");
                    }
                    digit = d1 * 1000 + d2 * 100 + d3 * 10 + d4;
                    for (int j = 0; j < bn; ++j) {
                        int p = (bigint[j] & 0xFFFF) * 10000;
                        int p2 = carry & 0xFFFF;
                        bigint[j] = (short)(p += p2);
                        carry = (short)(p >> 16);
                    }
                } else {
                    overf = 65526;
                    char c = cs.charAt(i);
                    digit = c - 48;
                    if (digit >= 10 || digit < 0) {
                        throw new NumberFormatException("Illegal character found");
                    }
                    for (int j = 0; j < bn; ++j) {
                        int p = (bigint[j] & 0xFFFF) * 10;
                        int p2 = carry & 0xFFFF;
                        bigint[j] = (short)(p += p2);
                        carry = (short)(p >> 16);
                    }
                }
                if (carry != 0) {
                    bigint = EInteger.GrowForCarry(bigint, carry);
                }
                if (digit != 0) {
                    int d = bigint[0] & 0xFFFF;
                    if (d <= overf) {
                        bigint[0] = (short)(d + digit);
                    } else if (EInteger.IncrementWords(bigint, 0, bigint.length, (short)digit) != 0) {
                        bigint = EInteger.GrowForCarry(bigint, (short)1);
                    }
                }
                bn = Math.min(bigint.length, bn + 1);
            }
        } else {
            boolean haveSmallInt = true;
            int[] msi = EInteger.MaxSafeInts;
            int maxSafeInt = msi[radix - 2];
            int maxShortPlusOneMinusRadix = 65536 - radix;
            int smallInt = 0;
            for (int i = index; i < endIndex; ++i) {
                int digit;
                char c = cs.charAt(i);
                int n = digit = c >= '\u0080' ? 36 : c2d[c];
                if (digit >= radix) {
                    throw new NumberFormatException("Illegal character found");
                }
                if (haveSmallInt && smallInt < maxSafeInt) {
                    smallInt = smallInt * radix + digit;
                    continue;
                }
                if (haveSmallInt) {
                    bigint[0] = (short)(smallInt & 0xFFFF);
                    bigint[1] = (short)(smallInt >> 16 & 0xFFFF);
                    haveSmallInt = false;
                }
                short carry = 0;
                int n2 = bigint.length;
                for (int j = 0; j < n2; ++j) {
                    int p = (bigint[j] & 0xFFFF) * radix;
                    int p2 = carry & 0xFFFF;
                    bigint[j] = (short)(p += p2);
                    carry = (short)(p >> 16);
                }
                if (carry != 0) {
                    bigint = EInteger.GrowForCarry(bigint, carry);
                }
                if (digit == 0) continue;
                int d = bigint[0] & 0xFFFF;
                if (d <= maxShortPlusOneMinusRadix) {
                    bigint[0] = (short)(d + digit);
                    continue;
                }
                if (EInteger.IncrementWords(bigint, 0, bigint.length, (short)digit) == 0) continue;
                bigint = EInteger.GrowForCarry(bigint, (short)1);
            }
            if (haveSmallInt) {
                bigint[0] = (short)(smallInt & 0xFFFF);
                bigint[1] = (short)(smallInt >> 16 & 0xFFFF);
            }
        }
        return (count = EInteger.CountWords(bigint)) == 0 ? EInteger.FromInt32(0) : new EInteger(count, bigint, negative);
    }
}

