/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.FastInteger;
import com.upokecenter.numbers.FastIntegerFixed;
import com.upokecenter.numbers.IRadixMath;
import com.upokecenter.numbers.IRadixMathHelper;

final class NumberUtility {
    private static final EInteger[] ValueBigIntPowersOfTen = new EInteger[]{EInteger.FromInt32(1), EInteger.FromInt32(10), EInteger.FromInt64(100L), EInteger.FromInt64(1000L), EInteger.FromInt64(10000L), EInteger.FromInt64(100000L), EInteger.FromInt64(1000000L), EInteger.FromInt64(10000000L), EInteger.FromInt64(100000000L), EInteger.FromInt64(1000000000L), EInteger.FromInt64(10000000000L), EInteger.FromInt64(100000000000L), EInteger.FromInt64(1000000000000L), EInteger.FromInt64(10000000000000L), EInteger.FromInt64(100000000000000L), EInteger.FromInt64(1000000000000000L), EInteger.FromInt64(10000000000000000L), EInteger.FromInt64(100000000000000000L), EInteger.FromInt64(1000000000000000000L)};
    private static final EInteger[] ValueBigIntPowersOfFive = new EInteger[]{EInteger.FromInt32(1), EInteger.FromInt64(5L), EInteger.FromInt64(25L), EInteger.FromInt64(125L), EInteger.FromInt64(625L), EInteger.FromInt64(3125L), EInteger.FromInt64(15625L), EInteger.FromInt64(78125L), EInteger.FromInt64(390625L), EInteger.FromInt64(1953125L), EInteger.FromInt64(9765625L), EInteger.FromInt64(48828125L), EInteger.FromInt64(244140625L), EInteger.FromInt64(1220703125L), EInteger.FromInt64(6103515625L), EInteger.FromInt64(30517578125L), EInteger.FromInt64(152587890625L), EInteger.FromInt64(762939453125L), EInteger.FromInt64(3814697265625L), EInteger.FromInt64(19073486328125L), EInteger.FromInt64(95367431640625L), EInteger.FromInt64(476837158203125L), EInteger.FromInt64(2384185791015625L), EInteger.FromInt64(11920928955078125L), EInteger.FromInt64(59604644775390625L), EInteger.FromInt64(298023223876953125L), EInteger.FromInt64(1490116119384765625L), EInteger.FromInt64(7450580596923828125L)};
    private static final PowerCache ValuePowerOfFiveCache = new PowerCache();
    private static final PowerCache ValuePowerOfTenCache = new PowerCache();
    private static final EInteger ValueFivePower40 = EInteger.FromInt64(95367431640625L).Multiply(EInteger.FromInt64(95367431640625L));

    private NumberUtility() {
    }

    static int ShiftLeftOne(int[] arr) {
        int carry = 0;
        for (int i = 0; i < arr.length; ++i) {
            int item = arr[i];
            arr[i] = arr[i] << 1 | carry;
            carry = item >> 31 != 0 ? 1 : 0;
        }
        return carry;
    }

    private static int CountTrailingZeros(int numberValue) {
        if (numberValue == 0) {
            return 32;
        }
        int i = 0;
        if (numberValue << 16 == 0) {
            numberValue >>= 16;
            i += 16;
        }
        if (numberValue << 24 == 0) {
            numberValue >>= 8;
            i += 8;
        }
        if (numberValue << 28 == 0) {
            numberValue >>= 4;
            i += 4;
        }
        if (numberValue << 30 == 0) {
            numberValue >>= 2;
            i += 2;
        }
        if (numberValue << 31 == 0) {
            ++i;
        }
        return i;
    }

    static int BitLength(int numberValue) {
        if (numberValue == 0) {
            return 0;
        }
        int i = 32;
        if (numberValue >> 16 == 0) {
            numberValue <<= 16;
            i -= 16;
        }
        if (numberValue >> 24 == 0) {
            numberValue <<= 8;
            i -= 8;
        }
        if (numberValue >> 28 == 0) {
            numberValue <<= 4;
            i -= 4;
        }
        if (numberValue >> 30 == 0) {
            numberValue <<= 2;
            i -= 2;
        }
        if (numberValue >> 31 == 0) {
            --i;
        }
        return i;
    }

    static int ShiftAwayTrailingZerosTwoElements(int[] arr) {
        int a0 = arr[0];
        int a1 = arr[1];
        int tz = NumberUtility.CountTrailingZeros(a0);
        if (tz == 0) {
            return 0;
        }
        if (tz < 32) {
            int carry = a1 << 32 - tz;
            arr[0] = a0 >> tz & Integer.MAX_VALUE >> tz - 1 | carry;
            arr[1] = a1 >> tz & Integer.MAX_VALUE >> tz - 1;
            return tz;
        }
        tz = NumberUtility.CountTrailingZeros(a1);
        arr[0] = tz == 32 ? 0 : (tz > 0 ? a1 >> tz & Integer.MAX_VALUE >> tz - 1 : a1);
        arr[1] = 0;
        return 32 + tz;
    }

    static boolean HasBitSet(int[] arr, int bit) {
        return bit >> 5 < arr.length && (arr[bit >> 5] & 1 << (bit & 0x1F)) != 0;
    }

    public static EInteger FindPowerOfTen(long diffLong) {
        if (diffLong < 0L) {
            return EInteger.FromInt32(0);
        }
        if (diffLong == 0L) {
            return EInteger.FromInt32(1);
        }
        return diffLong <= Integer.MAX_VALUE ? NumberUtility.FindPowerOfTen((int)diffLong) : NumberUtility.FindPowerOfTenFromBig(EInteger.FromInt64(diffLong));
    }

    static EInteger MultiplyByPowerOfTen(EInteger v, int precision) {
        if (precision < 0 || v.isZero()) {
            return EInteger.FromInt32(0);
        }
        if (precision < ValueBigIntPowersOfTen.length) {
            return v.Multiply(ValueBigIntPowersOfTen[precision]);
        }
        return precision <= 94 ? v.Multiply(NumberUtility.FindPowerOfFive(precision)).ShiftLeft(precision) : NumberUtility.MultiplyByPowerOfFive(v, precision).ShiftLeft(precision);
    }

    static EInteger MultiplyByPowerOfTen(EInteger v, EInteger eprecision) {
        return eprecision.signum() < 0 || v.isZero() ? EInteger.FromInt32(0) : NumberUtility.MultiplyByPowerOfFive(v, eprecision).ShiftLeft(eprecision);
    }

    static EInteger MultiplyByPowerOfFive(EInteger v, int precision) {
        if (precision < 0 || v.isZero()) {
            return EInteger.FromInt32(0);
        }
        if (precision <= 94) {
            return v.Multiply(NumberUtility.FindPowerOfFive(precision));
        }
        EInteger otherPower = ValuePowerOfFiveCache.GetCachedPowerInt(precision);
        if (otherPower != null) {
            return v.Multiply(otherPower);
        }
        int powprec = 64;
        v = v.Multiply(NumberUtility.FindPowerOfFive(precision & 0x3F));
        precision >>= 6;
        while (precision > 0) {
            if ((precision & 1) == 1) {
                otherPower = ValuePowerOfFiveCache.GetCachedPowerInt(powprec);
                if (otherPower == null) {
                    EInteger prevPower = NumberUtility.FindPowerOfFive(powprec >> 1);
                    otherPower = prevPower.Multiply(prevPower);
                    ValuePowerOfFiveCache.AddPower(powprec, otherPower);
                }
                v = v.Multiply(otherPower);
            }
            powprec <<= 1;
            precision >>= 1;
        }
        return v;
    }

    static EInteger MultiplyByPowerOfFive(EInteger v, EInteger epower) {
        return epower.CanFitInInt32() ? NumberUtility.MultiplyByPowerOfFive(v, epower.ToInt32Checked()) : v.Multiply(NumberUtility.FindPowerOfFiveFromBig(epower));
    }

    static EInteger FindPowerOfFiveFromBig(EInteger diff) {
        int sign = diff.signum();
        if (sign < 0) {
            return EInteger.FromInt32(0);
        }
        if (sign == 0) {
            return EInteger.FromInt32(1);
        }
        if (diff.CanFitInInt32()) {
            return NumberUtility.FindPowerOfFive(diff.ToInt32Checked());
        }
        EInteger epowprec = EInteger.FromInt32(1);
        EInteger ret = EInteger.FromInt32(1);
        while (diff.signum() > 0) {
            if (!diff.isEven()) {
                EInteger otherPower = ValuePowerOfFiveCache.GetCachedPower(epowprec);
                if (otherPower == null) {
                    EInteger prevPower = NumberUtility.FindPowerOfFiveFromBig(epowprec.ShiftRight(1));
                    otherPower = prevPower.Multiply(prevPower);
                    ValuePowerOfFiveCache.AddPower(epowprec, otherPower);
                }
                ret = ret.Multiply(otherPower);
            }
            epowprec = epowprec.ShiftLeft(1);
            diff = diff.ShiftRight(1);
        }
        return ret;
    }

    static EInteger FindPowerOfTenFromBig(EInteger bigintExponent) {
        int sign = bigintExponent.signum();
        if (sign < 0) {
            return EInteger.FromInt32(0);
        }
        if (sign == 0) {
            return EInteger.FromInt32(1);
        }
        return bigintExponent.CanFitInInt32() ? NumberUtility.FindPowerOfTen(bigintExponent.ToInt32Checked()) : NumberUtility.FindPowerOfFiveFromBig(bigintExponent).ShiftLeft(bigintExponent);
    }

    static EInteger FindPowerOfFive(int precision) {
        if (precision < 0) {
            return EInteger.FromInt32(0);
        }
        if (precision <= 27) {
            return ValueBigIntPowersOfFive[precision];
        }
        if (precision == 40) {
            return ValueFivePower40;
        }
        int startPrecision = precision;
        EInteger bigpow = ValuePowerOfFiveCache.GetCachedPowerInt(precision);
        if (bigpow != null) {
            return bigpow;
        }
        EInteger origPrecision = EInteger.FromInt32(precision);
        if (precision <= 54) {
            if ((precision & 1) == 0) {
                EInteger ret = ValueBigIntPowersOfFive[precision >> 1];
                ret = ret.Multiply(ret);
                ValuePowerOfFiveCache.AddPower(origPrecision, ret);
                return ret;
            }
            EInteger ret = ValueBigIntPowersOfFive[27];
            bigpow = ValueBigIntPowersOfFive[precision - 27];
            ret = ret.Multiply(bigpow);
            ValuePowerOfFiveCache.AddPower(origPrecision, ret);
            return ret;
        }
        if (precision <= 94) {
            EInteger ret = ValueFivePower40;
            bigpow = NumberUtility.FindPowerOfFive(precision - 40);
            ret = ret.Multiply(bigpow);
            ValuePowerOfFiveCache.AddPower(origPrecision, ret);
            return ret;
        }
        int powprec = 64;
        EInteger ret = NumberUtility.FindPowerOfFive(precision & 0x3F);
        precision >>= 6;
        while (precision > 0) {
            if ((precision & 1) == 1) {
                EInteger otherPower = ValuePowerOfFiveCache.GetCachedPowerInt(powprec);
                if (otherPower == null) {
                    EInteger prevPower = NumberUtility.FindPowerOfFive(powprec >> 1);
                    otherPower = prevPower.Multiply(prevPower);
                    ValuePowerOfFiveCache.AddPower(powprec, otherPower);
                }
                ret = ret.Multiply(otherPower);
            }
            powprec <<= 1;
            precision >>= 1;
        }
        return ret;
    }

    static EInteger FindPowerOfTen(int precision) {
        if (precision < 0) {
            return EInteger.FromInt32(0);
        }
        if (precision <= 18) {
            return ValueBigIntPowersOfTen[precision];
        }
        int startPrecision = precision;
        EInteger bigpow = ValuePowerOfTenCache.GetCachedPowerInt(precision);
        if (bigpow != null) {
            return bigpow;
        }
        if (precision <= 27) {
            EInteger ret = ValueBigIntPowersOfFive[precision];
            ret = ret.ShiftLeft(precision);
            ValuePowerOfTenCache.AddPower(precision, ret);
            return ret;
        }
        if (precision <= 36) {
            if ((precision & 1) == 0) {
                EInteger ret = ValueBigIntPowersOfTen[precision >> 1];
                ret = ret.Multiply(ret);
                ValuePowerOfTenCache.AddPower(precision, ret);
                return ret;
            }
            EInteger ret = ValueBigIntPowersOfTen[18];
            bigpow = ValueBigIntPowersOfTen[precision - 18];
            ret = ret.Multiply(bigpow);
            ValuePowerOfTenCache.AddPower(precision, ret);
            return ret;
        }
        return NumberUtility.FindPowerOfFive(precision).ShiftLeft(precision);
    }

    public static int BitLength(long mantlong) {
        if (mantlong == 0L) {
            return 1;
        }
        int wcextra = 64;
        if (mantlong >> 32 == 0L) {
            mantlong <<= 32;
            wcextra -= 32;
        }
        if (mantlong >> 48 == 0L) {
            mantlong <<= 16;
            wcextra -= 16;
        }
        if (mantlong >> 56 == 0L) {
            mantlong <<= 8;
            wcextra -= 8;
        }
        if (mantlong >> 60 == 0L) {
            mantlong <<= 4;
            wcextra -= 4;
        }
        if (mantlong >> 62 == 0L) {
            mantlong <<= 2;
            wcextra -= 2;
        }
        return mantlong >> 63 == 0L ? wcextra - 1 : wcextra;
    }

    public static <THelper> THelper PreRound(THelper val, EContext ctx, IRadixMath<THelper> wrapper) {
        if (ctx == null || !ctx.getHasMaxPrecision()) {
            return val;
        }
        IRadixMathHelper<THelper> helper = wrapper.GetHelper();
        int thisFlags = helper.GetFlags(val);
        if ((thisFlags & 0xE) != 0) {
            return val;
        }
        FastInteger fastPrecision = FastInteger.FromBig(ctx.getPrecision());
        EInteger mant = helper.GetMantissa(val).Abs();
        FastInteger[] digitBounds = NumberUtility.DigitLengthBounds(helper, mant);
        if (digitBounds[1].compareTo(fastPrecision) <= 0) {
            return val;
        }
        EContext ctx2 = ctx;
        if (digitBounds[0].compareTo(fastPrecision) <= 0) {
            FastInteger digits = helper.GetDigitLength(mant);
            ctx2 = ctx.WithBlankFlags().WithTraps(0);
            if (digits.compareTo(fastPrecision) <= 0) {
                return val;
            }
        }
        val = wrapper.RoundToPrecision(val, ctx2);
        if ((ctx2.getFlags() & 1) != 0 && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 0x103);
        }
        if ((ctx2.getFlags() & 2) != 0 && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 2);
        }
        if ((ctx2.getFlags() & 0x10) != 0) {
            boolean neg;
            boolean bl = neg = (thisFlags & 1) != 0;
            if (ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | 0x100);
                ctx.setFlags(ctx.getFlags() | 0x13);
            }
        }
        return val;
    }

    public static int DecimalDigitLength(int v2) {
        if (v2 < 100000) {
            return v2 >= 10000 ? 5 : (v2 >= 1000 ? 4 : (v2 >= 100 ? 3 : (v2 >= 10 ? 2 : 1)));
        }
        return v2 >= 1000000000 ? 10 : (v2 >= 100000000 ? 9 : (v2 >= 10000000 ? 8 : (v2 >= 1000000 ? 7 : 6)));
    }

    public static int DecimalDigitLength(long value) {
        if (value >= 1000000000L) {
            return value >= 1000000000000000000L ? 19 : (value >= 100000000000000000L ? 18 : (value >= 10000000000000000L ? 17 : (value >= 1000000000000000L ? 16 : (value >= 100000000000000L ? 15 : (value >= 10000000000000L ? 14 : (value >= 1000000000000L ? 13 : (value >= 100000000000L ? 12 : (value >= 10000000000L ? 11 : (value >= 1000000000L ? 10 : 9)))))))));
        }
        int v2 = (int)value;
        return v2 >= 100000000 ? 9 : (v2 >= 10000000 ? 8 : (v2 >= 1000000 ? 7 : (v2 >= 100000 ? 6 : (v2 >= 10000 ? 5 : (v2 >= 1000 ? 4 : (v2 >= 100 ? 3 : (v2 >= 10 ? 2 : 1)))))));
    }

    public static EInteger[] DecimalDigitLengthBoundsAsEI(EInteger ei) {
        long longBitLength = ei.GetUnsignedBitLengthAsInt64();
        if (longBitLength < 33L) {
            EInteger eintcnt = EInteger.FromInt32((int)ei.GetDigitCountAsInt64());
            return new EInteger[]{eintcnt, eintcnt};
        }
        if (longBitLength <= 2135L) {
            int bitlen = (int)longBitLength;
            int minDigits = 1 + ((bitlen - 1) * 631305 >> 21);
            int maxDigits = 1 + (bitlen * 631305 >> 21);
            if (minDigits == maxDigits) {
                EInteger eintcnt = EInteger.FromInt32(minDigits);
                return new EInteger[]{eintcnt, eintcnt};
            }
            return new EInteger[]{EInteger.FromInt32(minDigits), EInteger.FromInt32(maxDigits)};
        }
        if (longBitLength <= 6432162L) {
            int bitlen = (int)longBitLength;
            int minDigits = 1 + (int)((long)(bitlen - 1) * 661971961083L >> 41);
            int maxDigits = 1 + (int)((long)bitlen * 661971961083L >> 41);
            if (minDigits == maxDigits) {
                EInteger eintcnt = EInteger.FromInt32(minDigits);
                return new EInteger[]{eintcnt, eintcnt};
            }
            return new EInteger[]{EInteger.FromInt32(minDigits), EInteger.FromInt32(maxDigits)};
        }
        FastInteger[] fis = NumberUtility.DecimalDigitLengthBounds(ei);
        return new EInteger[]{fis[0].ToEInteger(), fis[1].ToEInteger()};
    }

    public static FastInteger[] DecimalDigitLengthBounds(EInteger ei) {
        long longBitLength = ei.GetUnsignedBitLengthAsInt64();
        if (longBitLength < 33L) {
            FastInteger fi = new FastInteger((int)ei.GetDigitCountAsInt64());
            return new FastInteger[]{fi, fi};
        }
        if (longBitLength <= 2135L) {
            int bitlen = (int)longBitLength;
            int minDigits = 1 + ((bitlen - 1) * 631305 >> 21);
            int maxDigits = 1 + (bitlen * 631305 >> 21);
            if (minDigits == maxDigits) {
                FastInteger fi = new FastInteger(minDigits);
                return new FastInteger[]{fi, fi};
            }
            return new FastInteger[]{new FastInteger(minDigits), new FastInteger(maxDigits)};
        }
        if (longBitLength <= 6432162L) {
            int bitlen = (int)longBitLength;
            int minDigits = 1 + (int)((long)(bitlen - 1) * 661971961083L >> 41);
            int maxDigits = 1 + (int)((long)bitlen * 661971961083L >> 41);
            if (minDigits == maxDigits) {
                FastInteger fi = new FastInteger(minDigits);
                return new FastInteger[]{fi, fi};
            }
            return new FastInteger[]{new FastInteger(minDigits), new FastInteger(maxDigits)};
        }
        EInteger bigBitLength = ei.GetUnsignedBitLengthAsEInteger();
        EInteger lowerBound = bigBitLength.Multiply(100).Divide(335);
        EInteger upperBound = bigBitLength.Divide(3);
        return new FastInteger[]{FastInteger.FromBig(lowerBound), FastInteger.FromBig(upperBound)};
    }

    public static <THelper> FastInteger[] DigitLengthBounds(IRadixMathHelper<THelper> helper, EInteger ei) {
        int radix = helper.GetRadix();
        if (radix == 2) {
            FastInteger fi = FastInteger.FromBig(ei.GetUnsignedBitLengthAsEInteger());
            return new FastInteger[]{fi, fi};
        }
        if (radix == 10) {
            return NumberUtility.DecimalDigitLengthBounds(ei);
        }
        FastInteger fi = helper.GetDigitLength(ei);
        return new FastInteger[]{fi, fi};
    }

    private static FastIntegerFixed FastPathDigitLength(FastIntegerFixed fei, int radix) {
        if (fei.CanFitInInt32()) {
            int ifei = fei.ToInt32();
            if (ifei != Integer.MIN_VALUE) {
                if (radix == 2) {
                    return FastIntegerFixed.FromInt32(NumberUtility.BitLength(Math.abs(ifei)));
                }
                if (radix == 10) {
                    return FastIntegerFixed.FromInt32(NumberUtility.DecimalDigitLength(Math.abs(ifei)));
                }
            }
        } else if (radix == 2) {
            long i64 = fei.ToEInteger().GetUnsignedBitLengthAsInt64();
            if (i64 != Long.MAX_VALUE) {
                return FastIntegerFixed.FromInt64(i64);
            }
        } else if (radix == 10) {
            int maxDigits;
            int bitlen;
            int minDigits;
            EInteger ei = fei.ToEInteger();
            long i64 = ei.GetUnsignedBitLengthAsInt64();
            if (i64 < 33L) {
                return FastIntegerFixed.FromInt32((int)ei.GetDigitCountAsInt64());
            }
            if (i64 <= 2135L) {
                int bitlen2 = (int)i64;
                int minDigits2 = 1 + ((bitlen2 - 1) * 631305 >> 21);
                int maxDigits2 = 1 + (bitlen2 * 631305 >> 21);
                if (minDigits2 == maxDigits2) {
                    return FastIntegerFixed.FromInt32(minDigits2);
                }
            } else if (i64 <= 6432162L && (minDigits = 1 + (int)((long)((bitlen = (int)i64) - 1) * 661971961083L >> 41)) == (maxDigits = 1 + (int)((long)bitlen * 661971961083L >> 41))) {
                return FastIntegerFixed.FromInt32(minDigits);
            }
        }
        return null;
    }

    public static <THelper> FastIntegerFixed[] DigitLengthBoundsFixed(IRadixMathHelper<THelper> helper, FastIntegerFixed fei) {
        int radix = helper.GetRadix();
        FastIntegerFixed fastpath = NumberUtility.FastPathDigitLength(fei, radix);
        if (fastpath != null) {
            return new FastIntegerFixed[]{fastpath, fastpath};
        }
        if (radix == 10) {
            EInteger[] fi = NumberUtility.DecimalDigitLengthBoundsAsEI(fei.ToEInteger());
            return new FastIntegerFixed[]{FastIntegerFixed.FromBig(fi[0]), FastIntegerFixed.FromBig(fi[1])};
        }
        FastInteger fi = helper.GetDigitLength(fei.ToEInteger());
        FastIntegerFixed fif = FastIntegerFixed.FromFastInteger(fi);
        return new FastIntegerFixed[]{fif, fif};
    }

    public static <THelper> FastIntegerFixed DigitLengthFixed(IRadixMathHelper<THelper> helper, FastIntegerFixed fei) {
        FastIntegerFixed fastpath = NumberUtility.FastPathDigitLength(fei, helper.GetRadix());
        if (fastpath != null) {
            return fastpath;
        }
        FastInteger fi = helper.GetDigitLength(fei.ToEInteger());
        FastIntegerFixed fif = FastIntegerFixed.FromFastInteger(fi);
        return fif;
    }

    public static <THelper> FastInteger DigitLengthUpperBound(IRadixMathHelper<THelper> helper, EInteger ei) {
        return NumberUtility.DigitLengthBounds(helper, ei)[1];
    }

    public static EInteger ReduceTrailingZeros(EInteger bigmant, FastInteger exponentMutable, int radix, FastInteger digits, FastInteger precision, FastInteger idealExp) {
        if (bigmant.isZero()) {
            exponentMutable.SetInt(0);
            return bigmant;
        }
        if (radix == 2) {
            if (!bigmant.isEven()) {
                return bigmant;
            }
            long lowbit = bigmant.GetLowBitAsInt64();
            if (lowbit != Long.MAX_VALUE) {
                EInteger tmp;
                if (precision != null && digits.compareTo(precision) >= 0 && (tmp = digits.ToEInteger().Subtract(precision.ToEInteger())).compareTo(EInteger.FromInt64(lowbit)) < 0) {
                    lowbit = tmp.ToInt64Checked();
                }
                if (idealExp != null && exponentMutable.compareTo(idealExp) <= 0 && (tmp = idealExp.ToEInteger().Subtract(exponentMutable.ToEInteger())).compareTo(EInteger.FromInt64(lowbit)) < 0) {
                    lowbit = tmp.ToInt64Checked();
                }
                EInteger eInteger = bigmant = lowbit <= Integer.MAX_VALUE ? bigmant.ShiftRight((int)lowbit) : bigmant.ShiftRight(EInteger.FromInt64(lowbit));
                if (digits != null) {
                    digits.SubtractInt64(lowbit);
                }
                if (exponentMutable != null) {
                    exponentMutable.AddInt64(lowbit);
                }
                return bigmant;
            }
        }
        EInteger bigradix = EInteger.FromInt32(radix);
        FastInteger bitsToShift = new FastInteger(0);
        while (!(bigmant.isZero() || precision != null && digits.compareTo(precision) == 0 || idealExp != null && exponentMutable.compareTo(idealExp) == 0)) {
            EInteger[] divrem = bigmant.DivRem(bigradix);
            EInteger bigquo = divrem[0];
            EInteger bigrem = divrem[1];
            if (!bigrem.isZero()) break;
            bigmant = bigquo;
            exponentMutable.Increment();
            if (digits == null) continue;
            digits.Decrement();
        }
        return bigmant;
    }

    private static final class PowerCache {
        private static final int MaxSize = 128;
        private final EInteger[] outputs = new EInteger[128];
        private final EInteger[] inputs = new EInteger[128];
        private final int[] inputsInts = new int[128];
        private int size;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EInteger[] FindCachedPowerOrSmaller(EInteger bi) {
            EInteger[] ret = null;
            EInteger minValue = null;
            if (bi.CanFitInInt32()) {
                return this.FindCachedPowerIntOrSmaller(bi.ToInt32Checked());
            }
            EInteger[] eIntegerArray = this.outputs;
            synchronized (this.outputs) {
                for (int i = 0; i < this.size; ++i) {
                    if (this.inputs[i].compareTo(bi) > 0 || minValue != null && this.inputs[i].compareTo(minValue) < 0) continue;
                    ret = new EInteger[]{this.inputs[i], this.outputs[i]};
                    minValue = this.inputs[i];
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EInteger[] FindCachedPowerIntOrSmaller(int precision) {
            EInteger[] ret = null;
            int integerMinValue = -1;
            EInteger[] eIntegerArray = this.outputs;
            synchronized (this.outputs) {
                for (int i = 0; i < this.size; ++i) {
                    if (this.inputsInts[i] < 0 || this.inputsInts[i] > precision || integerMinValue != -1 && this.inputsInts[i] < integerMinValue) continue;
                    ret = new EInteger[]{this.inputs[i], this.outputs[i]};
                    integerMinValue = this.inputsInts[i];
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return ret;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EInteger GetCachedPower(EInteger bi) {
            if (bi.CanFitInInt32()) {
                return this.GetCachedPowerInt(bi.ToInt32Checked());
            }
            EInteger[] eIntegerArray = this.outputs;
            synchronized (this.outputs) {
                for (int i = 0; i < this.size; ++i) {
                    if (!bi.equals(this.inputs[i])) continue;
                    if (i != 0) {
                        EInteger tmp = this.inputs[i];
                        this.inputs[i] = this.inputs[0];
                        this.inputs[0] = tmp;
                        int tmpi = this.inputsInts[i];
                        this.inputsInts[i] = this.inputsInts[0];
                        this.inputsInts[0] = tmpi;
                        tmp = this.outputs[i];
                        this.outputs[i] = this.outputs[0];
                        this.outputs[0] = tmp;
                        if (i != 1) {
                            tmp = this.inputs[i];
                            this.inputs[i] = this.inputs[1];
                            this.inputs[1] = tmp;
                            tmpi = this.inputsInts[i];
                            this.inputsInts[i] = this.inputsInts[1];
                            this.inputsInts[1] = tmpi;
                            tmp = this.outputs[i];
                            this.outputs[i] = this.outputs[1];
                            this.outputs[1] = tmp;
                        }
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.outputs[0];
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EInteger GetCachedPowerInt(int ibi) {
            EInteger[] eIntegerArray = this.outputs;
            synchronized (this.outputs) {
                if (ibi > 0 && this.size < 64) {
                    for (int i = 0; i < this.size; ++i) {
                        if (this.inputsInts[i] != ibi) continue;
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return this.outputs[i];
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return null;
                }
                for (int i = 0; i < this.size; ++i) {
                    if (this.inputsInts[i] < 0 || this.inputsInts[i] != ibi) continue;
                    if (i != 0) {
                        EInteger tmp = this.inputs[i];
                        this.inputs[i] = this.inputs[0];
                        this.inputs[0] = tmp;
                        int tmpi = this.inputsInts[i];
                        this.inputsInts[i] = this.inputsInts[0];
                        this.inputsInts[0] = tmpi;
                        tmp = this.outputs[i];
                        this.outputs[i] = this.outputs[0];
                        this.outputs[0] = tmp;
                        if (i != 1) {
                            tmp = this.inputs[i];
                            this.inputs[i] = this.inputs[1];
                            this.inputs[1] = tmp;
                            tmpi = this.inputsInts[i];
                            this.inputsInts[i] = this.inputsInts[1];
                            this.inputsInts[1] = tmpi;
                            tmp = this.outputs[i];
                            this.outputs[i] = this.outputs[1];
                            this.outputs[1] = tmp;
                        }
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return this.outputs[0];
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
        }

        public void AddPower(int input, EInteger output) {
            this.AddPower(EInteger.FromInt32(input), output);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void AddPower(EInteger input, EInteger output) {
            EInteger[] eIntegerArray = this.outputs;
            synchronized (this.outputs) {
                if (this.size < 128) {
                    for (int i = this.size; i > 0; --i) {
                        this.inputs[i] = this.inputs[i - 1];
                        this.inputsInts[i] = this.inputsInts[i - 1];
                        this.outputs[i] = this.outputs[i - 1];
                    }
                    this.inputs[0] = input;
                    this.inputsInts[0] = input.CanFitInInt32() ? input.ToInt32Checked() : -1;
                    this.outputs[0] = output;
                    ++this.size;
                } else {
                    for (int i = 127; i > 0; --i) {
                        this.inputs[i] = this.inputs[i - 1];
                        this.inputsInts[i] = this.inputsInts[i - 1];
                        this.outputs[i] = this.outputs[i - 1];
                    }
                    this.inputs[0] = input;
                    this.inputsInts[0] = input.CanFitInInt32() ? input.ToInt32Checked() : -1;
                    this.outputs[0] = output;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }
}

