/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERounding;
import com.upokecenter.numbers.FastInteger;
import com.upokecenter.numbers.IRadixMath;
import com.upokecenter.numbers.IRadixMathHelper;
import com.upokecenter.numbers.NumberUtility;

final class SimpleRadixMath<T>
implements IRadixMath<T> {
    private final IRadixMath<T> wrapper;

    public SimpleRadixMath(IRadixMath<T> wrapper) {
        this.wrapper = wrapper;
    }

    private static EContext GetContextWithFlags(EContext ctx) {
        return ctx == null ? ctx : ctx.WithBlankFlags();
    }

    private T SignalInvalid(EContext ctx) {
        if (this.GetHelper().GetArithmeticSupport() == 0) {
            throw new ArithmeticException("Invalid operation");
        }
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 0x40);
        }
        return this.GetHelper().CreateNewWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 4);
    }

    private T PostProcess(T thisValue, EContext ctxDest, EContext ctxSrc) {
        return this.PostProcessEx(thisValue, ctxDest, ctxSrc, false, false);
    }

    private T PostProcessAfterDivision(T thisValue, EContext ctxDest, EContext ctxSrc) {
        return this.PostProcessEx(thisValue, ctxDest, ctxSrc, true, false);
    }

    private T PostProcessAfterQuantize(T thisValue, EContext ctxDest, EContext ctxSrc) {
        return this.PostProcessEx(thisValue, ctxDest, ctxSrc, false, true);
    }

    private T PostProcessEx(T thisValue, EContext ctxDest, EContext ctxSrc, boolean afterDivision, boolean afterQuantize) {
        int thisFlags = this.GetHelper().GetFlags(thisValue);
        if (ctxDest != null && ctxSrc != null && ctxDest.getHasFlags()) {
            if (!ctxSrc.getClampNormalExponents()) {
                ctxSrc.setFlags(ctxSrc.getFlags() & 0xFFFFFFDF);
            }
            ctxDest.setFlags(ctxDest.getFlags() | ctxSrc.getFlags());
            if ((ctxSrc.getFlags() & 4) != 0) {
                ctxDest.setFlags(ctxDest.getFlags() | 0xF);
            }
        }
        if ((thisFlags & 0xE) != 0) {
            return ctxDest.getFlags() == 0 ? this.SignalInvalid(ctxDest) : thisValue;
        }
        EInteger mant = this.GetHelper().GetMantissa(thisValue).Abs();
        if (mant.isZero()) {
            return afterQuantize ? this.GetHelper().CreateNewWithFlags(mant, this.GetHelper().GetExponent(thisValue), 0) : this.wrapper.RoundToPrecision(this.GetHelper().ValueOf(0), ctxDest);
        }
        if (afterQuantize) {
            return thisValue;
        }
        EInteger exp = this.GetHelper().GetExponent(thisValue);
        if (exp.signum() > 0) {
            FastInteger fastExp = FastInteger.FromBig(exp);
            if (ctxDest == null || !ctxDest.getHasMaxPrecision()) {
                mant = this.GetHelper().MultiplyByRadixPower(mant, fastExp);
                return this.GetHelper().CreateNewWithFlags(mant, EInteger.FromInt32(0), thisFlags);
            }
            if (!ctxDest.ExponentWithinRange(exp)) {
                return thisValue;
            }
            FastInteger prec = FastInteger.FromBig(ctxDest.getPrecision());
            FastInteger digits = this.GetHelper().GetDigitLength(mant);
            prec.Subtract(digits);
            if (prec.signum() > 0 && prec.compareTo(fastExp) >= 0) {
                mant = this.GetHelper().MultiplyByRadixPower(mant, fastExp);
                return this.GetHelper().CreateNewWithFlags(mant, EInteger.FromInt32(0), thisFlags);
            }
            if (afterDivision) {
                int radix = this.GetHelper().GetRadix();
                mant = NumberUtility.ReduceTrailingZeros(mant, fastExp, radix, null, null, null);
                thisValue = this.GetHelper().CreateNewWithFlags(mant, fastExp.AsEInteger(), thisFlags);
            }
        } else if (afterDivision && exp.signum() < 0) {
            FastInteger fastExp = FastInteger.FromBig(exp);
            int radix = this.GetHelper().GetRadix();
            mant = NumberUtility.ReduceTrailingZeros(mant, fastExp, radix, null, null, new FastInteger(0));
            thisValue = this.GetHelper().CreateNewWithFlags(mant, fastExp.AsEInteger(), thisFlags);
        }
        return thisValue;
    }

    private T ReturnQuietNaN(T thisValue, EContext ctx) {
        EInteger limit;
        EInteger mant = this.GetHelper().GetMantissa(thisValue).Abs();
        boolean mantChanged = false;
        if (!mant.isZero() && ctx != null && ctx.getHasMaxPrecision() && mant.compareTo(limit = this.GetHelper().MultiplyByRadixPower(EInteger.FromInt32(1), FastInteger.FromBig(ctx.getPrecision()))) >= 0) {
            mant = mant.Remainder(limit);
            mantChanged = true;
        }
        int flags = this.GetHelper().GetFlags(thisValue);
        if (!mantChanged && (flags & 4) != 0) {
            return thisValue;
        }
        flags &= 1;
        return this.GetHelper().CreateNewWithFlags(mant, EInteger.FromInt32(0), flags |= 4);
    }

    private T HandleNotANumber(T thisValue, T other, EContext ctx) {
        int thisFlags = this.GetHelper().GetFlags(thisValue);
        int otherFlags = this.GetHelper().GetFlags(other);
        if ((thisFlags & 8) != 0) {
            return this.SignalingNaNInvalid(thisValue, ctx);
        }
        if ((otherFlags & 8) != 0) {
            return this.SignalingNaNInvalid(other, ctx);
        }
        return (T)((thisFlags & 4) != 0 ? this.ReturnQuietNaN(thisValue, ctx) : ((otherFlags & 4) != 0 ? this.ReturnQuietNaN(other, ctx) : null));
    }

    private T CheckNotANumber3(T thisValue, T other, T other2, EContext ctx) {
        int thisFlags = this.GetHelper().GetFlags(thisValue);
        int otherFlags = this.GetHelper().GetFlags(other);
        int other2Flags = this.GetHelper().GetFlags(other2);
        if ((thisFlags & 8) != 0) {
            return this.SignalingNaNInvalid(thisValue, ctx);
        }
        if ((otherFlags & 8) != 0) {
            return this.SignalingNaNInvalid(other, ctx);
        }
        if ((other2Flags & 8) != 0) {
            return this.SignalingNaNInvalid(other, ctx);
        }
        return (T)((thisFlags & 4) != 0 ? this.ReturnQuietNaN(thisValue, ctx) : ((otherFlags & 4) != 0 ? this.ReturnQuietNaN(other, ctx) : ((other2Flags & 4) != 0 ? this.ReturnQuietNaN(other, ctx) : null)));
    }

    private T SignalingNaNInvalid(T value, EContext ctx) {
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 0x40);
        }
        return this.ReturnQuietNaN(value, ctx);
    }

    private T CheckNotANumber1(T val, EContext ctx) {
        return this.HandleNotANumber(val, val, ctx);
    }

    private T CheckNotANumber2(T val, T val2, EContext ctx) {
        return this.HandleNotANumber(val, val2, ctx);
    }

    private T RoundBeforeOp(T val, EContext ctx) {
        if (ctx == null || !ctx.getHasMaxPrecision()) {
            return val;
        }
        int thisFlags = this.GetHelper().GetFlags(val);
        if ((thisFlags & 0xE) != 0) {
            return val;
        }
        FastInteger fastPrecision = FastInteger.FromBig(ctx.getPrecision());
        EInteger mant = this.GetHelper().GetMantissa(val).Abs();
        FastInteger digits = this.GetHelper().GetDigitLength(mant);
        EContext ctx2 = ctx.WithBlankFlags().WithTraps(0);
        if (digits.compareTo(fastPrecision) <= 0) {
            return val;
        }
        val = this.wrapper.RoundToPrecision(val, ctx2);
        if ((ctx2.getFlags() & 1) != 0 && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 0x103);
        }
        if ((ctx2.getFlags() & 2) != 0 && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 2);
        }
        if ((ctx2.getFlags() & 4) != 0) {
            // empty if block
        }
        if ((ctx2.getFlags() & 8) != 0) {
            // empty if block
        }
        if ((ctx2.getFlags() & 0x10) != 0) {
            boolean neg = (thisFlags & 1) != 0;
            ctx.setFlags(ctx.getFlags() | 0x100);
            return this.SignalOverflow2(ctx, neg);
        }
        return val;
    }

    @Override
    public T DivideToIntegerNaturalScale(T thisValue, T divisor, EContext ctx) {
        T ret = this.CheckNotANumber2(thisValue, divisor, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        divisor = this.RoundBeforeOp(divisor, ctx2);
        thisValue = this.wrapper.DivideToIntegerNaturalScale(thisValue, divisor, ctx2);
        return this.PostProcessAfterDivision(thisValue, ctx, ctx2);
    }

    @Override
    public T DivideToIntegerZeroScale(T thisValue, T divisor, EContext ctx) {
        T ret = this.CheckNotANumber2(thisValue, divisor, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        divisor = this.RoundBeforeOp(divisor, ctx2);
        thisValue = this.wrapper.DivideToIntegerZeroScale(thisValue, divisor, ctx2);
        return this.PostProcessAfterDivision(thisValue, ctx, ctx2);
    }

    @Override
    public T Abs(T value, EContext ctx) {
        T ret = this.CheckNotANumber1(value, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        value = this.RoundBeforeOp(value, ctx2);
        value = this.wrapper.Abs(value, ctx2);
        return this.PostProcess(value, ctx, ctx2);
    }

    @Override
    public T Negate(T value, EContext ctx) {
        T ret = this.CheckNotANumber1(value, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        value = this.RoundBeforeOp(value, ctx2);
        value = this.wrapper.Negate(value, ctx2);
        return this.PostProcess(value, ctx, ctx2);
    }

    @Override
    public T Remainder(T thisValue, T divisor, EContext ctx, boolean roundAfterDivide) {
        T ret = this.CheckNotANumber2(thisValue, divisor, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        divisor = this.RoundBeforeOp(divisor, ctx2);
        thisValue = this.wrapper.Remainder(thisValue, divisor, ctx2, roundAfterDivide);
        return this.PostProcess(thisValue, ctx, ctx2);
    }

    @Override
    public T RemainderNear(T thisValue, T divisor, EContext ctx) {
        T ret = this.CheckNotANumber2(thisValue, divisor, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        divisor = this.RoundBeforeOp(divisor, ctx2);
        thisValue = this.wrapper.RemainderNear(thisValue, divisor, ctx2);
        return this.PostProcess(thisValue, ctx, ctx2);
    }

    @Override
    public T Pi(EContext ctx) {
        return this.wrapper.Pi(ctx);
    }

    private T SignalOverflow2(EContext pc, boolean neg) {
        if (pc != null) {
            ERounding roundingOnOverflow = pc.getRounding();
            if (pc.getHasFlags()) {
                pc.setFlags(pc.getFlags() | 0x13);
            }
            if (pc.getHasMaxPrecision() && pc.getHasExponentRange() && (roundingOnOverflow == ERounding.Down || roundingOnOverflow == ERounding.ZeroFiveUp || roundingOnOverflow == ERounding.OddOrZeroFiveUp || roundingOnOverflow == ERounding.Odd || roundingOnOverflow == ERounding.Ceiling && neg || roundingOnOverflow == ERounding.Floor && !neg)) {
                EInteger overflowMant = EInteger.FromInt32(0);
                FastInteger fastPrecision = FastInteger.FromBig(pc.getPrecision());
                overflowMant = this.GetHelper().MultiplyByRadixPower(EInteger.FromInt32(1), fastPrecision);
                overflowMant = overflowMant.Subtract(EInteger.FromInt32(1));
                FastInteger clamp = FastInteger.FromBig(pc.getEMax()).Increment().Subtract(fastPrecision);
                return this.GetHelper().CreateNewWithFlags(overflowMant, clamp.AsEInteger(), neg ? 1 : 0);
            }
        }
        int flagneg = neg ? 1 : 0;
        return this.GetHelper().GetArithmeticSupport() == 0 ? null : (T)this.GetHelper().CreateNewWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), flagneg | 2);
    }

    @Override
    public T Power(T thisValue, T pow, EContext ctx) {
        T ret = this.CheckNotANumber2(thisValue, pow, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        pow = this.RoundBeforeOp(pow, ctx2);
        int powSign = this.GetHelper().GetSign(pow);
        thisValue = powSign == 0 && this.GetHelper().GetSign(thisValue) == 0 ? this.wrapper.RoundToPrecision(this.GetHelper().ValueOf(1), ctx2) : this.wrapper.Power(thisValue, pow, ctx2);
        thisValue = this.PostProcessAfterDivision(thisValue, ctx, ctx2);
        return thisValue;
    }

    @Override
    public T Log10(T thisValue, EContext ctx) {
        T ret = this.CheckNotANumber1(thisValue, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        thisValue = this.wrapper.Log10(thisValue, ctx2);
        return this.PostProcess(thisValue, ctx, ctx2);
    }

    @Override
    public T Ln(T thisValue, EContext ctx) {
        T ret = this.CheckNotANumber1(thisValue, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        thisValue = this.wrapper.Ln(thisValue, ctx2);
        return this.PostProcess(thisValue, ctx, ctx2);
    }

    @Override
    public IRadixMathHelper<T> GetHelper() {
        return this.wrapper.GetHelper();
    }

    @Override
    public T Exp(T thisValue, EContext ctx) {
        T ret = this.CheckNotANumber1(thisValue, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        thisValue = this.wrapper.Exp(thisValue, ctx2);
        return this.PostProcess(thisValue, ctx, ctx2);
    }

    @Override
    public T SquareRoot(T thisValue, EContext ctx) {
        T ret = this.CheckNotANumber1(thisValue, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        thisValue = this.wrapper.SquareRoot(thisValue, ctx2);
        return this.PostProcess(thisValue, ctx, ctx2);
    }

    @Override
    public T NextMinus(T thisValue, EContext ctx) {
        T ret = this.CheckNotANumber1(thisValue, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        thisValue = this.wrapper.NextMinus(thisValue, ctx2);
        return this.PostProcess(thisValue, ctx, ctx2);
    }

    @Override
    public T NextToward(T thisValue, T otherValue, EContext ctx) {
        T ret = this.CheckNotANumber2(thisValue, otherValue, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        otherValue = this.RoundBeforeOp(otherValue, ctx2);
        thisValue = this.wrapper.NextToward(thisValue, otherValue, ctx2);
        return this.PostProcess(thisValue, ctx, ctx2);
    }

    @Override
    public T NextPlus(T thisValue, EContext ctx) {
        T ret = this.CheckNotANumber1(thisValue, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        thisValue = this.wrapper.NextPlus(thisValue, ctx2);
        return this.PostProcess(thisValue, ctx, ctx2);
    }

    @Override
    public T DivideToExponent(T thisValue, T divisor, EInteger desiredExponent, EContext ctx) {
        T ret = this.CheckNotANumber2(thisValue, divisor, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        divisor = this.RoundBeforeOp(divisor, ctx2);
        thisValue = this.wrapper.DivideToExponent(thisValue, divisor, desiredExponent, ctx2);
        return this.PostProcessAfterDivision(thisValue, ctx, ctx2);
    }

    @Override
    public T Divide(T thisValue, T divisor, EContext ctx) {
        T ret = this.CheckNotANumber2(thisValue, divisor, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        divisor = this.RoundBeforeOp(divisor, ctx2);
        thisValue = this.wrapper.Divide(thisValue, divisor, ctx2);
        return this.PostProcessAfterDivision(thisValue, ctx, ctx2);
    }

    @Override
    public T MinMagnitude(T a, T b, EContext ctx) {
        T ret = this.CheckNotANumber2(a, b, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        a = this.RoundBeforeOp(a, ctx2);
        b = this.RoundBeforeOp(b, ctx2);
        a = this.wrapper.MinMagnitude(a, b, ctx2);
        return this.PostProcess(a, ctx, ctx2);
    }

    @Override
    public T MaxMagnitude(T a, T b, EContext ctx) {
        T ret = this.CheckNotANumber2(a, b, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        a = this.RoundBeforeOp(a, ctx2);
        b = this.RoundBeforeOp(b, ctx2);
        a = this.wrapper.MaxMagnitude(a, b, ctx2);
        return this.PostProcess(a, ctx, ctx2);
    }

    @Override
    public T Max(T a, T b, EContext ctx) {
        T ret = this.CheckNotANumber2(a, b, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        a = this.compareTo(a = this.RoundBeforeOp(a, ctx2), b = this.RoundBeforeOp(b, ctx2)) >= 0 ? a : b;
        return this.PostProcess(a, ctx, ctx2);
    }

    @Override
    public T Min(T a, T b, EContext ctx) {
        T ret = this.CheckNotANumber2(a, b, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        a = this.compareTo(a = this.RoundBeforeOp(a, ctx2), b = this.RoundBeforeOp(b, ctx2)) <= 0 ? a : b;
        return this.PostProcess(a, ctx, ctx2);
    }

    @Override
    public T Multiply(T thisValue, T other, EContext ctx) {
        T ret = this.CheckNotANumber2(thisValue, other, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        other = this.RoundBeforeOp(other, ctx2);
        thisValue = this.wrapper.Multiply(thisValue, other, ctx2);
        return this.PostProcess(thisValue, ctx, ctx2);
    }

    @Override
    public T MultiplyAndAdd(T thisValue, T multiplicand, T augend, EContext ctx) {
        boolean zeroB;
        T ret = this.CheckNotANumber3(thisValue, multiplicand, augend, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        multiplicand = this.RoundBeforeOp(multiplicand, ctx2);
        augend = this.RoundBeforeOp(augend, ctx2);
        boolean zeroA = this.GetHelper().GetSign(thisValue) == 0 || this.GetHelper().GetSign(multiplicand) == 0;
        boolean bl = zeroB = this.GetHelper().GetSign(augend) == 0;
        if (zeroA) {
            thisValue = zeroB ? this.wrapper.RoundToPrecision(this.GetHelper().ValueOf(0), ctx2) : augend;
            thisValue = this.RoundToPrecision(thisValue, ctx2);
        } else {
            thisValue = !zeroB ? this.wrapper.MultiplyAndAdd(thisValue, multiplicand, augend, ctx2) : this.wrapper.Multiply(thisValue, multiplicand, ctx2);
        }
        return this.PostProcess(thisValue, ctx, ctx2);
    }

    @Override
    public T Plus(T thisValue, EContext ctx) {
        T ret = this.CheckNotANumber1(thisValue, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        thisValue = this.wrapper.Plus(thisValue, ctx2);
        return this.PostProcess(thisValue, ctx, ctx2);
    }

    @Override
    public T RoundToPrecision(T thisValue, EContext ctx) {
        T ret = this.CheckNotANumber1(thisValue, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        thisValue = this.wrapper.RoundToPrecision(thisValue, ctx2);
        return this.PostProcess(thisValue, ctx, ctx2);
    }

    @Override
    public T Quantize(T thisValue, T otherValue, EContext ctx) {
        T ret = this.CheckNotANumber1(thisValue, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        otherValue = this.RoundBeforeOp(otherValue, ctx2);
        EContext ctx3 = ctx2 == null ? null : ctx2.WithBlankFlags();
        this.wrapper.RoundToPrecision(otherValue, ctx3);
        if (ctx3 != null && (ctx3.getFlags() & 4) != 0) {
            return this.SignalInvalid(ctx);
        }
        thisValue = this.wrapper.Quantize(thisValue, otherValue, ctx2);
        return this.PostProcessAfterQuantize(thisValue, ctx, ctx2);
    }

    @Override
    public T RoundToExponentExact(T thisValue, EInteger expOther, EContext ctx) {
        T ret = this.CheckNotANumber1(thisValue, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        thisValue = this.wrapper.RoundToExponentExact(thisValue, expOther, ctx);
        return this.PostProcessAfterQuantize(thisValue, ctx, ctx2);
    }

    @Override
    public T RoundToExponentSimple(T thisValue, EInteger expOther, EContext ctx) {
        T ret = this.CheckNotANumber1(thisValue, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        thisValue = this.wrapper.RoundToExponentSimple(thisValue, expOther, ctx2);
        return this.PostProcessAfterQuantize(thisValue, ctx, ctx2);
    }

    @Override
    public T RoundToExponentNoRoundedFlag(T thisValue, EInteger exponent, EContext ctx) {
        T ret = this.CheckNotANumber1(thisValue, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        thisValue = this.wrapper.RoundToExponentNoRoundedFlag(thisValue, exponent, ctx);
        return this.PostProcessAfterQuantize(thisValue, ctx, ctx2);
    }

    @Override
    public T Reduce(T thisValue, EContext ctx) {
        T ret = this.CheckNotANumber1(thisValue, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        thisValue = this.wrapper.Reduce(thisValue, ctx);
        return this.PostProcessAfterQuantize(thisValue, ctx, ctx2);
    }

    @Override
    public T Add(T thisValue, T other, EContext ctx) {
        boolean zeroB;
        T ret = this.CheckNotANumber2(thisValue, other, ctx);
        if (ret != null) {
            return ret;
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.RoundBeforeOp(thisValue, ctx2);
        other = this.RoundBeforeOp(other, ctx2);
        boolean zeroA = this.GetHelper().GetSign(thisValue) == 0;
        boolean bl = zeroB = this.GetHelper().GetSign(other) == 0;
        if (zeroA) {
            thisValue = zeroB ? this.wrapper.RoundToPrecision(this.GetHelper().ValueOf(0), ctx2) : other;
            thisValue = this.RoundToPrecision(thisValue, ctx2);
        } else {
            thisValue = !zeroB ? this.wrapper.AddEx(thisValue, other, ctx2, true) : this.RoundToPrecision(thisValue, ctx2);
        }
        return this.PostProcess(thisValue, ctx, ctx2);
    }

    @Override
    public T AddEx(T thisValue, T other, EContext ctx, boolean roundToOperandPrecision) {
        return this.Add(thisValue, other, ctx);
    }

    @Override
    public T CompareToWithContext(T thisValue, T otherValue, boolean treatQuietNansAsSignaling, EContext ctx) {
        T ret = this.CheckNotANumber2(thisValue, otherValue, ctx);
        if (ret != null) {
            return ret;
        }
        thisValue = this.RoundBeforeOp(thisValue, ctx);
        otherValue = this.RoundBeforeOp(otherValue, ctx);
        return this.wrapper.CompareToWithContext(thisValue, otherValue, treatQuietNansAsSignaling, ctx);
    }

    @Override
    public int compareTo(T thisValue, T otherValue) {
        return this.wrapper.compareTo(thisValue, otherValue);
    }

    @Override
    public T SignalOverflow(EContext ctx, boolean neg) {
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        T thisValue = this.SignalOverflow2(ctx2, neg);
        return this.PostProcessAfterQuantize(thisValue, ctx, ctx2);
    }

    @Override
    public T RoundAfterConversion(T thisValue, EContext ctx) {
        T ret = this.CheckNotANumber1(thisValue, ctx);
        if (ret != null) {
            return ret;
        }
        if (this.GetHelper().GetSign(thisValue) == 0) {
            return this.wrapper.RoundToPrecision(this.GetHelper().ValueOf(0), ctx);
        }
        EContext ctx2 = SimpleRadixMath.GetContextWithFlags(ctx);
        thisValue = this.wrapper.RoundToPrecision(thisValue, ctx2);
        return this.PostProcessAfterQuantize(thisValue, ctx, ctx2);
    }
}

