/*
 * Decompiled with CFR 0.152.
 */
package rubikstudio.library;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.LinearInterpolator;
import androidx.core.graphics.ColorUtils;
import java.util.List;
import java.util.Random;
import rubikstudio.library.LuckyWheelUtils;
import rubikstudio.library.PielView;
import rubikstudio.library.model.LuckyItem;

public class PielView
extends View {
    private RectF mRange = new RectF();
    private int mRadius;
    private Paint mArcPaint;
    private Paint mBackgroundPaint;
    private TextPaint mTextPaint;
    private float mStartAngle = 0.0f;
    private int mCenter;
    private int mPadding;
    private int mTopTextPadding;
    private int mSecondaryTextPadding;
    private int mTopTextSize;
    private int mSecondaryTextSize;
    private int mRoundOfNumber = 4;
    private int mEdgeWidth = -1;
    private boolean isRunning = false;
    private int borderColor = 0;
    private int defaultBackgroundColor = 0;
    private Drawable drawableCenterImage;
    private int textColor = 0;
    private int predeterminedNumber = -1;
    float viewRotation;
    double fingerRotation;
    long downPressTime;
    long upPressTime;
    double[] newRotationStore = new double[3];
    private List<LuckyItem> mLuckyItemList;
    private PieRotateListener mPieRotateListener;
    private final float constantVelocity = 2.0f;
    public boolean touchEnabled = true;

    public PielView(Context context) {
        super(context);
    }

    public PielView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setPieRotateListener(PieRotateListener listener) {
        this.mPieRotateListener = listener;
    }

    private void init() {
        this.mArcPaint = new Paint();
        this.mArcPaint.setAntiAlias(true);
        this.mArcPaint.setDither(true);
        this.mTextPaint = new TextPaint();
        this.mTextPaint.setAntiAlias(true);
        if (this.textColor != 0) {
            this.mTextPaint.setColor(this.textColor);
        }
        this.mTextPaint.setTextSize(TypedValue.applyDimension((int)2, (float)14.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.mRange = new RectF((float)this.mPadding, (float)this.mPadding, (float)(this.mPadding + this.mRadius), (float)(this.mPadding + this.mRadius));
    }

    public int getLuckyItemListSize() {
        return this.mLuckyItemList.size();
    }

    public void setData(List<LuckyItem> luckyItemList) {
        this.mLuckyItemList = luckyItemList;
        this.invalidate();
    }

    public void setPieBackgroundColor(int color) {
        this.defaultBackgroundColor = color;
        this.invalidate();
    }

    public void setBorderColor(int color) {
        this.borderColor = color;
        this.invalidate();
    }

    public void setTopTextPadding(int padding) {
        this.mTopTextPadding = padding;
        this.invalidate();
    }

    public void setPieCenterImage(Drawable drawable) {
        this.drawableCenterImage = drawable;
        this.invalidate();
    }

    public void setTopTextSize(int size) {
        this.mTopTextSize = size;
        this.invalidate();
    }

    public void setSecondaryTextSizeSize(int size) {
        this.mSecondaryTextSize = size;
        this.invalidate();
    }

    public void setSecondaryTextPadding(int padding) {
        this.mSecondaryTextPadding = padding;
        if (this.mSecondaryTextPadding <= 0) {
            this.mSecondaryTextPadding = 1;
        }
        this.invalidate();
    }

    public void setBorderWidth(int width) {
        this.mEdgeWidth = width;
        this.invalidate();
    }

    public void setPieTextColor(int color) {
        this.textColor = color;
        this.invalidate();
    }

    private void drawPieBackgroundWithBitmap(Canvas canvas, Bitmap bitmap) {
        canvas.drawBitmap(bitmap, null, new Rect(this.mPadding / 2, this.mPadding / 2, this.getMeasuredWidth() - this.mPadding / 2, this.getMeasuredHeight() - this.mPadding / 2), null);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mLuckyItemList == null) {
            return;
        }
        this.drawBackgroundColor(canvas, this.defaultBackgroundColor);
        this.init();
        float tmpAngle = this.mStartAngle;
        float sweepAngle = 360.0f / (float)this.mLuckyItemList.size();
        for (int i = 0; i < this.mLuckyItemList.size(); ++i) {
            int sliceColor;
            if (this.mLuckyItemList.get((int)i).color != 0) {
                this.mArcPaint.setStyle(Paint.Style.FILL);
                this.mArcPaint.setColor(this.mLuckyItemList.get((int)i).color);
                canvas.drawArc(this.mRange, tmpAngle, sweepAngle, true, this.mArcPaint);
            }
            if (this.borderColor != 0 && this.mEdgeWidth > 0) {
                this.mArcPaint.setStyle(Paint.Style.STROKE);
                this.mArcPaint.setColor(this.borderColor);
                this.mArcPaint.setStrokeWidth((float)this.mEdgeWidth);
                canvas.drawArc(this.mRange, tmpAngle, sweepAngle, true, this.mArcPaint);
            }
            int n = sliceColor = this.mLuckyItemList.get((int)i).color != 0 ? this.mLuckyItemList.get((int)i).color : this.defaultBackgroundColor;
            if (!TextUtils.isEmpty((CharSequence)this.mLuckyItemList.get((int)i).topText)) {
                this.drawTopText(canvas, tmpAngle, sweepAngle, this.mLuckyItemList.get((int)i).topText, sliceColor);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mLuckyItemList.get((int)i).secondaryText)) {
                this.drawSecondaryText(canvas, tmpAngle, this.mLuckyItemList.get((int)i).secondaryText, sliceColor);
            }
            if (this.mLuckyItemList.get((int)i).icon != 0) {
                this.drawImage(canvas, tmpAngle, BitmapFactory.decodeResource((Resources)this.getResources(), (int)this.mLuckyItemList.get((int)i).icon));
            }
            tmpAngle += sweepAngle;
        }
        this.drawCenterImage(canvas, this.drawableCenterImage);
    }

    private void drawBackgroundColor(Canvas canvas, int color) {
        if (color == 0) {
            return;
        }
        this.mBackgroundPaint = new Paint();
        this.mBackgroundPaint.setColor(color);
        canvas.drawCircle((float)this.mCenter, (float)this.mCenter, (float)(this.mCenter - 5), this.mBackgroundPaint);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int width = Math.min(this.getMeasuredWidth(), this.getMeasuredHeight());
        this.mPadding = this.getPaddingLeft() == 0 ? 10 : this.getPaddingLeft();
        this.mRadius = width - this.mPadding * 2;
        this.mCenter = width / 2;
        this.setMeasuredDimension(width, width);
    }

    private void drawImage(Canvas canvas, float tmpAngle, Bitmap bitmap) {
        int imgWidth = this.mRadius / this.mLuckyItemList.size();
        float angle = (float)((double)(tmpAngle + 360.0f / (float)this.mLuckyItemList.size() / 2.0f) * Math.PI / 180.0);
        int x = (int)((double)this.mCenter + (double)(this.mRadius / 2 / 2) * Math.cos(angle));
        int y = (int)((double)this.mCenter + (double)(this.mRadius / 2 / 2) * Math.sin(angle));
        Rect rect = new Rect(x - imgWidth / 2, y - imgWidth / 2, x + imgWidth / 2, y + imgWidth / 2);
        canvas.drawBitmap(bitmap, null, rect, null);
    }

    private void drawCenterImage(Canvas canvas, Drawable drawable) {
        Bitmap bitmap = LuckyWheelUtils.drawableToBitmap(drawable);
        bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)drawable.getIntrinsicWidth(), (int)drawable.getIntrinsicHeight(), (boolean)false);
        canvas.drawBitmap(bitmap, (float)(this.getMeasuredWidth() / 2 - bitmap.getWidth() / 2), (float)(this.getMeasuredHeight() / 2 - bitmap.getHeight() / 2), null);
    }

    private boolean isColorDark(int color) {
        double compareValue;
        double colorValue = ColorUtils.calculateLuminance((int)color);
        return colorValue <= (compareValue = 0.3);
    }

    private void drawTopText(Canvas canvas, float tmpAngle, float sweepAngle, String mStr, int backgroundColor) {
        Path path = new Path();
        path.addArc(this.mRange, tmpAngle, sweepAngle);
        if (this.textColor == 0) {
            this.mTextPaint.setColor(this.isColorDark(backgroundColor) ? -1 : -16777216);
        }
        Typeface typeface = Typeface.create((Typeface)Typeface.SANS_SERIF, (int)0);
        this.mTextPaint.setTypeface(typeface);
        this.mTextPaint.setTextAlign(Paint.Align.LEFT);
        this.mTextPaint.setTextSize((float)this.mTopTextSize);
        float textWidth = this.mTextPaint.measureText(mStr);
        int hOffset = (int)((double)this.mRadius * Math.PI / (double)this.mLuckyItemList.size() / 2.0 - (double)(textWidth / 2.0f));
        int vOffset = this.mTopTextPadding;
        canvas.drawTextOnPath(mStr, path, (float)hOffset, (float)vOffset, (Paint)this.mTextPaint);
    }

    private void drawSecondaryText(Canvas canvas, float tmpAngle, String mStr, int backgroundColor) {
        Paint paint = new Paint();
        canvas.save();
        int arraySize = this.mLuckyItemList.size();
        if (this.textColor == 0) {
            this.mTextPaint.setColor(this.isColorDark(backgroundColor) ? -1 : -16777216);
        }
        Typeface typeface = Typeface.create((Typeface)Typeface.SANS_SERIF, (int)1);
        this.mTextPaint.setTypeface(typeface);
        this.mTextPaint.setTextSize((float)this.mSecondaryTextSize);
        this.mTextPaint.setTextAlign(Paint.Align.LEFT);
        float textWidth = this.mTextPaint.measureText(mStr);
        float initFloat = tmpAngle + 360.0f / (float)arraySize / 2.0f;
        float angle = (float)((double)initFloat * Math.PI / 180.0);
        float secondaryTextLeftOffset = (float)this.getMeasuredWidth() / 25.0f;
        int x = (int)((double)this.mCenter + (double)(this.mRadius / 2 / 2) * Math.cos(angle));
        int y = (int)((double)this.mCenter + (double)(this.mRadius / 2 / 2) * Math.sin(angle));
        RectF rect = new RectF((float)x + textWidth, (float)y, (float)x - textWidth, (float)y);
        Path path = new Path();
        Matrix translateMatrix = new Matrix();
        translateMatrix.setTranslate(secondaryTextLeftOffset, 0.0f);
        path.addRect(rect, Path.Direction.CCW);
        path.transform(translateMatrix);
        path.close();
        canvas.rotate(initFloat + (float)arraySize / 18.0f, (float)x, (float)y);
        canvas.drawTextOnPath(mStr, path, (float)this.mSecondaryTextPadding, this.mTextPaint.getTextSize() / 2.75f, (Paint)this.mTextPaint);
        canvas.restore();
    }

    private float getAngleOfIndexTarget(int index) {
        return 360.0f / (float)this.mLuckyItemList.size() * (float)index;
    }

    public void setRound(int numberOfRound) {
        this.mRoundOfNumber = numberOfRound;
    }

    public void setPredeterminedNumber(int predeterminedNumber) {
        this.predeterminedNumber = predeterminedNumber;
    }

    public void rotateTo(int index) {
        Random rand = new Random();
        this.rotateTo(index, rand.nextInt() * 3 % 2, true);
    }

    @TargetApi(value=22)
    public void rotateTo(final int index, final @SpinRotation int rotation, boolean startSlow) {
        int rotationAssess;
        int n = rotationAssess = rotation <= 0 ? 1 : -1;
        if (this.getRotation() != 0.0f) {
            this.setRotation(this.getRotation() % 360.0f);
            AccelerateInterpolator animationStart = startSlow ? new AccelerateInterpolator() : new LinearInterpolator();
            float multiplier = this.getRotation() > 200.0f ? 2.0f : 1.0f;
            this.animate().setInterpolator((TimeInterpolator)animationStart).setListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                    if (!PielView.this.isRunning) {
                        PielView.this.isRunning = true;
                        PielView.this.mPieRotateListener.onRotationStart();
                    }
                }

                public void onAnimationEnd(Animator animation) {
                    if (PielView.this.isRunning) {
                        PielView.this.rotateTo(index, rotation, false);
                    } else {
                        PielView.this.setRotation(0.0f);
                        PielView.this.rotateTo(index, rotation, false);
                    }
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            }).rotation(720.0f * (float)rotationAssess).start();
            return;
        }
        if (rotationAssess < 0) {
            ++this.mRoundOfNumber;
        }
        float targetAngle = 360.0f * (float)this.mRoundOfNumber * (float)rotationAssess + 270.0f - this.getAngleOfIndexTarget(index) - 360.0f / (float)this.mLuckyItemList.size() / 2.0f;
        this.animate().setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setDuration((long)(this.mRoundOfNumber * 1000) + 900L).setListener(new Animator.AnimatorListener(){

            public void onAnimationStart(Animator animation) {
                PielView.this.isRunning = true;
            }

            public void onAnimationEnd(Animator animation) {
                PielView.this.setRotation(PielView.this.getRotation() % 360.0f);
                if (PielView.this.mPieRotateListener != null) {
                    PielView.this.mPieRotateListener.rotateDone(index);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        }).rotation(targetAngle).start();
    }

    public void stopRotation() {
        this.isRunning = false;
    }

    public boolean isTouchEnabled() {
        return this.touchEnabled;
    }

    public void setTouchEnabled(boolean touchEnabled) {
        this.touchEnabled = touchEnabled;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isRunning || !this.touchEnabled) {
            return false;
        }
        float x = event.getX();
        float y = event.getY();
        float xc = (float)this.getWidth() / 2.0f;
        float yc = (float)this.getHeight() / 2.0f;
        switch (event.getAction()) {
            case 0: {
                this.viewRotation = (this.getRotation() + 360.0f) % 360.0f;
                this.fingerRotation = Math.toDegrees(Math.atan2(x - xc, yc - y));
                this.downPressTime = event.getEventTime();
                return true;
            }
            case 2: {
                double newFingerRotation = Math.toDegrees(Math.atan2(x - xc, yc - y));
                if (this.isRotationConsistent(newFingerRotation)) {
                    this.setRotation(this.newRotationValue(this.viewRotation, this.fingerRotation, newFingerRotation));
                }
                return true;
            }
            case 1: {
                double newFingerRotation = Math.toDegrees(Math.atan2(x - xc, yc - y));
                float computedRotation = this.newRotationValue(this.viewRotation, this.fingerRotation, newFingerRotation);
                this.fingerRotation = newFingerRotation;
                this.upPressTime = event.getEventTime();
                if (this.upPressTime - this.downPressTime > 700L) {
                    return true;
                }
                if (computedRotation <= -250.0f) {
                    computedRotation += 360.0f;
                } else if (computedRotation >= 250.0f) {
                    computedRotation -= 360.0f;
                }
                double flingDiff = computedRotation - this.viewRotation;
                if (flingDiff >= 200.0 || flingDiff <= -200.0) {
                    if (this.viewRotation <= -50.0f) {
                        this.viewRotation += 360.0f;
                    } else if (this.viewRotation >= 50.0f) {
                        this.viewRotation -= 360.0f;
                    }
                }
                if ((flingDiff = (double)(computedRotation - this.viewRotation)) <= -60.0 || flingDiff < 0.0 && flingDiff >= -59.0 && this.upPressTime - this.downPressTime <= 200L) {
                    if (this.predeterminedNumber > -1) {
                        this.rotateTo(this.predeterminedNumber, 1, false);
                    } else {
                        this.rotateTo(this.getFallBackRandomIndex(), 1, false);
                    }
                }
                if (flingDiff >= 60.0 || flingDiff > 0.0 && flingDiff <= 59.0 && this.upPressTime - this.downPressTime <= 200L) {
                    if (this.predeterminedNumber > -1) {
                        this.rotateTo(this.predeterminedNumber, 0, false);
                    } else {
                        this.rotateTo(this.getFallBackRandomIndex(), 0, false);
                    }
                }
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    private float newRotationValue(float originalWheenRotation, double originalFingerRotation, double newFingerRotation) {
        double computationalRotation = newFingerRotation - originalFingerRotation;
        return (originalWheenRotation + (float)computationalRotation + 360.0f) % 360.0f;
    }

    private int getFallBackRandomIndex() {
        Random rand = new Random();
        return rand.nextInt(this.mLuckyItemList.size() - 1) + 0;
    }

    private boolean isRotationConsistent(double newRotValue) {
        double evalValue = newRotValue;
        if (Double.compare(this.newRotationStore[2], this.newRotationStore[1]) != 0) {
            this.newRotationStore[2] = this.newRotationStore[1];
        }
        if (Double.compare(this.newRotationStore[1], this.newRotationStore[0]) != 0) {
            this.newRotationStore[1] = this.newRotationStore[0];
        }
        this.newRotationStore[0] = evalValue;
        return !(Double.compare(this.newRotationStore[2], this.newRotationStore[0]) == 0 || Double.compare(this.newRotationStore[1], this.newRotationStore[0]) == 0 || Double.compare(this.newRotationStore[2], this.newRotationStore[1]) == 0 || this.newRotationStore[0] > this.newRotationStore[1] && this.newRotationStore[1] < this.newRotationStore[2]) && (!(this.newRotationStore[0] < this.newRotationStore[1]) || !(this.newRotationStore[1] > this.newRotationStore[2]));
    }

    public static interface PieRotateListener {
        public void onRotationStart();

        public void rotateDone(int var1);
    }
}

