/*
 * Decompiled with CFR 0.152.
 */
package rubikstudio.library;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import java.util.List;
import java.util.Random;
import rubikstudio.library.LuckyWheelUtils;
import rubikstudio.library.PielView;
import rubikstudio.library.R;
import rubikstudio.library.model.LuckyItem;

public class LuckyWheelView
extends RelativeLayout
implements PielView.PieRotateListener {
    private int mBackgroundColor;
    private int mTextColor;
    private int mTopTextSize;
    private int mSecondaryTextSize;
    private int mBorderColor;
    private int mTopTextPadding;
    private int mSecondaryTextPadding;
    private int mEdgeWidth;
    private Drawable mCenterImage;
    private Drawable mCursorImage;
    private PielView pielView;
    private ImageView ivCursorView;
    private LuckyRoundItemSelectedListener mLuckyRoundItemSelectedListener;

    @Override
    public void onRotationStart() {
        if (this.mLuckyRoundItemSelectedListener != null) {
            this.mLuckyRoundItemSelectedListener.onLuckyWheelRotationStart();
        }
    }

    @Override
    public void rotateDone(int index) {
        if (this.mLuckyRoundItemSelectedListener != null) {
            this.mLuckyRoundItemSelectedListener.LuckyRoundItemSelected(index);
        }
    }

    public void setLuckyRoundItemSelectedListener(LuckyRoundItemSelectedListener listener) {
        this.mLuckyRoundItemSelectedListener = listener;
    }

    public LuckyWheelView(Context context) {
        super(context);
        this.init(context, null);
    }

    public LuckyWheelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(Context ctx, AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = ctx.obtainStyledAttributes(attrs, R.styleable.LuckyWheelView);
            this.mBackgroundColor = typedArray.getColor(R.styleable.LuckyWheelView_lkwBackgroundColor, -3407872);
            this.mTopTextSize = typedArray.getDimensionPixelSize(R.styleable.LuckyWheelView_lkwTopTextSize, (int)LuckyWheelUtils.convertDpToPixel(10.0f, this.getContext()));
            this.mSecondaryTextSize = typedArray.getDimensionPixelSize(R.styleable.LuckyWheelView_lkwSecondaryTextSize, (int)LuckyWheelUtils.convertDpToPixel(20.0f, this.getContext()));
            this.mTextColor = typedArray.getColor(R.styleable.LuckyWheelView_lkwTopTextColor, 0);
            this.mTopTextPadding = typedArray.getDimensionPixelSize(R.styleable.LuckyWheelView_lkwTopTextPadding, (int)LuckyWheelUtils.convertDpToPixel(10.0f, this.getContext())) + (int)LuckyWheelUtils.convertDpToPixel(10.0f, this.getContext());
            this.mSecondaryTextPadding = typedArray.getDimensionPixelSize(R.styleable.LuckyWheelView_lkwSecondaryTextPadding, 0);
            this.mCursorImage = typedArray.getDrawable(R.styleable.LuckyWheelView_lkwCursor);
            this.mCenterImage = typedArray.getDrawable(R.styleable.LuckyWheelView_lkwCenterImage);
            this.mEdgeWidth = typedArray.getInt(R.styleable.LuckyWheelView_lkwEdgeWidth, 10);
            this.mBorderColor = typedArray.getColor(R.styleable.LuckyWheelView_lkwEdgeColor, 0);
            typedArray.recycle();
        }
        LayoutInflater inflater = LayoutInflater.from((Context)this.getContext());
        FrameLayout frameLayout = (FrameLayout)inflater.inflate(R.layout.lucky_wheel_layout, (ViewGroup)this, false);
        this.pielView = (PielView)frameLayout.findViewById(R.id.pieView);
        this.ivCursorView = (ImageView)frameLayout.findViewById(R.id.cursorView);
        this.pielView.setPieRotateListener(this);
        this.pielView.setPieBackgroundColor(this.mBackgroundColor);
        this.pielView.setTopTextPadding(this.mTopTextPadding);
        this.pielView.setTopTextSize(this.mTopTextSize);
        this.pielView.setSecondaryTextSizeSize(this.mSecondaryTextSize);
        this.pielView.setSecondaryTextPadding(this.mSecondaryTextPadding);
        this.pielView.setPieCenterImage(this.mCenterImage);
        this.pielView.setBorderColor(this.mBorderColor);
        this.pielView.setBorderWidth(this.mEdgeWidth);
        if (this.mTextColor != 0) {
            this.pielView.setPieTextColor(this.mTextColor);
        }
        this.ivCursorView.setImageDrawable(this.mCursorImage);
        this.addView((View)frameLayout);
    }

    public boolean isTouchEnabled() {
        return this.pielView.isTouchEnabled();
    }

    public void setTouchEnabled(boolean touchEnabled) {
        this.pielView.setTouchEnabled(touchEnabled);
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!this.isPielView(this.getChildAt(i))) continue;
            return super.dispatchTouchEvent(ev);
        }
        return false;
    }

    private boolean isPielView(View view) {
        if (view instanceof ViewGroup) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                if (!this.isPielView(((ViewGroup)view).getChildAt(i))) continue;
                return true;
            }
        }
        return view instanceof PielView;
    }

    public void setLuckyWheelBackgrouldColor(int color) {
        this.pielView.setPieBackgroundColor(color);
    }

    public void setLuckyWheelCursorImage(int drawable) {
        this.ivCursorView.setBackgroundResource(drawable);
    }

    public void setLuckyWheelCenterImage(Drawable drawable) {
        this.pielView.setPieCenterImage(drawable);
    }

    public void setBorderColor(int color) {
        this.pielView.setBorderColor(color);
    }

    public void setLuckyWheelTextColor(int color) {
        this.pielView.setPieTextColor(color);
    }

    public void setData(List<LuckyItem> data) {
        this.pielView.setData(data);
    }

    public void setRound(int numberOfRound) {
        this.pielView.setRound(numberOfRound);
    }

    public void setPredeterminedNumber(int fixedNumber) {
        this.pielView.setPredeterminedNumber(fixedNumber);
    }

    public void startLuckyWheelWithTargetIndex(int index) {
        this.pielView.rotateTo(index);
    }

    public void startLuckyWheelWithRandomTarget() {
        Random r = new Random();
        this.pielView.rotateTo(r.nextInt(this.pielView.getLuckyItemListSize() - 1));
    }

    public void stopRotation() {
        this.pielView.stopRotation();
    }

    public static interface LuckyRoundItemSelectedListener {
        public void LuckyRoundItemSelected(int var1);

        public void onLuckyWheelRotationStart();
    }
}

