/*
 * Decompiled with CFR 0.152.
 */
package permissions.dispatcher;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import androidx.collection.SimpleArrayMap;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;

public final class PermissionUtils {
    private static final SimpleArrayMap<String, Integer> MIN_SDK_PERMISSIONS = new SimpleArrayMap(13);

    private PermissionUtils() {
    }

    public static boolean verifyPermissions(int ... grantResults) {
        if (grantResults.length == 0) {
            return false;
        }
        for (int result : grantResults) {
            if (result == 0) continue;
            return false;
        }
        return true;
    }

    private static boolean permissionExists(String permission) {
        Integer minVersion = (Integer)MIN_SDK_PERMISSIONS.get((Object)permission);
        return minVersion == null || Build.VERSION.SDK_INT >= minVersion;
    }

    public static boolean hasSelfPermissions(Context context, String ... permissions) {
        for (String permission : permissions) {
            if (!PermissionUtils.permissionExists(permission) || PermissionUtils.hasSelfPermission(context, permission)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasSelfPermission(Context context, String permission) {
        try {
            return ContextCompat.checkSelfPermission((Context)context, (String)permission) == 0;
        }
        catch (RuntimeException t) {
            return false;
        }
    }

    public static boolean shouldShowRequestPermissionRationale(Activity activity, String ... permissions) {
        for (String permission : permissions) {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission)) continue;
            return true;
        }
        return false;
    }

    public static boolean shouldShowRequestPermissionRationale(Fragment fragment, String ... permissions) {
        for (String permission : permissions) {
            if (!fragment.shouldShowRequestPermissionRationale(permission)) continue;
            return true;
        }
        return false;
    }

    static {
        MIN_SDK_PERMISSIONS.put((Object)"com.android.voicemail.permission.ADD_VOICEMAIL", (Object)14);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.READ_CALL_LOG", (Object)16);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.READ_EXTERNAL_STORAGE", (Object)16);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.WRITE_CALL_LOG", (Object)16);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.BODY_SENSORS", (Object)20);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.SYSTEM_ALERT_WINDOW", (Object)23);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.WRITE_SETTINGS", (Object)23);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.READ_PHONE_NUMBERS", (Object)26);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.ANSWER_PHONE_CALLS", (Object)26);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.ACCEPT_HANDOVER", (Object)28);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.ACTIVITY_RECOGNITION", (Object)29);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.ACCESS_MEDIA_LOCATION", (Object)29);
        MIN_SDK_PERMISSIONS.put((Object)"android.permission.ACCESS_BACKGROUND_LOCATION", (Object)29);
    }
}

