/*
 * Decompiled with CFR 0.152.
 */
package permissions.dispatcher;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NoCorrespondingNeedsPermissionDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Issue ISSUE = Issue.create((String)"NoCorrespondingNeedsPermission", (String)"The method annotated with @OnShowRationale has no corresponding @NeedsPermission method, and will therefore be ignored by PermissionsDispatcher", (String)"The @OnShowRationale method with a certain signature is internally connected to another method annotated with @NeedsPermission and the same annotation value. Please ensure that there is a @NeedsPermission method with matching annotation values for this method.", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.ERROR, (Implementation)new Implementation(NoCorrespondingNeedsPermissionDetector.class, EnumSet.of(Scope.JAVA_FILE)));
    static final Set<String> NEEDS_PERMISSION_NAME = new HashSet<String>(){
        {
            this.add("NeedsPermission");
            this.add("permissions.dispatcher.NeedsPermission");
        }
    };
    static final Set<String> ON_SHOW_RATIONALE_NAME = new HashSet<String>(){
        {
            this.add("OnShowRationale");
            this.add("permissions.dispatcher.OnShowRationale");
        }
    };

    public JavaElementVisitor createPsiVisitor(JavaContext context) {
        return new AnnotationChecker(context);
    }

    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        return Collections.singletonList(PsiAnnotation.class);
    }

    static class AnnotationChecker
    extends JavaElementVisitor {
        private final JavaContext context;
        private final Set<PsiAnnotation> needsPermissionAnnotations;
        private final Set<PsiAnnotation> onShowRationaleAnnotations;

        private AnnotationChecker(JavaContext context) {
            this.context = context;
            this.needsPermissionAnnotations = new HashSet<PsiAnnotation>();
            this.onShowRationaleAnnotations = new HashSet<PsiAnnotation>();
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            if (!this.context.isEnabled(ISSUE)) {
                super.visitAnnotation(annotation);
                return;
            }
            String type = annotation.getQualifiedName();
            if (NEEDS_PERMISSION_NAME.contains(type)) {
                this.needsPermissionAnnotations.add(annotation);
            } else if (ON_SHOW_RATIONALE_NAME.contains(type)) {
                this.onShowRationaleAnnotations.add(annotation);
            }
            if (this.onShowRationaleAnnotations.size() <= 0) {
                super.visitAnnotation(annotation);
                return;
            }
            boolean found = false;
            for (PsiAnnotation onShowRationaleAnnotation : this.onShowRationaleAnnotations) {
                for (PsiAnnotation needsPermissionAnnotation : this.needsPermissionAnnotations) {
                    if (!this.hasSameNodes(onShowRationaleAnnotation.getReferences(), needsPermissionAnnotation.getReferences())) continue;
                    found = true;
                }
                if (found) continue;
                this.context.report(ISSUE, this.context.getLocation((PsiElement)onShowRationaleAnnotation), "Useless @OnShowRationale declaration");
            }
            super.visitAnnotation(annotation);
        }

        private boolean hasSameNodes(PsiReference[] first, PsiReference[] second) {
            if (first.length != second.length) {
                return false;
            }
            int size = first.length;
            for (int i = 0; i < size; ++i) {
                if (first[i].toString().equals(second[i].toString())) continue;
                return false;
            }
            return true;
        }
    }
}

