/*
 * Decompiled with CFR 0.152.
 */
package permissions.dispatcher;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiStatement;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CallOnRequestPermissionsResultDetector
extends Detector
implements Detector.JavaPsiScanner {
    public static final Issue ISSUE = Issue.create((String)"NeedOnRequestPermissionsResult", (String)"Call the \"onRequestPermissionsResult\" method of the generated PermissionsDispatcher class in the respective method of your Activity or Fragment", (String)"You are required to inform the generated PermissionsDispatcher class about the results of a permission request. In your class annotated with @RuntimePermissions, override the \"onRequestPermissionsResult\" method and call through to the generated PermissionsDispatcher method with the same name.", (Category)Category.CORRECTNESS, (int)5, (Severity)Severity.ERROR, (Implementation)new Implementation(CallOnRequestPermissionsResultDetector.class, EnumSet.of(Scope.JAVA_FILE)));
    static final Set<String> RUNTIME_PERMISSIONS_NAME = new HashSet<String>(){
        {
            this.add("RuntimePermissions");
            this.add("permissions.dispatcher.RuntimePermissions");
        }
    };

    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        return Arrays.asList(PsiAnnotation.class, PsiClass.class);
    }

    public JavaElementVisitor createPsiVisitor(final JavaContext context) {
        return new JavaElementVisitor(){

            public void visitClass(PsiClass node) {
                node.accept((PsiElementVisitor)new OnRequestPermissionsResultChecker(context, node));
            }
        };
    }

    private static boolean checkMethodCall(PsiMethod method, PsiClass psiClass) {
        PsiStatement[] statements;
        PsiCodeBlock codeBlock = method.getBody();
        if (codeBlock == null) {
            return false;
        }
        for (PsiStatement statement : statements = codeBlock.getStatements()) {
            PsiClass containingClass;
            PsiExpression expression;
            if (!(statement instanceof PsiExpressionStatement) || !((expression = ((PsiExpressionStatement)statement).getExpression()) instanceof PsiCallExpression)) continue;
            PsiCallExpression callExpression = (PsiCallExpression)expression;
            String targetClassName = psiClass.getName() + "PermissionsDispatcher";
            PsiMethod resolveMethod = callExpression.resolveMethod();
            if (resolveMethod == null || (containingClass = resolveMethod.getContainingClass()) == null || !targetClassName.equals(containingClass.getName()) || !"onRequestPermissionsResult".equals(resolveMethod.getName())) continue;
            return true;
        }
        return false;
    }

    private static class OnRequestPermissionsResultChecker
    extends JavaRecursiveElementVisitor {
        private final JavaContext context;
        private boolean hasRuntimePermissionAnnotation;
        private PsiClass psiClass;

        private OnRequestPermissionsResultChecker(JavaContext context, PsiClass psiClass) {
            this.context = context;
            this.psiClass = psiClass;
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            String type = annotation.getQualifiedName();
            if (!RUNTIME_PERMISSIONS_NAME.contains(type)) {
                super.visitAnnotation(annotation);
                return;
            }
            this.hasRuntimePermissionAnnotation = true;
            super.visitAnnotation(annotation);
        }

        public void visitMethod(PsiMethod method) {
            if (!this.hasRuntimePermissionAnnotation) {
                super.visitMethod(method);
                return;
            }
            if (!"onRequestPermissionsResult".equals(method.getName())) {
                super.visitMethod(method);
                return;
            }
            if (this.hasRuntimePermissionAnnotation && !CallOnRequestPermissionsResultDetector.checkMethodCall(method, this.psiClass)) {
                PsiCodeBlock codeBlock = method.getBody();
                this.context.report(ISSUE, this.context.getLocation((PsiElement)method), codeBlock.getText() + "Generated onRequestPermissionsResult method not called");
            }
            super.visitMethod(method);
        }
    }
}

