/*
 * Decompiled with CFR 0.152.
 */
package com.github.perbeatus.spark.google.spreadsheets;

import com.github.perbeatus.spark.google.spreadsheets.SparkSpreadsheetService;
import com.github.perbeatus.spark.google.spreadsheets.SparkSpreadsheetService$;
import com.github.perbeatus.spark.google.spreadsheets.SpreadsheetRelation;
import com.github.perbeatus.spark.google.spreadsheets.SpreadsheetRelation$;
import com.github.perbeatus.spark.google.spreadsheets.Util$;
import java.io.File;
import java.io.Serializable;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.CreatableRelationProvider;
import org.apache.spark.sql.sources.RelationProvider;
import org.apache.spark.sql.sources.SchemaRelationProvider;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005\rc\u0001B\u0006\r\u0001eAQa\r\u0001\u0005\u0002QBqa\u000e\u0001C\u0002\u0013\u0015\u0001\b\u0003\u0004=\u0001\u0001\u0006i!\u000f\u0005\u0006{\u0001!\tE\u0010\u0005\u00071\u0002!\t\u0001D-\t\u000bu\u0002A\u0011\t0\t\u000bu\u0002A\u0011I5\t\u0011\u0005-\u0001\u0001\"\u0001\r\u0003\u001bAq!\u0010\u0001\u0005\u00021\ty\u0002C\u0004>\u0001\u0011\u0005A\"!\r\u0003\u001b\u0011+g-Y;miN{WO]2f\u0015\tia\"\u0001\u0007taJ,\u0017\rZ:iK\u0016$8O\u0003\u0002\u0010!\u00051qm\\8hY\u0016T!!\u0005\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005M!\u0012!\u00039fe\n,\u0017\r^;t\u0015\t)b#\u0001\u0004hSRDWO\u0019\u0006\u0002/\u0005\u00191m\\7\u0004\u0001M)\u0001A\u0007\u0011.aA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\u0004\"!I\u0016\u000e\u0003\tR!a\t\u0013\u0002\u000fM|WO]2fg*\u0011QEJ\u0001\u0004gFd'BA\t(\u0015\tA\u0013&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005\u0019qN]4\n\u00051\u0012#\u0001\u0005*fY\u0006$\u0018n\u001c8Qe>4\u0018\u000eZ3s!\t\tc&\u0003\u00020E\t12k\u00195f[\u0006\u0014V\r\\1uS>t\u0007K]8wS\u0012,'\u000f\u0005\u0002\"c%\u0011!G\t\u0002\u001a\u0007J,\u0017\r^1cY\u0016\u0014V\r\\1uS>t\u0007K]8wS\u0012,'/\u0001\u0004=S:LGO\u0010\u000b\u0002kA\u0011a\u0007A\u0007\u0002\u0019\u00059B)\u0012$B+2#vl\u0011*F\t\u0016sE+S!M?B\u000bE\u000bS\u000b\u0002s=\t!(I\u0001<\u0003eyS\r^20O\u0012\fG/Y\u0018de\u0016$WM\u001c;jC2t\u0003/\r\u001a\u00021\u0011+e)Q+M)~\u001b%+\u0012#F\u001dRK\u0015\tT0Q\u0003RC\u0005%\u0001\bde\u0016\fG/\u001a*fY\u0006$\u0018n\u001c8\u0015\u0007}\u0012\u0005\n\u0005\u00027\u0001&\u0011\u0011\t\u0004\u0002\u0014'B\u0014X-\u00193tQ\u0016,GOU3mCRLwN\u001c\u0005\u0006\u0007\u0012\u0001\r\u0001R\u0001\u000bgFd7i\u001c8uKb$\bCA#G\u001b\u0005!\u0013BA$%\u0005)\u0019\u0016\u000bT\"p]R,\u0007\u0010\u001e\u0005\u0006\u0013\u0012\u0001\rAS\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\b\u0003B&S+Vs!\u0001\u0014)\u0011\u00055cR\"\u0001(\u000b\u0005=C\u0012A\u0002\u001fs_>$h(\u0003\u0002R9\u00051\u0001K]3eK\u001aL!a\u0015+\u0003\u00075\u000b\u0007O\u0003\u0002R9A\u00111JV\u0005\u0003/R\u0013aa\u0015;sS:<\u0017\u0001\u00059bi\"$vn\u00155fKRt\u0015-\\3t)\tQV\f\u0005\u0003\u001c7V+\u0016B\u0001/\u001d\u0005\u0019!V\u000f\u001d7fe!)\u0011*\u0002a\u0001\u0015R!qh\u00181b\u0011\u0015\u0019e\u00011\u0001E\u0011\u0015Ie\u00011\u0001K\u0011\u0015\u0011g\u00011\u0001d\u0003\u0019\u00198\r[3nCB\u0011AmZ\u0007\u0002K*\u0011a\rJ\u0001\u0006if\u0004Xm]\u0005\u0003Q\u0016\u0014!b\u0015;sk\u000e$H+\u001f9f)\u0015QWN\\:u!\t\t3.\u0003\u0002mE\ta!)Y:f%\u0016d\u0017\r^5p]\")1i\u0002a\u0001\t\")qn\u0002a\u0001a\u0006!Qn\u001c3f!\t)\u0015/\u0003\u0002sI\tA1+\u0019<f\u001b>$W\rC\u0003J\u000f\u0001\u0007!\nC\u0003v\u000f\u0001\u0007a/\u0001\u0003eCR\f\u0007cA<\u0002\u00069\u0019\u00010!\u0001\u000f\u0005e|hB\u0001>\u007f\u001d\tYXP\u0004\u0002Ny&\t!&\u0003\u0002)S%\u0011\u0011cJ\u0005\u0003K\u0019J1!a\u0001%\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u0002\u0002\n\tIA)\u0019;b\rJ\fW.\u001a\u0006\u0004\u0003\u0007!\u0013\u0001G2sK\u0006$Xm\u00159sK\u0006$7\u000f[3fi\u000e{g\u000e^3yiR!\u0011qBA\u000f!\u0011\t\t\"a\u0006\u000f\u0007Y\n\u0019\"C\u0002\u0002\u00161\tqc\u00159be.\u001c\u0006O]3bINDW-\u001a;TKJ4\u0018nY3\n\t\u0005e\u00111\u0004\u0002\u0018'B\f'o[*qe\u0016\fGm\u001d5fKR\u001cuN\u001c;fqRT1!!\u0006\r\u0011\u0015I\u0005\u00021\u0001K)-y\u0014\u0011EA\u0012\u0003O\tY#a\f\t\u000b\rK\u0001\u0019\u0001#\t\u000f\u0005\u0015\u0012\u00021\u0001\u0002\u0010\u000591m\u001c8uKb$\bBBA\u0015\u0013\u0001\u0007Q+A\btaJ,\u0017\rZ:iK\u0016$h*Y7f\u0011\u0019\ti#\u0003a\u0001+\u0006iqo\u001c:lg\",W\r\u001e(b[\u0016DQAY\u0005A\u0002\r$2bPA\u001a\u0003k\t9$!\u000f\u0002<!)1I\u0003a\u0001\t\"9\u0011Q\u0005\u0006A\u0002\u0005=\u0001BBA\u0015\u0015\u0001\u0007Q\u000b\u0003\u0004\u0002.)\u0001\r!\u0016\u0005\u0007E*\u0001\r!!\u0010\u0011\tm\tydY\u0005\u0004\u0003\u0003b\"AB(qi&|g\u000e")
public class DefaultSource
implements RelationProvider,
SchemaRelationProvider,
CreatableRelationProvider {
    public final String DEFAULT_CREDENTIAL_PATH() {
        return "/etc/gdata/credential.p12";
    }

    public SpreadsheetRelation createRelation(SQLContext sqlContext, Map<String, String> parameters) {
        return this.createRelation(sqlContext, (Map)parameters, (StructType)null);
    }

    public Tuple2<String, String> pathToSheetNames(Map<String, String> parameters) {
        String path = (String)parameters.getOrElse((Object)"path", (Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.error("'path' must be specified for spreadsheets."));
        String[] elems = new StringOps(Predef$.MODULE$.augmentString(path)).split('/');
        if (elems.length < 2) {
            throw new Exception("'path' must be formed like '<spreadsheet>/<worksheet>'");
        }
        return new Tuple2((Object)elems[0], (Object)elems[1]);
    }

    public SpreadsheetRelation createRelation(SQLContext sqlContext, Map<String, String> parameters, StructType schema) {
        Tuple2<String, String> tuple2 = this.pathToSheetNames(parameters);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String spreadsheetName = (String)tuple2._1();
        String worksheetName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)spreadsheetName, (Object)worksheetName);
        Tuple2 tuple23 = tuple22;
        String spreadsheetName2 = (String)tuple23._1();
        String worksheetName2 = (String)tuple23._2();
        SparkSpreadsheetService.SparkSpreadsheetContext context = this.createSpreadsheetContext(parameters);
        return this.createRelation(sqlContext, context, spreadsheetName2, worksheetName2, schema);
    }

    public BaseRelation createRelation(SQLContext sqlContext, SaveMode mode, Map<String, String> parameters, Dataset<Row> data) {
        Tuple2<String, String> tuple2 = this.pathToSheetNames(parameters);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        String spreadsheetName = (String)tuple2._1();
        String worksheetName = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)spreadsheetName, (Object)worksheetName);
        Tuple2 tuple23 = tuple22;
        String spreadsheetName2 = (String)tuple23._1();
        String worksheetName2 = (String)tuple23._2();
        SparkSpreadsheetService.SparkSpreadsheetContext context = this.createSpreadsheetContext(parameters);
        Option<SparkSpreadsheetService.SparkSpreadsheet> spreadsheet = SparkSpreadsheetService$.MODULE$.findSpreadsheet(spreadsheetName2, context);
        if (!spreadsheet.isDefined()) {
            throw new RuntimeException(new StringBuilder(23).append("no such a spreadsheet: ").append(spreadsheetName2).toString());
        }
        ((SparkSpreadsheetService.SparkSpreadsheet)spreadsheet.get()).addWorksheet(worksheetName2, data.schema(), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])data.collect())).toList(), (Function1 & Serializable & scala.Serializable)row -> Util$.MODULE$.toRowData((Row)row));
        return this.createRelation(sqlContext, context, spreadsheetName2, worksheetName2, data.schema());
    }

    public SparkSpreadsheetService.SparkSpreadsheetContext createSpreadsheetContext(Map<String, String> parameters) {
        Option serviceAccountIdOption = parameters.get((Object)"serviceAccountId");
        String credentialPath = (String)parameters.getOrElse((Object)"credentialPath", (Function0 & Serializable & scala.Serializable)() -> "/etc/gdata/credential.p12");
        return SparkSpreadsheetService$.MODULE$.apply((Option<String>)serviceAccountIdOption, new File(credentialPath));
    }

    public SpreadsheetRelation createRelation(SQLContext sqlContext, SparkSpreadsheetService.SparkSpreadsheetContext context, String spreadsheetName, String worksheetName, StructType schema) {
        return schema == null ? this.createRelation(sqlContext, context, spreadsheetName, worksheetName, (Option<StructType>)None$.MODULE$) : this.createRelation(sqlContext, context, spreadsheetName, worksheetName, (Option<StructType>)new Some((Object)schema));
    }

    public SpreadsheetRelation createRelation(SQLContext sqlContext, SparkSpreadsheetService.SparkSpreadsheetContext context, String spreadsheetName, String worksheetName, Option<StructType> schema) {
        return SpreadsheetRelation$.MODULE$.apply(context, spreadsheetName, worksheetName, schema, sqlContext);
    }
}

