/*
 * Decompiled with CFR 0.152.
 */
package com.pepperonas.materialdialog.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;
import android.util.LruCache;

public class TypefaceSpan
extends MetricAffectingSpan {
    private static LruCache<String, Typeface> sTypefaceCache = new LruCache(12);
    private Typeface mTypeface;

    public TypefaceSpan(Context context, String typefaceName) {
        this.mTypeface = (Typeface)sTypefaceCache.get((Object)typefaceName);
        if (this.mTypeface == null) {
            this.mTypeface = Typeface.createFromAsset((AssetManager)context.getApplicationContext().getAssets(), (String)typefaceName);
            sTypefaceCache.put((Object)typefaceName, (Object)this.mTypeface);
        }
    }

    public TypefaceSpan(Typeface typeface) {
        this.mTypeface = typeface;
    }

    public void updateMeasureState(TextPaint p) {
        p.setTypeface(this.mTypeface);
        p.setFlags(p.getFlags() | 0x80);
    }

    public void updateDrawState(TextPaint tp) {
        tp.setTypeface(this.mTypeface);
        tp.setFlags(tp.getFlags() | 0x80);
    }
}

