/*
 * Decompiled with CFR 0.152.
 */
package com.pepperonas.materialdialog.adapter;

import android.content.Context;
import android.graphics.Typeface;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.pepperonas.materialdialog.MaterialDialog;
import com.pepperonas.materialdialog.R;
import java.io.File;
import java.util.List;

public class FileChooserArrayAdapter
extends ArrayAdapter<File> {
    private MaterialDialog mMaterialDialog;
    private boolean mDismissOnSelection = false;
    private LayoutInflater mInflater;
    private List<File> mFiles;
    private MaterialDialog.ItemClickListener mItemClickListener;
    private MaterialDialog.ItemLongClickListener mItemLongClickListener;
    private Typeface mTypeface;

    public FileChooserArrayAdapter(@NonNull MaterialDialog materialDialog, @NonNull Context context, @NonNull List<File> strings, @NonNull File startPath, @Nullable MaterialDialog.ItemClickListener itemClickListener, @Nullable MaterialDialog.ItemLongClickListener itemLongClickListener, boolean dismissOnSelection, Typeface typeface) {
        super(context, R.layout.custom_list_item, strings);
        this.mMaterialDialog = materialDialog;
        this.mDismissOnSelection = dismissOnSelection;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mFiles = strings;
        this.mItemClickListener = itemClickListener;
        this.mItemLongClickListener = itemLongClickListener;
        this.mTypeface = typeface;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        View row = convertView;
        if (row == null) {
            row = this.mInflater.inflate(R.layout.custom_list_item, parent, false);
            LinearLayout linearLayout = (LinearLayout)row.findViewById(R.id.ll_simple_list_item);
            TextView tv = (TextView)row.findViewById(R.id.tv_simple_list_item);
            if (this.mTypeface != null) {
                tv.setTypeface(this.mTypeface);
            }
            viewHolder = new ViewHolder();
            viewHolder.linearLayout = linearLayout;
            viewHolder.tv = tv;
            row.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)row.getTag();
        }
        final View finalRow = row;
        viewHolder.linearLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (FileChooserArrayAdapter.this.mItemClickListener != null) {
                    FileChooserArrayAdapter.this.mItemClickListener.onClick(finalRow, position, finalRow.getId());
                    if (FileChooserArrayAdapter.this.mDismissOnSelection) {
                        FileChooserArrayAdapter.this.mMaterialDialog.dismiss();
                    }
                }
                if (FileChooserArrayAdapter.this.mItemLongClickListener != null) {
                    FileChooserArrayAdapter.this.mItemLongClickListener.onLongClick(finalRow, position, finalRow.getId());
                    if (FileChooserArrayAdapter.this.mDismissOnSelection) {
                        FileChooserArrayAdapter.this.mMaterialDialog.dismiss();
                    }
                }
            }
        });
        viewHolder.tv.setText((CharSequence)this.mFiles.get(position).getName());
        viewHolder.tv.setTag((Object)position);
        return row;
    }

    static class ViewHolder {
        LinearLayout linearLayout;
        TextView tv;

        ViewHolder() {
        }
    }
}

