/*
 * Decompiled with CFR 0.152.
 */
package com.pepperonas.materialdialog.adapter;

import android.content.Context;
import android.graphics.Typeface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.TextView;
import com.pepperonas.materialdialog.MaterialDialog;
import com.pepperonas.materialdialog.R;

public class CustomSingleSelectionArrayAdapter
extends ArrayAdapter<String> {
    private static final String TAG = "SingleSelectionAdapter";
    private LayoutInflater mInflater;
    private CharSequence[] mStrings;
    private int mSelectedPosition = -1;
    private MaterialDialog.ItemClickListener mItemClickListener;
    private MaterialDialog.ItemLongClickListener mItemLongClickListener;
    private Typeface mTypeface;

    public CustomSingleSelectionArrayAdapter(Context context, String[] strings, int selectedPosition, MaterialDialog.ItemClickListener itemClickListener, MaterialDialog.ItemLongClickListener itemLongClickListener, Typeface typeface) {
        super(context, R.layout.custom_list_item_single_selection, (Object[])strings);
        this.init(context, strings, selectedPosition, itemClickListener, typeface);
    }

    private void init(Context context, String[] strings, int selectedPosition, MaterialDialog.ItemClickListener itemClickListener, Typeface typeface) {
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mStrings = strings;
        this.mSelectedPosition = selectedPosition;
        this.mItemClickListener = itemClickListener;
        this.mTypeface = typeface;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        View row = convertView;
        if (row == null) {
            row = this.mInflater.inflate(R.layout.custom_list_item_single_selection, parent, false);
            LinearLayout linearLayout = (LinearLayout)row.findViewById(R.id.ll_simple_list_item_single_selection);
            RadioButton rbtn = (RadioButton)row.findViewById(R.id.rb_simple_list_item_single_selection);
            TextView tv = (TextView)row.findViewById(R.id.tv_simple_list_item_single_selection);
            if (this.mTypeface != null) {
                rbtn.setTypeface(this.mTypeface);
                tv.setTypeface(this.mTypeface);
            }
            viewHolder = new ViewHolder();
            viewHolder.linearLayout = linearLayout;
            viewHolder.rbtn = rbtn;
            viewHolder.tv = tv;
            row.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)row.getTag();
        }
        final View finalRow = row;
        viewHolder.rbtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                CustomSingleSelectionArrayAdapter.this.mSelectedPosition = (Integer)v.getTag();
                CustomSingleSelectionArrayAdapter.this.notifyDataSetChanged();
                if (CustomSingleSelectionArrayAdapter.this.mItemClickListener != null) {
                    CustomSingleSelectionArrayAdapter.this.mItemClickListener.onClick(finalRow, position, finalRow.getId());
                }
                if (CustomSingleSelectionArrayAdapter.this.mItemLongClickListener != null) {
                    CustomSingleSelectionArrayAdapter.this.mItemLongClickListener.onLongClick(finalRow, position, finalRow.getId());
                }
            }
        });
        viewHolder.linearLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RadioButton tmpRbtn = (RadioButton)v.findViewById(R.id.rb_simple_list_item_single_selection);
                CustomSingleSelectionArrayAdapter.this.mSelectedPosition = (Integer)tmpRbtn.getTag();
                CustomSingleSelectionArrayAdapter.this.notifyDataSetChanged();
                if (CustomSingleSelectionArrayAdapter.this.mItemClickListener != null) {
                    CustomSingleSelectionArrayAdapter.this.mItemClickListener.onClick(finalRow, position, finalRow.getId());
                }
                if (CustomSingleSelectionArrayAdapter.this.mItemLongClickListener != null) {
                    CustomSingleSelectionArrayAdapter.this.mItemLongClickListener.onLongClick(finalRow, position, finalRow.getId());
                }
            }
        });
        viewHolder.rbtn.setChecked(position == this.mSelectedPosition);
        viewHolder.tv.setText(this.mStrings[position]);
        viewHolder.rbtn.setTag((Object)position);
        viewHolder.tv.setTag((Object)position);
        return row;
    }

    static class ViewHolder {
        LinearLayout linearLayout;
        RadioButton rbtn;
        TextView tv;

        ViewHolder() {
        }
    }
}

