/*
 * Decompiled with CFR 0.152.
 */
package com.github.pengrad.mapscaleview;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.ColorInt;
import com.github.pengrad.mapscaleview.Drawer;
import com.github.pengrad.mapscaleview.MapScaleModel;
import com.github.pengrad.mapscaleview.Scale;
import com.github.pengrad.mapscaleview.Scales;
import com.github.pengrad.mapscaleview.ViewConfig;

public class MapScaleView
extends View {
    private final MapScaleModel mapScaleModel;
    private final Drawer drawer;
    private final int maxWidth;
    private ScaleType scaleType = ScaleType.BOTH;

    public MapScaleView(Context context) {
        this(context, null);
    }

    public MapScaleView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MapScaleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        float density = this.getResources().getDisplayMetrics().density;
        this.mapScaleModel = new MapScaleModel(density);
        ViewConfig viewConfig = new ViewConfig(context, attrs);
        this.drawer = new Drawer(viewConfig.color, viewConfig.textSize, viewConfig.strokeWidth, density, viewConfig.outline, viewConfig.expandRtl);
        this.maxWidth = viewConfig.maxWidth;
        if (viewConfig.isMiles) {
            this.scaleType = ScaleType.MILES_ONLY;
        }
    }

    public void setColor(@ColorInt int color) {
        this.drawer.setColor(color);
        this.invalidate();
    }

    public void setTextSize(float textSize) {
        this.drawer.setTextSize(textSize);
        this.invalidate();
        this.requestLayout();
    }

    public void setStrokeWidth(float strokeWidth) {
        this.drawer.setStrokeWidth(strokeWidth);
        this.invalidate();
        this.requestLayout();
    }

    public void setOutlineEnabled(boolean enabled) {
        this.drawer.setOutlineEnabled(enabled);
        this.invalidate();
    }

    public void setExpandRtlEnabled(boolean enabled) {
        this.drawer.setExpandRtlEnabled(enabled);
        this.invalidate();
    }

    @Deprecated
    public void setIsMiles(boolean miles) {
        if (miles) {
            this.milesOnly();
        } else {
            this.metersAndMiles();
        }
    }

    public void metersOnly() {
        this.scaleType = ScaleType.METERS_ONLY;
        this.updateScales();
    }

    public void milesOnly() {
        this.scaleType = ScaleType.MILES_ONLY;
        this.updateScales();
    }

    public void metersAndMiles() {
        this.scaleType = ScaleType.BOTH;
        this.updateScales();
    }

    public void update(float zoom, double latitude) {
        this.mapScaleModel.setPosition(zoom, latitude);
        this.updateScales();
    }

    private void updateScales() {
        Scale top;
        Scale bottom = null;
        if (this.scaleType == ScaleType.MILES_ONLY) {
            top = this.mapScaleModel.update(false);
        } else {
            top = this.mapScaleModel.update(true);
            if (this.scaleType == ScaleType.BOTH) {
                bottom = this.mapScaleModel.update(false);
            }
        }
        this.drawer.setScales(new Scales(top, bottom));
        this.invalidate();
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.measureDimension(this.desiredWidth(), widthMeasureSpec);
        int height = this.measureDimension(this.desiredHeight(), heightMeasureSpec);
        if (this.mapScaleModel.updateMaxWidth(width)) {
            this.updateScales();
        }
        if (View.MeasureSpec.getMode((int)widthMeasureSpec) != 0x40000000) {
            width = this.drawer.getWidth();
        }
        this.drawer.setViewWidth(width);
        this.setMeasuredDimension(width, height);
    }

    private int desiredWidth() {
        return this.maxWidth;
    }

    private int desiredHeight() {
        return this.drawer.getHeight();
    }

    private int measureDimension(int desiredSize, int measureSpec) {
        int mode = View.MeasureSpec.getMode((int)measureSpec);
        int size = View.MeasureSpec.getSize((int)measureSpec);
        if (mode == 0x40000000) {
            return size;
        }
        if (mode == Integer.MIN_VALUE) {
            return Math.min(desiredSize, size);
        }
        return desiredSize;
    }

    public void onDraw(Canvas canvas) {
        this.drawer.draw(canvas);
    }

    private static enum ScaleType {
        METERS_ONLY,
        MILES_ONLY,
        BOTH;

    }
}

