/*
 * Decompiled with CFR 0.152.
 */
package com.pengrad.telegrambot.passport;

import com.google.gson.Gson;
import com.pengrad.telegrambot.TelegramBot;
import com.pengrad.telegrambot.model.File;
import com.pengrad.telegrambot.passport.Credentials;
import com.pengrad.telegrambot.passport.DataCredentials;
import com.pengrad.telegrambot.passport.DecryptedData;
import com.pengrad.telegrambot.passport.FileCredentials;
import com.pengrad.telegrambot.passport.IdDocumentData;
import com.pengrad.telegrambot.passport.PassportFile;
import com.pengrad.telegrambot.passport.PersonalDetails;
import com.pengrad.telegrambot.passport.ResidentialAddress;
import com.pengrad.telegrambot.passport.SecureValue;
import com.pengrad.telegrambot.passport.decrypt.Decrypt;
import com.pengrad.telegrambot.request.GetFile;
import java.io.Serializable;
import java.util.Arrays;

public class EncryptedPassportElement
implements Serializable {
    private static final long serialVersionUID = 0L;
    private Type type;
    private String data;
    private String phone_number;
    private String email;
    private PassportFile[] files;
    private PassportFile front_side;
    private PassportFile reverse_side;
    private PassportFile selfie;
    private PassportFile[] translation;
    private String hash;

    public DecryptedData decryptData(Credentials credentials) throws Exception {
        Class<? extends DecryptedData> clazz = this.dataClass();
        if (clazz == null || this.data == null) {
            return null;
        }
        SecureValue secureValue = credentials.secureData().ofType(this.type);
        DataCredentials dataCredentials = secureValue.data();
        String dataStr = Decrypt.decryptData(this.data, dataCredentials.dataHash(), dataCredentials.secret());
        return (DecryptedData)new Gson().fromJson(dataStr, clazz);
    }

    public byte[] decryptFile(PassportFile passportFile, FileCredentials fileCredentials, TelegramBot bot) throws Exception {
        File file = bot.execute(new GetFile(passportFile.fileId())).file();
        byte[] fileData = bot.getFileContent(file);
        return this.decryptFile(fileData, fileCredentials);
    }

    public byte[] decryptFile(PassportFile passportFile, Credentials credentials, TelegramBot bot) throws Exception {
        FileCredentials fileCredentials = this.findFileCredentials(passportFile, credentials);
        if (fileCredentials == null) {
            throw new IllegalArgumentException("Don't have file credentials for " + passportFile);
        }
        return this.decryptFile(passportFile, fileCredentials, bot);
    }

    public byte[] decryptFile(byte[] fileData, FileCredentials fileCredentials) throws Exception {
        return Decrypt.decryptFile(fileData, fileCredentials.fileHash(), fileCredentials.secret());
    }

    private FileCredentials findFileCredentials(PassportFile passportFile, Credentials credentials) {
        int i;
        SecureValue secureValue = credentials.secureData().ofType(this.type);
        if (passportFile.equals(this.front_side)) {
            return secureValue.frontSide();
        }
        if (passportFile.equals(this.reverse_side)) {
            return secureValue.reverseSide();
        }
        if (passportFile.equals(this.selfie)) {
            return secureValue.selfie();
        }
        if (this.files != null) {
            for (i = 0; i < this.files.length; ++i) {
                if (!passportFile.equals(this.files[i])) continue;
                return secureValue.files()[i];
            }
        }
        if (this.translation != null) {
            for (i = 0; i < this.translation.length; ++i) {
                if (!passportFile.equals(this.translation[i])) continue;
                return secureValue.translation()[i];
            }
        }
        return null;
    }

    private Class<? extends DecryptedData> dataClass() {
        if (Type.personal_details == this.type) {
            return PersonalDetails.class;
        }
        if (Type.passport == this.type) {
            return IdDocumentData.class;
        }
        if (Type.internal_passport == this.type) {
            return IdDocumentData.class;
        }
        if (Type.driver_license == this.type) {
            return IdDocumentData.class;
        }
        if (Type.identity_card == this.type) {
            return IdDocumentData.class;
        }
        if (Type.address == this.type) {
            return ResidentialAddress.class;
        }
        return null;
    }

    public Type type() {
        return this.type;
    }

    public String data() {
        return this.data;
    }

    public String phoneNumber() {
        return this.phone_number;
    }

    public String email() {
        return this.email;
    }

    public PassportFile[] files() {
        return this.files;
    }

    public PassportFile frontSide() {
        return this.front_side;
    }

    public PassportFile reverseSide() {
        return this.reverse_side;
    }

    public PassportFile selfie() {
        return this.selfie;
    }

    public PassportFile[] translation() {
        return this.translation;
    }

    public String hash() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptedPassportElement that = (EncryptedPassportElement)o;
        if (this.type != that.type) {
            return false;
        }
        if (this.data != null ? !this.data.equals(that.data) : that.data != null) {
            return false;
        }
        if (this.phone_number != null ? !this.phone_number.equals(that.phone_number) : that.phone_number != null) {
            return false;
        }
        if (this.email != null ? !this.email.equals(that.email) : that.email != null) {
            return false;
        }
        if (!Arrays.equals(this.files, that.files)) {
            return false;
        }
        if (this.front_side != null ? !this.front_side.equals(that.front_side) : that.front_side != null) {
            return false;
        }
        if (this.reverse_side != null ? !this.reverse_side.equals(that.reverse_side) : that.reverse_side != null) {
            return false;
        }
        if (this.selfie != null ? !this.selfie.equals(that.selfie) : that.selfie != null) {
            return false;
        }
        if (!Arrays.equals(this.translation, that.translation)) {
            return false;
        }
        return this.hash != null ? this.hash.equals(that.hash) : that.hash == null;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        result = 31 * result + (this.phone_number != null ? this.phone_number.hashCode() : 0);
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.files);
        result = 31 * result + (this.front_side != null ? this.front_side.hashCode() : 0);
        result = 31 * result + (this.reverse_side != null ? this.reverse_side.hashCode() : 0);
        result = 31 * result + (this.selfie != null ? this.selfie.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.translation);
        result = 31 * result + (this.hash != null ? this.hash.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "EncryptedPassportElement{type=" + (Object)((Object)this.type) + ", data='" + this.data + '\'' + ", phone_number='" + this.phone_number + '\'' + ", email='" + this.email + '\'' + ", files=" + Arrays.toString(this.files) + ", front_side=" + this.front_side + ", reverse_side=" + this.reverse_side + ", selfie=" + this.selfie + ", translation=" + Arrays.toString(this.translation) + ", hash='" + this.hash + '\'' + '}';
    }

    public static enum Type {
        personal_details,
        passport,
        driver_license,
        identity_card,
        internal_passport,
        address,
        utility_bill,
        bank_statement,
        rental_agreement,
        passport_registration,
        temporary_registration,
        phone_number,
        email;

    }
}

