/*
 * Decompiled with CFR 0.152.
 */
package com.github.pengfeizhou.jscore;

import com.github.pengfeizhou.jscore.Encoding;
import com.github.pengfeizhou.jscore.JavaValue;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONBuilder {
    private final JSONObject jsonObject;

    public JSONBuilder() {
        this.jsonObject = new JSONObject();
    }

    public JSONBuilder(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
    }

    public JSONBuilder put(String key, Object val) {
        try {
            if (val == null) {
                this.jsonObject.put(key, JSONObject.NULL);
            } else if (val instanceof Encoding) {
                this.jsonObject.put(key, (Object)((Encoding)val).encode());
            } else if (val instanceof Encoding[]) {
                JSONArray jsonArray = new JSONArray();
                for (Encoding object : (Encoding[])val) {
                    jsonArray.put((Object)object.encode());
                }
                this.jsonObject.put(key, (Object)jsonArray);
            } else {
                this.jsonObject.put(key, val);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this;
    }

    public String toString() {
        return this.jsonObject.toString();
    }

    public JSONObject toJSONObject() {
        return this.jsonObject;
    }

    public JavaValue toValue() {
        return new JavaValue(this.jsonObject);
    }
}

