package com.github.pengfeizhou.jscore;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 * Define js Object
 * Created by pengfei.zhou on 2018/12/12.
 */
public class JSObject extends JSValue {
    private final Map<String, JSValue> mVal;

    public JSObject() {
        this.mVal = new HashMap<>();
    }

    public void setProperty(String name, JSValue val) {
        this.mVal.put(name, val);
    }

    public JSValue getProperty(String name) {
        JSValue jsValue = this.mVal.get(name);
        if (jsValue == null) {
            jsValue = new JSNull();
        }
        return jsValue;
    }

    @Override
    public JSType getJSType() {
        return JSType.Object;
    }

    @Override
    public Map<String, JSValue> value() {
        return mVal;
    }

    public Set<String> propertySet() {
        return mVal.keySet();
    }
}
