/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.gif.decode;

import android.content.Context;
import com.github.penfeizhou.animation.gif.decode.Block;
import com.github.penfeizhou.animation.gif.decode.ColorTable;
import com.github.penfeizhou.animation.gif.decode.ExtensionBlock;
import com.github.penfeizhou.animation.gif.decode.ImageDescriptor;
import com.github.penfeizhou.animation.gif.decode.LogicalScreenDescriptor;
import com.github.penfeizhou.animation.gif.io.GifReader;
import com.github.penfeizhou.animation.io.Reader;
import com.github.penfeizhou.animation.io.StreamReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class GifParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGif(String filePath) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(filePath);
            boolean bl = GifParser.isGif((Reader)new StreamReader((InputStream)inputStream));
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGif(Context context, String assetPath) {
        InputStream inputStream = null;
        try {
            inputStream = context.getAssets().open(assetPath);
            boolean bl = GifParser.isGif((Reader)new StreamReader(inputStream));
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGif(Context context, int resId) {
        InputStream inputStream = null;
        try {
            inputStream = context.getResources().openRawResource(resId);
            boolean bl = GifParser.isGif((Reader)new StreamReader(inputStream));
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean isGif(Reader reader) {
        try {
            GifReader gifReader = reader instanceof GifReader ? (GifReader)reader : new GifReader(reader);
            GifParser.checkHeader(gifReader);
            return true;
        }
        catch (IOException e) {
            if (!(e instanceof FormatException)) {
                e.printStackTrace();
            }
            return false;
        }
    }

    public static List<Block> parse(GifReader reader) throws IOException {
        byte flag;
        GifParser.checkHeader(reader);
        ArrayList<Block> blocks = new ArrayList<Block>();
        LogicalScreenDescriptor logicalScreenDescriptor = new LogicalScreenDescriptor();
        logicalScreenDescriptor.receive(reader);
        blocks.add(logicalScreenDescriptor);
        if (logicalScreenDescriptor.gColorTableFlag()) {
            ColorTable globalColorTable = new ColorTable(logicalScreenDescriptor.gColorTableSize());
            globalColorTable.receive(reader);
            blocks.add(globalColorTable);
        }
        while ((flag = reader.peek()) != 59) {
            Block block = null;
            switch (flag) {
                case 33: {
                    block = ExtensionBlock.retrieve(reader);
                    break;
                }
                case 44: {
                    block = new ImageDescriptor();
                }
            }
            if (block != null) {
                block.receive(reader);
                blocks.add(block);
                continue;
            }
            throw new FormatException();
        }
        return blocks;
    }

    private static void checkHeader(GifReader reader) throws IOException {
        byte a;
        if (reader.peek() != 71 || reader.peek() != 73 || reader.peek() != 70 || reader.peek() != 56 || (a = reader.peek()) != 55 && a != 57 || reader.peek() != 97) {
            throw new FormatException();
        }
    }

    static class FormatException
    extends IOException {
        FormatException() {
            super("Gif Format error");
        }
    }
}

