/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.executor;

import android.os.HandlerThread;
import android.os.Looper;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public class FrameDecoderExecutor {
    private static int sPoolNumber = 4;
    private ArrayList<HandlerThread> mHandlerThreadGroup = new ArrayList();
    private AtomicInteger counter = new AtomicInteger(0);

    private FrameDecoderExecutor() {
    }

    public void setPoolSize(int size) {
        sPoolNumber = size;
    }

    public static FrameDecoderExecutor getInstance() {
        return Inner.sInstance;
    }

    public Looper getLooper(int taskId) {
        int idx = taskId % sPoolNumber;
        if (idx >= this.mHandlerThreadGroup.size()) {
            HandlerThread handlerThread = new HandlerThread("FrameDecoderExecutor-" + idx);
            handlerThread.start();
            this.mHandlerThreadGroup.add(handlerThread);
            Looper looper = handlerThread.getLooper();
            if (looper != null) {
                return looper;
            }
            return Looper.getMainLooper();
        }
        if (this.mHandlerThreadGroup.get(idx) != null) {
            Looper looper = this.mHandlerThreadGroup.get(idx).getLooper();
            if (looper != null) {
                return looper;
            }
            return Looper.getMainLooper();
        }
        return Looper.getMainLooper();
    }

    public int generateTaskId() {
        return this.counter.getAndIncrement();
    }

    static class Inner {
        static final FrameDecoderExecutor sInstance = new FrameDecoderExecutor();

        Inner() {
        }
    }
}

