/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.vectordrawable.graphics.drawable.Animatable2Compat;
import com.github.penfeizhou.animation.decode.FrameSeqDecoder;
import com.github.penfeizhou.animation.loader.Loader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Set;

public abstract class FrameAnimationDrawable<Decoder extends FrameSeqDecoder>
extends Drawable
implements Animatable2Compat,
FrameSeqDecoder.RenderListener {
    private static final String TAG = FrameAnimationDrawable.class.getSimpleName();
    private final Paint paint = new Paint();
    private final Decoder frameSeqDecoder;
    private DrawFilter drawFilter = new PaintFlagsDrawFilter(0, 3);
    private Matrix matrix = new Matrix();
    private Set<Animatable2Compat.AnimationCallback> animationCallbacks = new HashSet<Animatable2Compat.AnimationCallback>();
    private Bitmap bitmap;
    private static final int MSG_ANIMATION_START = 1;
    private static final int MSG_ANIMATION_END = 2;
    private Handler uiHandler = new Handler(Looper.getMainLooper()){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    for (Animatable2Compat.AnimationCallback animationCallback : FrameAnimationDrawable.this.animationCallbacks) {
                        animationCallback.onAnimationStart((Drawable)FrameAnimationDrawable.this);
                    }
                    break;
                }
                case 2: {
                    for (Animatable2Compat.AnimationCallback animationCallback : FrameAnimationDrawable.this.animationCallbacks) {
                        animationCallback.onAnimationEnd((Drawable)FrameAnimationDrawable.this);
                    }
                    break;
                }
            }
        }
    };
    private Runnable invalidateRunnable = new Runnable(){

        @Override
        public void run() {
            FrameAnimationDrawable.this.invalidateSelf();
        }
    };
    private boolean autoPlay = true;

    public FrameAnimationDrawable(Decoder frameSeqDecoder) {
        this.paint.setAntiAlias(true);
        this.frameSeqDecoder = frameSeqDecoder;
    }

    public FrameAnimationDrawable(Loader provider) {
        this.paint.setAntiAlias(true);
        this.frameSeqDecoder = this.createFrameSeqDecoder(provider, this);
    }

    public void setAutoPlay(boolean autoPlay) {
        this.autoPlay = autoPlay;
    }

    protected abstract Decoder createFrameSeqDecoder(Loader var1, FrameSeqDecoder.RenderListener var2);

    public void setLoopLimit(int loopLimit) {
        ((FrameSeqDecoder)this.frameSeqDecoder).setLoopLimit(loopLimit);
    }

    public void reset() {
        ((FrameSeqDecoder)this.frameSeqDecoder).reset();
    }

    public void pause() {
        ((FrameSeqDecoder)this.frameSeqDecoder).pause();
    }

    public void resume() {
        ((FrameSeqDecoder)this.frameSeqDecoder).resume();
    }

    public boolean isPaused() {
        return ((FrameSeqDecoder)this.frameSeqDecoder).isPaused();
    }

    public void start() {
        ((FrameSeqDecoder)this.frameSeqDecoder).addRenderListener(this);
        if (this.autoPlay) {
            ((FrameSeqDecoder)this.frameSeqDecoder).start();
        } else if (!((FrameSeqDecoder)this.frameSeqDecoder).isRunning()) {
            ((FrameSeqDecoder)this.frameSeqDecoder).start();
        }
    }

    public void stop() {
        ((FrameSeqDecoder)this.frameSeqDecoder).removeRenderListener(this);
        if (this.autoPlay) {
            ((FrameSeqDecoder)this.frameSeqDecoder).stop();
        } else {
            ((FrameSeqDecoder)this.frameSeqDecoder).stopIfNeeded();
        }
    }

    public boolean isRunning() {
        return ((FrameSeqDecoder)this.frameSeqDecoder).isRunning();
    }

    public void draw(Canvas canvas) {
        if (this.bitmap == null || this.bitmap.isRecycled()) {
            return;
        }
        canvas.setDrawFilter(this.drawFilter);
        canvas.drawBitmap(this.bitmap, this.matrix, this.paint);
    }

    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
        boolean sampleSizeChanged = ((FrameSeqDecoder)this.frameSeqDecoder).setDesiredSize(this.getBounds().width(), this.getBounds().height());
        this.matrix.setScale(1.0f * (float)this.getBounds().width() * (float)((FrameSeqDecoder)this.frameSeqDecoder).getSampleSize() / (float)((FrameSeqDecoder)this.frameSeqDecoder).getBounds().width(), 1.0f * (float)this.getBounds().height() * (float)((FrameSeqDecoder)this.frameSeqDecoder).getSampleSize() / (float)((FrameSeqDecoder)this.frameSeqDecoder).getBounds().height());
        if (sampleSizeChanged) {
            this.bitmap = Bitmap.createBitmap((int)(((FrameSeqDecoder)this.frameSeqDecoder).getBounds().width() / ((FrameSeqDecoder)this.frameSeqDecoder).getSampleSize()), (int)(((FrameSeqDecoder)this.frameSeqDecoder).getBounds().height() / ((FrameSeqDecoder)this.frameSeqDecoder).getSampleSize()), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
    }

    public void setAlpha(int alpha) {
        this.paint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    @Override
    public void onStart() {
        Message.obtain((Handler)this.uiHandler, (int)1).sendToTarget();
    }

    @Override
    public void onRender(ByteBuffer byteBuffer) {
        if (!this.isRunning()) {
            return;
        }
        if (this.bitmap == null || this.bitmap.isRecycled()) {
            this.bitmap = Bitmap.createBitmap((int)(((FrameSeqDecoder)this.frameSeqDecoder).getBounds().width() / ((FrameSeqDecoder)this.frameSeqDecoder).getSampleSize()), (int)(((FrameSeqDecoder)this.frameSeqDecoder).getBounds().height() / ((FrameSeqDecoder)this.frameSeqDecoder).getSampleSize()), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        byteBuffer.rewind();
        if (byteBuffer.remaining() < this.bitmap.getByteCount()) {
            Log.e((String)TAG, (String)"onRender:Buffer not large enough for pixels");
            return;
        }
        this.bitmap.copyPixelsFromBuffer((Buffer)byteBuffer);
        this.uiHandler.post(this.invalidateRunnable);
    }

    @Override
    public void onEnd() {
        Message.obtain((Handler)this.uiHandler, (int)2).sendToTarget();
    }

    public boolean setVisible(boolean visible, boolean restart) {
        if (this.autoPlay) {
            if (visible) {
                if (!this.isRunning()) {
                    this.start();
                }
            } else if (this.isRunning()) {
                this.stop();
            }
        }
        return super.setVisible(visible, restart);
    }

    public int getIntrinsicWidth() {
        try {
            return ((FrameSeqDecoder)this.frameSeqDecoder).getBounds().width();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getIntrinsicHeight() {
        try {
            return ((FrameSeqDecoder)this.frameSeqDecoder).getBounds().height();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public void registerAnimationCallback(@NonNull Animatable2Compat.AnimationCallback animationCallback) {
        this.animationCallbacks.add(animationCallback);
    }

    public boolean unregisterAnimationCallback(@NonNull Animatable2Compat.AnimationCallback animationCallback) {
        return this.animationCallbacks.remove(animationCallback);
    }

    public void clearAnimationCallbacks() {
        this.animationCallbacks.clear();
    }
}

