/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.webp.decode;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Xfermode;
import com.github.penfeizhou.animation.decode.Frame;
import com.github.penfeizhou.animation.io.Reader;
import com.github.penfeizhou.animation.webp.decode.ANMFChunk;
import com.github.penfeizhou.animation.webp.decode.VP8XChunk;
import com.github.penfeizhou.animation.webp.io.WebPReader;
import com.github.penfeizhou.animation.webp.io.WebPWriter;
import java.io.IOException;

public class AnimationFrame
extends Frame<WebPReader, WebPWriter> {
    final int imagePayloadOffset;
    final int imagePayloadSize;
    final boolean blendingMethod;
    final boolean disposalMethod;
    private final boolean useAlpha;
    private static final PorterDuffXfermode PORTERDUFF_XFERMODE_SRC_OVER = new PorterDuffXfermode(PorterDuff.Mode.SRC_OVER);
    private static final PorterDuffXfermode PORTERDUFF_XFERMODE_SRC = new PorterDuffXfermode(PorterDuff.Mode.SRC);

    public AnimationFrame(WebPReader reader, ANMFChunk anmfChunk) {
        super((Reader)reader);
        this.frameWidth = anmfChunk.frameWidth;
        this.frameHeight = anmfChunk.frameHeight;
        this.frameX = anmfChunk.frameX;
        this.frameY = anmfChunk.frameY;
        this.frameDuration = anmfChunk.frameDuration;
        if (this.frameDuration == 0) {
            this.frameDuration = 100;
        }
        this.blendingMethod = anmfChunk.blendingMethod();
        this.disposalMethod = anmfChunk.disposalMethod();
        this.imagePayloadOffset = anmfChunk.offset + 8 + 16;
        this.imagePayloadSize = anmfChunk.payloadSize - 16 + (anmfChunk.payloadSize & 1);
        this.useAlpha = anmfChunk.alphChunk != null;
    }

    private int encode(WebPWriter writer) {
        int vp8xPayloadSize = 10;
        int size = 12 + (8 + vp8xPayloadSize) + this.imagePayloadSize;
        writer.reset(size);
        writer.putFourCC("RIFF");
        writer.putUInt32(size);
        writer.putFourCC("WEBP");
        writer.putUInt32(VP8XChunk.ID);
        writer.putUInt32(vp8xPayloadSize);
        writer.putByte((byte)(this.useAlpha ? 16 : 0));
        writer.putUInt24(0);
        writer.put1Based(this.frameWidth);
        writer.put1Based(this.frameHeight);
        try {
            ((WebPReader)this.reader).reset();
            ((WebPReader)this.reader).skip(this.imagePayloadOffset);
            ((WebPReader)this.reader).read(writer.toByteArray(), writer.position(), this.imagePayloadSize);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return size;
    }

    public Bitmap draw(Canvas canvas, Paint paint, int sampleSize, Bitmap reusedBitmap, WebPWriter writer) {
        Bitmap bitmap;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = false;
        options.inSampleSize = sampleSize;
        options.inMutable = true;
        options.inBitmap = reusedBitmap;
        int length = this.encode(writer);
        byte[] bytes = writer.toByteArray();
        try {
            bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)length, (BitmapFactory.Options)options);
        }
        catch (IllegalArgumentException e) {
            BitmapFactory.Options optionsFixed = new BitmapFactory.Options();
            optionsFixed.inJustDecodeBounds = false;
            optionsFixed.inSampleSize = sampleSize;
            optionsFixed.inMutable = true;
            bitmap = BitmapFactory.decodeByteArray((byte[])bytes, (int)0, (int)length, (BitmapFactory.Options)optionsFixed);
        }
        if (bitmap != null) {
            if (this.blendingMethod) {
                paint.setXfermode((Xfermode)PORTERDUFF_XFERMODE_SRC);
            } else {
                paint.setXfermode((Xfermode)PORTERDUFF_XFERMODE_SRC_OVER);
            }
            this.srcRect.left = 0;
            this.srcRect.top = 0;
            this.srcRect.right = bitmap.getWidth();
            this.srcRect.bottom = bitmap.getHeight();
            this.dstRect.left = (int)((float)this.frameX * 2.0f / (float)sampleSize);
            this.dstRect.top = (int)((float)this.frameY * 2.0f / (float)sampleSize);
            this.dstRect.right = (int)((float)this.frameX * 2.0f / (float)sampleSize + (float)bitmap.getWidth());
            this.dstRect.bottom = (int)((float)this.frameY * 2.0f / (float)sampleSize + (float)bitmap.getHeight());
            canvas.drawBitmap(bitmap, this.srcRect, this.dstRect, paint);
        } else {
            bitmap = reusedBitmap;
        }
        return bitmap;
    }
}

