/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.webp.decode;

import com.github.penfeizhou.animation.webp.decode.ALPHChunk;
import com.github.penfeizhou.animation.webp.decode.BaseChunk;
import com.github.penfeizhou.animation.webp.decode.VP8Chunk;
import com.github.penfeizhou.animation.webp.decode.VP8LChunk;
import com.github.penfeizhou.animation.webp.decode.WebPParser;
import com.github.penfeizhou.animation.webp.io.WebPReader;
import java.io.IOException;

public class ANMFChunk
extends BaseChunk {
    static final int ID = BaseChunk.fourCCToInt("ANMF");
    int frameX;
    int frameY;
    int frameWidth;
    int frameHeight;
    int frameDuration;
    byte flags;
    private static final int FLAG_BLENDING_METHOD = 2;
    private static final int FLAG_DISPOSAL_METHOD = 1;
    ALPHChunk alphChunk;
    VP8Chunk vp8Chunk;
    VP8LChunk vp8LChunk;

    @Override
    void innerParse(WebPReader reader) throws IOException {
        int available = reader.available();
        this.frameX = reader.getUInt24();
        this.frameY = reader.getUInt24();
        this.frameWidth = reader.get1Based();
        this.frameHeight = reader.get1Based();
        this.frameDuration = reader.getUInt24();
        this.flags = reader.peek();
        long bounds = available - this.payloadSize;
        while ((long)reader.available() > bounds) {
            BaseChunk chunk = WebPParser.parseChunk(reader);
            if (chunk instanceof ALPHChunk) {
                assert (this.alphChunk == null);
                this.alphChunk = (ALPHChunk)chunk;
                continue;
            }
            if (chunk instanceof VP8Chunk) {
                assert (this.vp8Chunk == null && this.vp8LChunk == null);
                this.vp8Chunk = (VP8Chunk)chunk;
                continue;
            }
            if (!(chunk instanceof VP8LChunk)) continue;
            assert (this.vp8Chunk == null && this.vp8LChunk == null);
            this.vp8LChunk = (VP8LChunk)chunk;
        }
    }

    boolean blendingMethod() {
        return (this.flags & 2) == 2;
    }

    boolean disposalMethod() {
        return (this.flags & 1) == 1;
    }
}

